/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.draw;

import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.axl.map.SimpleRendererElement;
import com.esri.mo.axl.map.SymbolElement;
import com.esri.mo.data.feat.Feature;
import com.esri.mo.data.feat.Fields;
import com.esri.mo.map.draw.BaseLegendClass;
import com.esri.mo.map.draw.BaseRenderer;
import com.esri.mo.map.draw.BaseSymbol;
import com.esri.mo.map.draw.ColorScheme;
import com.esri.mo.map.draw.IllegalSymbolException;
import com.esri.mo.map.draw.LegendClass;
import com.esri.mo.map.draw.SimpleLineSymbol;
import com.esri.mo.map.draw.SimpleMarkerSymbol;
import com.esri.mo.map.draw.SimplePolygonSymbol;
import com.esri.mo.map.draw.SimpleRenderer;
import com.esri.mo.map.draw.Symbol;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.awt.Graphics2D;
import java.io.IOException;

public class BaseSimpleRenderer
extends BaseRenderer
implements SimpleRenderer {
    private Symbol a;

    public void fromAXL(ElementNode elementNode) throws IOException {
        if (elementNode instanceof SimpleRendererElement) {
            SimpleRendererElement simpleRendererElement = (SimpleRendererElement)elementNode;
            SymbolElement symbolElement = simpleRendererElement.getSymbol();
            if (symbolElement != null) {
                BaseSymbol baseSymbol = BaseSymbol.createSymbolFromAXL(symbolElement);
                this.setSymbol(baseSymbol);
            }
            if (this.getSymbol() == null) {
                throw new IllegalSymbolException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        return;
    }

    public ElementNode toAXL(XmlDocument xmlDocument) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        SimpleRendererElement simpleRendererElement = (SimpleRendererElement)((Object)xmlDocument.createElement("SIMPLERENDERER"));
        if (simpleRendererElement == null) {
            throw new IncompleteDictionaryException();
        }
        Symbol symbol = this.getSymbol();
        if (symbol == null) {
            throw new IllegalSymbolException();
        }
        SymbolElement symbolElement = (SymbolElement)symbol.toAXL(xmlDocument);
        simpleRendererElement.setSymbol(symbolElement);
        if (simpleRendererElement.getSymbol() == null) {
            throw new IOException();
        }
        return simpleRendererElement;
    }

    public Feature getLegendSwatchFeature(int n2) {
        return super.getSampleFeature();
    }

    public LegendClass getLegendClass(int n2) {
        if (n2 != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new BaseLegendClass(this.getSymbol(), "");
    }

    public int getLegendClassCount() {
        return 1;
    }

    public String getLegendSubtitle() {
        return null;
    }

    public Fields getQueryFields() {
        return null;
    }

    public Symbol getSymbol() {
        return this.a;
    }

    public void setSymbol(Symbol symbol) {
        this.a = symbol;
        symbol.setRenderer(this);
        return;
    }

    public void drawSwatch(Graphics2D graphics2D, Feature feature, int n2, int n3) {
        this.drawSymbolForSwatch(graphics2D, this.getSymbol(), n2, n3);
        return;
    }

    public void drawFeature(Graphics2D graphics2D, Feature feature, int n2) {
        feature.draw(graphics2D, this.getSymbol(), n2);
        return;
    }

    public static BaseSimpleRenderer constructDefaultRenderer(ColorScheme colorScheme, int n2) {
        if (colorScheme == null) {
            throw new IllegalArgumentException();
        }
        BaseSymbol baseSymbol = null;
        switch (n2) {
            case 0: {
                SimpleMarkerSymbol simpleMarkerSymbol = new SimpleMarkerSymbol();
                simpleMarkerSymbol.setWidth(6.0);
                simpleMarkerSymbol.setSymbolColor(colorScheme.getNext());
                baseSymbol = simpleMarkerSymbol;
                break;
            }
            case 1: {
                SimpleLineSymbol simpleLineSymbol = new SimpleLineSymbol();
                simpleLineSymbol.setLineColor(colorScheme.getNext());
                baseSymbol = simpleLineSymbol;
                break;
            }
            case 2: {
                SimplePolygonSymbol simplePolygonSymbol = new SimplePolygonSymbol();
                simplePolygonSymbol.setPaint(colorScheme.getNext());
                baseSymbol = simplePolygonSymbol;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        BaseSimpleRenderer baseSimpleRenderer = new BaseSimpleRenderer();
        baseSimpleRenderer.setSymbol(baseSymbol);
        return baseSimpleRenderer;
    }

    public Object clone() {
        BaseSimpleRenderer baseSimpleRenderer = new BaseSimpleRenderer();
        baseSimpleRenderer.setSymbol((Symbol)this.getSymbol().clone());
        return baseSimpleRenderer;
    }
}

