/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.draw;

import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.axl.map.RendererElement;
import com.esri.mo.axl.map.ScaleDependentRendererElement;
import com.esri.mo.axl.map.Util;
import com.esri.mo.data.feat.Cursor;
import com.esri.mo.data.feat.Feature;
import com.esri.mo.data.feat.Fields;
import com.esri.mo.map.dpy.DisplayArea;
import com.esri.mo.map.dpy.FeatureLayer;
import com.esri.mo.map.draw.BaseRenderer;
import com.esri.mo.map.draw.LegendClass;
import com.esri.mo.map.draw.Renderer;
import com.esri.mo.map.draw.ScaleDependentRenderer;
import com.esri.mo.util.Units;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;

public class BaseScaleDependentRenderer
extends BaseRenderer
implements ScaleDependentRenderer {
    private double c = Double.MAX_VALUE;
    private double b = 0.0;
    private Renderer a;

    public void drawSwatch(Graphics2D graphics2D, Feature feature, int n2, int n3) {
    }

    public void fromAXL(ElementNode elementNode) throws IOException {
    }

    public void fromAXL(ElementNode elementNode, int n2) throws IOException {
        double d2;
        double d3;
        if (elementNode instanceof ScaleDependentRendererElement) {
            ScaleDependentRendererElement scaleDependentRendererElement = (ScaleDependentRendererElement)elementNode;
            if (Util.isEmptyAttribute(scaleDependentRendererElement.getLower())) {
                d3 = 0.0;
            } else {
                try {
                    d3 = Units.parseScale(scaleDependentRendererElement.getLower(), n2);
                }
                catch (Exception exception) {
                    throw new IOException();
                }
            }
            if (Util.isEmptyAttribute(scaleDependentRendererElement.getUpper())) {
                d2 = Double.MAX_VALUE;
            } else {
                try {
                    d2 = Units.parseScale(scaleDependentRendererElement.getUpper(), n2);
                }
                catch (Exception exception) {
                    throw new IOException();
                }
            }
            if (d3 < 0.0) {
                d3 = this.getLayer().getMinimumScale();
            }
            if (d2 <= 0.0) {
                d2 = this.getLayer().getMaximumScale();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.setMinimumScale(d3);
        this.setMaximumScale(d2);
        return;
    }

    public ElementNode toAXL(XmlDocument xmlDocument) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        ScaleDependentRendererElement scaleDependentRendererElement = (ScaleDependentRendererElement)((Object)xmlDocument.createElement("SCALEDEPENDENTRENDERER"));
        if (scaleDependentRendererElement == null) {
            throw new IncompleteDictionaryException();
        }
        FeatureLayer featureLayer = this.getLayer();
        int n2 = featureLayer.getLayerset().getDisplayManager().getMapUnit();
        scaleDependentRendererElement.setRenderer((RendererElement)this.getRenderer().toAXL(xmlDocument));
        scaleDependentRendererElement.setLower(Units.convertMapScaleToCartScale(this.getMinimumScale(), n2));
        scaleDependentRendererElement.setUpper(Units.convertMapScaleToCartScale(this.getMaximumScale(), n2));
        if (scaleDependentRendererElement.getRenderer() == null) {
            throw new IOException();
        }
        return scaleDependentRendererElement;
    }

    public Feature getLegendSwatchFeature(int n2) {
        return null;
    }

    public LegendClass getLegendClass(int n2) {
        return null;
    }

    public int getLegendClassCount() {
        return 0;
    }

    public String getLegendSubtitle() {
        return null;
    }

    public Fields getQueryFields() {
        return this.getRenderer().getQueryFields();
    }

    public double getMaximumScale() {
        return this.c;
    }

    public double getMinimumScale() {
        return this.b;
    }

    public void setMaximumScale(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException();
        }
        this.c = d2;
        return;
    }

    public void setMinimumScale(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException();
        }
        this.b = d2;
        return;
    }

    public void setRange(double d2, double d3) {
        this.setMinimumScale(d2);
        this.setMaximumScale(d3);
        return;
    }

    public void setLayer(FeatureLayer featureLayer) {
        super.setLayer(featureLayer);
        if (this.getRenderer() != null) {
            this.getRenderer().setLayer(this.getLayer());
        }
        return;
    }

    public Renderer getRenderer() {
        return this.a;
    }

    public void setRenderer(Renderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException();
        }
        this.a = renderer;
        return;
    }

    public boolean inRange(DisplayArea displayArea) {
        return this.inRange(displayArea.getInverseTransform().getScale());
    }

    public boolean inRange(double d2) {
        return this.b <= d2 && d2 <= this.c;
    }

    public void drawCursor(Graphics2D graphics2D, Cursor cursor, int n2) throws InterruptedException {
        try {
            AffineTransform affineTransform = graphics2D.getTransform().createInverse();
            if (this.inRange(affineTransform.getScaleX())) {
                this.getRenderer().drawCursor(graphics2D, cursor, n2);
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException();
        }
        return;
    }

    public Object clone() {
        BaseScaleDependentRenderer baseScaleDependentRenderer = new BaseScaleDependentRenderer();
        baseScaleDependentRenderer.setRenderer((Renderer)this.getRenderer().clone());
        return baseScaleDependentRenderer;
    }
}

