/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.draw;

import com.esri.mo.cs.geom.BasePath;
import com.esri.mo.cs.geom.BasePointsArray;
import com.esri.mo.cs.geom.BasePolyline;
import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.cs.geom.Point;
import com.esri.mo.data.feat.BaseFeature;
import com.esri.mo.data.feat.BaseFields;
import com.esri.mo.data.feat.Cursor;
import com.esri.mo.data.feat.Feature;
import com.esri.mo.data.feat.Field;
import com.esri.mo.data.feat.Fields;
import com.esri.mo.data.feat.QueryFilter;
import com.esri.mo.data.feat.SelectionSet;
import com.esri.mo.map.dpy.FeatureLayer;
import com.esri.mo.map.draw.ArcFont;
import com.esri.mo.map.draw.GradientFillSymbol;
import com.esri.mo.map.draw.HashLineSymbol;
import com.esri.mo.map.draw.LegendClass;
import com.esri.mo.map.draw.RasterFillSymbol;
import com.esri.mo.map.draw.RasterMarkerSymbol;
import com.esri.mo.map.draw.Renderer;
import com.esri.mo.map.draw.SimpleFillSymbol;
import com.esri.mo.map.draw.SimpleLineSymbol;
import com.esri.mo.map.draw.SimpleMarkerSymbol;
import com.esri.mo.map.draw.SimplePolygonSymbol;
import com.esri.mo.map.draw.Symbol;
import com.esri.mo.map.draw.TrueTypeMarkerSymbol;
import com.esri.mo.util.MessageCentre;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;

public abstract class BaseRenderer
implements Renderer {
    private FeatureLayer a;

    public abstract String getLegendSubtitle();

    public abstract int getLegendClassCount();

    public abstract LegendClass getLegendClass(int var1);

    public abstract Feature getLegendSwatchFeature(int var1);

    public abstract Fields getQueryFields();

    public abstract ElementNode toAXL(XmlDocument var1) throws IOException;

    public abstract void fromAXL(ElementNode var1) throws IOException;

    public abstract void drawSwatch(Graphics2D var1, Feature var2, int var3, int var4);

    protected void drawSymbolForSwatch(Graphics2D graphics2D, Symbol symbol, int n2, int n3) {
        if (symbol == null) {
            return;
        }
        Symbol symbol2 = (Symbol)symbol.clone();
        Point point = new Point(0.5 * (double)n2, 0.5 * (double)n3);
        double d2 = n2;
        double d3 = n3;
        double[] dArray = new double[]{0.0, d2 * 0.45, d2 * 0.55, d2 - 1.0};
        double[] dArray2 = new double[]{d3 - 1.0, d3 * 0.3, d3 * 0.7, 0.0};
        BasePointsArray basePointsArray = new BasePointsArray(dArray, dArray2);
        BasePath basePath = new BasePath(basePointsArray);
        BasePolyline basePolyline = new BasePolyline(1);
        basePolyline.setPath(basePath, 0);
        Envelope envelope = new Envelope(0.0, 0.0, n2 - 1, n3 - 1);
        if (symbol2 instanceof SimpleMarkerSymbol) {
            SimpleMarkerSymbol simpleMarkerSymbol = (SimpleMarkerSymbol)symbol2;
            if (simpleMarkerSymbol.getWidth() > (double)n2) {
                simpleMarkerSymbol.setWidth(n2);
            }
            if (simpleMarkerSymbol.getWidth() < 2.0) {
                simpleMarkerSymbol.setWidth(2.0);
            }
            simpleMarkerSymbol.draw(point, graphics2D, null);
        } else if (symbol2 instanceof TrueTypeMarkerSymbol) {
            TrueTypeMarkerSymbol trueTypeMarkerSymbol = (TrueTypeMarkerSymbol)symbol2;
            ArcFont arcFont = (ArcFont)trueTypeMarkerSymbol.getFont();
            if (arcFont.getSize() > n3) {
                trueTypeMarkerSymbol.setFont(new ArcFont(arcFont.getName(), arcFont.getStyle(), n3));
            }
            trueTypeMarkerSymbol.draw(point, graphics2D, null);
        } else if (symbol2 instanceof RasterMarkerSymbol) {
            int n4;
            RasterMarkerSymbol rasterMarkerSymbol = (RasterMarkerSymbol)symbol2;
            int n5 = rasterMarkerSymbol.getSizeX();
            if (n5 <= 0 || n5 > n2) {
                n5 = n2;
                rasterMarkerSymbol.setSizeX(n5);
            }
            if ((n4 = rasterMarkerSymbol.getSizeY()) <= 0 || n4 > n3) {
                n4 = n3;
                rasterMarkerSymbol.setSizeY(n4);
            }
            rasterMarkerSymbol.setHotSpotX(n2 / 2);
            rasterMarkerSymbol.setHotSpotY(n3 / 2);
            rasterMarkerSymbol.draw(point, graphics2D, null);
        } else if (symbol2 instanceof SimpleLineSymbol && !(symbol2 instanceof SimplePolygonSymbol)) {
            SimpleLineSymbol simpleLineSymbol = (SimpleLineSymbol)symbol2;
            simpleLineSymbol.draw(basePolyline, graphics2D, null);
        } else if (symbol2 instanceof HashLineSymbol) {
            HashLineSymbol hashLineSymbol = (HashLineSymbol)symbol2;
            if (hashLineSymbol.getLineThickness() > n2 / 4) {
                hashLineSymbol.setLineThickness(n2 / 4);
                hashLineSymbol.setTickThickness(n2 / 4);
            }
            hashLineSymbol.draw(basePolyline, graphics2D, null);
        } else if (symbol2 instanceof SimpleFillSymbol) {
            SimpleFillSymbol simpleFillSymbol = (SimpleFillSymbol)symbol2;
            simpleFillSymbol.draw(envelope, graphics2D, null);
        } else if (symbol2 instanceof SimplePolygonSymbol) {
            SimplePolygonSymbol simplePolygonSymbol = (SimplePolygonSymbol)symbol2;
            simplePolygonSymbol.draw(envelope, graphics2D, null);
        } else if (symbol2 instanceof RasterFillSymbol) {
            RasterFillSymbol rasterFillSymbol = (RasterFillSymbol)symbol2;
            rasterFillSymbol.draw(envelope, graphics2D, null);
        } else if (symbol2 instanceof GradientFillSymbol) {
            GradientFillSymbol gradientFillSymbol = (GradientFillSymbol)symbol2;
            gradientFillSymbol.draw(envelope, graphics2D, null);
        }
        return;
    }

    public Dimension getMaximumSymbolSize() {
        return new Dimension(0, 0);
    }

    protected BaseFeature getSampleFeature() {
        BaseFeature baseFeature = new BaseFeature();
        BaseFields baseFields = new BaseFields();
        baseFields.addField(Field.ShapeField);
        baseFields.addFields(this.getQueryFields());
        baseFeature.setFields(baseFields);
        return baseFeature;
    }

    protected synchronized void checkCancelled() throws InterruptedException {
        if (this.getLayer() != null && this.getLayer().getLayerset() != null && this.getLayer().getLayerset().getDisplayManager() != null && this.getLayer().getLayerset().getDisplayManager().isCancelled()) {
            throw new InterruptedException();
        }
        return;
    }

    public void drawFeature(Graphics2D graphics2D, Feature feature, int n2) throws InterruptedException {
    }

    /*
     * Unable to fully structure code
     */
    public void drawCursor(Graphics2D var1_1, Cursor var2_2, int var3_3) throws InterruptedException {
        block6: while (true) {
            var4_4 = -1;
            switch (var4_4) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    this.checkCancelled();
                    this.drawFeature(var1_1, (Feature)var2_2.next(), var3_3);
                    case 0: {
                        var4_4 = -1;
                    }
                    break;
                }
            }
            break;
        }
        if (var2_2.hasMore()) ** continue;
        return;
    }

    public FeatureLayer getLayer() {
        return this.a;
    }

    public void setLayer(FeatureLayer featureLayer) {
        this.a = featureLayer;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public void draw(Graphics2D graphics2D, QueryFilter queryFilter, int n2) throws InterruptedException {
        if (graphics2D == null || queryFilter == null) {
            throw new IllegalArgumentException();
        }
        InterruptedException interruptedException = null;
        Cursor cursor = null;
        try {
            switch (n2) {
                case 0: {
                    cursor = this.getLayer().search(queryFilter);
                    break;
                }
                case 1: {
                    SelectionSet selectionSet = this.getLayer().getSelectionSet();
                    if (selectionSet == null) break;
                    cursor = selectionSet.search(queryFilter);
                    break;
                }
                case 2: {
                    cursor = this.getLayer().search(queryFilter);
                }
            }
            if (cursor != null) {
                if (cursor.hasMore()) {
                    this.drawCursor(graphics2D, cursor, n2);
                } else {
                    cursor.dispose();
                    cursor = null;
                }
            }
        }
        catch (InterruptedException interruptedException2) {
            interruptedException = interruptedException2;
        }
        catch (Exception exception) {
            MessageCentre.get().log(this, exception);
            interruptedException = new InterruptedException();
        }
        if (cursor != null) {
            cursor.dispose();
        }
        if (interruptedException != null) {
            throw interruptedException;
        }
        return;
    }
}

