/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.draw;

import com.esri.mo.axl.map.Util;
import com.esri.mo.map.draw.BaseSymbol;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedString;
import java.text.BreakIterator;

public abstract class BaseFontSymbol
extends BaseSymbol {
    private Font[] a;
    private Color g;
    private Color b;
    private Color d;
    private Color c;
    private Color e;
    private Font f = DEFAULT_FONT;
    public static final Color DEFAULT_BLOCKOUT;
    public static final Color DEFAULT_SHADOW;
    public static final Color DEFAULT_GLOWING;
    public static final Color DEFAULT_OUTLINE;
    public static final Color DEFAULT_COLOR;
    public static final Font DEFAULT_FONT;
    public static final int LABELMODE_NUMERICONLY = 1;
    public static final int LABELMODE_FULL = 0;
    public static final int PRINTMODE_ALLOWER = 3;
    public static final int PRINTMODE_ALLUPPER = 2;
    public static final int PRINTMODE_TITLECAPS = 1;
    public static final int PRINTMODE_PRETTYPRINT = 1;
    public static final int PRINTMODE_NONE = 0;

    static {
        DEFAULT_FONT = new Font("Dialog", 0, 12);
        DEFAULT_COLOR = Color.black;
        DEFAULT_OUTLINE = null;
        DEFAULT_GLOWING = null;
        DEFAULT_SHADOW = null;
        DEFAULT_BLOCKOUT = null;
    }

    public static String intToStringLabelMode(int n2) {
        if (n2 == 0) {
            return "full";
        }
        return "numericonly";
    }

    public static int stringToIntLabelMode(String string) {
        if (Util.isEmptyAttribute(string)) {
            return 1;
        }
        if (string.toLowerCase().equals("numericonly")) {
            return 1;
        }
        return 0;
    }

    public static String intToStringPrintMode(int n2) {
        switch (n2) {
            case 1: {
                return "titlecaps";
            }
            case 2: {
                return "allupper";
            }
            case 3: {
                return "alllower";
            }
        }
        return "none";
    }

    public static int stringToIntPrintMode(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("titlecaps")) {
            return 1;
        }
        if (string.equalsIgnoreCase("allupper")) {
            return 2;
        }
        if (string.equalsIgnoreCase("alllower")) {
            return 3;
        }
        return 0;
    }

    public static int stringToIntStyle(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("regular")) {
            return 0;
        }
        if (string.equalsIgnoreCase("bold")) {
            return 1;
        }
        if (string.equalsIgnoreCase("italic")) {
            return 2;
        }
        if (string.equalsIgnoreCase("outline")) {
            return 8;
        }
        if (string.equalsIgnoreCase("underline")) {
            return 4;
        }
        if (string.equalsIgnoreCase("bolditalic")) {
            return 3;
        }
        return 0;
    }

    public static String intToStringStyle(int n2) {
        if (n2 == 1) {
            return "bold";
        }
        if (n2 == 2) {
            return "italic";
        }
        if (n2 == 8) {
            return "outline";
        }
        if (n2 == 4) {
            return "underline";
        }
        if (n2 == 3) {
            return "bolditalic";
        }
        return "regular";
    }

    /*
     * Unable to fully structure code
     */
    public static String stringToNewMode(String var0, int var1_1, int var2_2) {
        block21: {
            block20: {
                var11_3 = -1;
                var3_4 = var0;
                if (var2_2 != 1) break block21;
                var4_5 = var3_4.length();
                var5_6 = var3_4.toCharArray();
                var6_7 = -1;
                var7_9 = -1;
                var8_11 = 0;
                while (var8_11 < var4_5) {
                    if (Character.isDigit((char)var5_6[var8_11])) {
                        var6_7 = var8_11;
                        break;
                    }
                    ++var8_11;
                }
                var9_12 = var7_9 = var6_7 + 1;
                {
                    switch (var11_3) {
                        case 1: {
                            continue block13;
                        }
lbl20:
                        // 1 sources

                        while (Character.isDigit((char)var5_6[var9_12])) {
                            ++var7_9;
                            ++var9_12;
                            case 0: {
                                var11_3 = -1;
                                break block13;
                            }
                        }
                        break block20;
                    }
                }
                if (var9_12 < var4_5) ** GOTO lbl20
            }
            if (var6_7 == -1) {
                return "";
            }
            var3_4 = var3_4.substring(var6_7, var7_9);
        }
        switch (var1_1) {
            case 0: {
                return var3_4;
            }
            case 1: {
                var4_5 = var3_4.length();
                var5_6 = BreakIterator.getLineInstance();
                var5_6.setText(var3_4);
                var6_8 = new StringBuffer();
                var6_8.setLength(var4_5);
                var7_10 = var3_4.toLowerCase();
                var8_11 = 0;
                while (var8_11 < var4_5) {
                    var6_8.setCharAt(var8_11, var7_10.charAt(var8_11));
                    ++var8_11;
                }
                var9_13 = var3_4.toUpperCase();
                var10_14 = var5_6.first();
                while (var10_14 != -1) {
                    if (var10_14 < var4_5) {
                        var6_8.setCharAt(var10_14, var9_13.charAt(var10_14));
                    }
                    var10_14 = var5_6.next();
                }
                return var6_8.toString();
            }
            case 2: {
                return var3_4.toUpperCase();
            }
            case 3: {
                return var3_4.toLowerCase();
            }
        }
        return var3_4;
    }

    public Color getBlockOut() {
        return this.g;
    }

    public void setBlockOut(Color color) {
        this.g = color;
    }

    public Color getShadow() {
        return this.b;
    }

    public void setShadow(Color color) {
        this.b = color;
    }

    public Color getGlowing() {
        return this.d;
    }

    public void setGlowing(Color color) {
        this.d = color;
    }

    public Color getOutline() {
        return this.c;
    }

    public void setOutline(Color color) {
        this.c = color;
    }

    public Color getColor() {
        return this.e;
    }

    public void setColor(Color color) {
        this.e = color;
    }

    public Font getFont() {
        return this.f;
    }

    public void setFont(Font font) {
        this.f = font;
    }

    public void drawTextWithEffect(Graphics2D graphics2D, String string, double d2, double d3, double d4, Font font, Color color, Color color2, Color color3, Color color4, Color color5, boolean bl) {
        Object object;
        Object object2;
        int n2;
        Object object3;
        if (color == null || font == null || string == null) {
            return;
        }
        int n3 = font.getStyle();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setTransform(new AffineTransform());
        graphics2D.setFont(font);
        TextLayout textLayout = null;
        if (n3 == 4 || n3 == 8) {
            object3 = new AttributedString(string);
            ((AttributedString)object3).addAttribute(TextAttribute.FONT, font);
            ((AttributedString)object3).addAttribute(TextAttribute.FOREGROUND, color);
            if (n3 == 4) {
                ((AttributedString)object3).addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (n3 == 8) {
                ((AttributedString)object3).addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            textLayout = new TextLayout(((AttributedString)object3).getIterator(), graphics2D.getFontRenderContext());
        } else {
            textLayout = new TextLayout(string, font, graphics2D.getFontRenderContext());
        }
        object3 = textLayout.getBounds();
        double d5 = -((RectangularShape)object3).getMinX() - ((RectangularShape)object3).getWidth() / 2.0;
        double d6 = -((RectangularShape)object3).getMinY() - ((RectangularShape)object3).getHeight() / 2.0;
        double d7 = 0.3;
        if (this.getFont().getSize() < 18 && ((n2 = this.getFont().getStyle()) == 8 || n2 == 4 || this.getGlowing() != null)) {
            d7 = 0.6;
        }
        double d8 = ((RectangularShape)object3).getHeight() * d7;
        Rectangle2D.Double double_ = new Rectangle2D.Double(((RectangularShape)object3).getX() + d5 - d8, ((RectangularShape)object3).getY() + d6 - d8, ((RectangularShape)object3).getWidth() + d8 * 2.0, ((RectangularShape)object3).getHeight() + d8 * 2.0);
        float f2 = (float)(1.0 / affineTransform.getScaleX());
        double d9 = 0.0;
        if (bl) {
            if (string.length() == 2 && string.charAt(0) == '2') {
                d9 = ((RectangularShape)object3).getHeight() / 6.0;
            }
            if (string.length() == 1 && string.charAt(0) == '2') {
                d9 = ((RectangularShape)object3).getHeight() / 6.0;
            }
        }
        Point2D.Double double_2 = new Point2D.Double();
        affineTransform.transform(new Point2D.Double(d2, d3), double_2);
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(double_2.x + d9, double_2.y);
        affineTransform2.rotate(d4);
        Point2D.Double double_3 = new Point2D.Double();
        affineTransform.transform(new Point2D.Double(d2 + (double)(5.0f * f2), d3 - (double)(4.0f * f2)), double_3);
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.translate(double_3.x + d9, double_3.y);
        affineTransform3.rotate(d4);
        if (color2 != null) {
            if (color4 != null) {
                graphics2D.setColor(color4);
                graphics2D.setTransform(affineTransform3);
                object2 = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                graphics2D.fill(double_);
                graphics2D.setComposite((Composite)object2);
            }
            graphics2D.setColor(color2);
            graphics2D.setTransform(affineTransform2);
            graphics2D.fill(double_);
        }
        if (color4 != null) {
            if (n3 == 4 || n3 == 8) {
                object = new AttributedString(string);
                ((AttributedString)object).addAttribute(TextAttribute.FONT, font);
                ((AttributedString)object).addAttribute(TextAttribute.FOREGROUND, color4);
                if (n3 == 4) {
                    ((AttributedString)object).addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (n3 == 8) {
                    ((AttributedString)object).addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                object2 = new TextLayout(((AttributedString)object).getIterator(), graphics2D.getFontRenderContext());
            } else {
                graphics2D.setColor(color4);
                object2 = new TextLayout(string, font, graphics2D.getFontRenderContext());
            }
            graphics2D.setTransform(affineTransform3);
            object = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            ((TextLayout)object2).draw(graphics2D, (float)d5, (float)d6);
            graphics2D.setComposite((Composite)object);
        }
        if (color5 != null) {
            object = new Color(color5.getRed(), color5.getGreen(), color5.getBlue(), 51);
            if (n3 == 4 || n3 == 8) {
                AttributedString attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.FONT, font);
                attributedString.addAttribute(TextAttribute.FOREGROUND, object);
                if (n3 == 4) {
                    attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (n3 == 8) {
                    attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                object2 = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
            } else {
                graphics2D.setColor((Color)object);
                object2 = new TextLayout(string, font, graphics2D.getFontRenderContext());
            }
            graphics2D.setTransform(affineTransform2);
            ((TextLayout)object2).draw(graphics2D, (float)(d5 - 3.0), (float)(d6 - 1.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 - 3.0), (float)d6);
            ((TextLayout)object2).draw(graphics2D, (float)(d5 - 3.0), (float)(d6 + 1.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 - 2.0), (float)(d6 - 2.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 - 2.0), (float)(d6 + 2.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 - 1.0), (float)(d6 - 3.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 - 1.0), (float)(d6 + 3.0));
            ((TextLayout)object2).draw(graphics2D, (float)d5, (float)(d6 - 3.0));
            ((TextLayout)object2).draw(graphics2D, (float)d5, (float)(d6 + 3.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 + 1.0), (float)(d6 - 3.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 + 1.0), (float)(d6 + 3.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 + 2.0), (float)(d6 - 2.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 + 2.0), (float)(d6 + 2.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 + 3.0), (float)(d6 - 1.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 + 3.0), (float)d6);
            ((TextLayout)object2).draw(graphics2D, (float)(d5 + 3.0), (float)(d6 + 1.0));
        }
        if (color3 != null) {
            if (n3 == 4 || n3 == 8) {
                object = new AttributedString(string);
                ((AttributedString)object).addAttribute(TextAttribute.FONT, font);
                ((AttributedString)object).addAttribute(TextAttribute.FOREGROUND, color3);
                if (n3 == 4) {
                    ((AttributedString)object).addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (n3 == 8) {
                    ((AttributedString)object).addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                object2 = new TextLayout(((AttributedString)object).getIterator(), graphics2D.getFontRenderContext());
            } else {
                graphics2D.setColor(color3);
                object2 = new TextLayout(string, font, graphics2D.getFontRenderContext());
            }
            graphics2D.setTransform(affineTransform2);
            ((TextLayout)object2).draw(graphics2D, (float)(d5 + 1.0), (float)(d6 + 1.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 + 1.0), (float)(d6 - 1.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 - 1.0), (float)(d6 + 1.0));
            ((TextLayout)object2).draw(graphics2D, (float)(d5 - 1.0), (float)(d6 - 1.0));
        }
        graphics2D.setColor(color);
        graphics2D.setTransform(affineTransform2);
        textLayout.draw(graphics2D, (float)d5, (float)d6);
        graphics2D.setTransform(affineTransform);
        return;
    }

    public Dimension getSizeTextWithEffect(String string) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int n2 = fontMetrics.stringWidth(string) + fontMetrics.getHeight() / 10;
        int n3 = fontMetrics.getHeight() + fontMetrics.getHeight() / 10;
        if (this.getAntialiasing()) {
            n2 = (int)((double)n2 * 1.3);
        }
        return new Dimension(n2, n3);
    }

    public BaseFontSymbol() {
        this.e = DEFAULT_COLOR;
        this.c = DEFAULT_OUTLINE;
        this.d = DEFAULT_GLOWING;
        this.b = DEFAULT_SHADOW;
        this.g = DEFAULT_BLOCKOUT;
        this.a = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    }
}

