/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.dpy;

import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.data.feat.BaseSpatialFilter;
import com.esri.mo.data.feat.Cursor;
import com.esri.mo.data.feat.Fields;
import com.esri.mo.data.feat.MapDataset;
import com.esri.mo.data.feat.QueryFilter;
import com.esri.mo.data.feat.SpatialFilter;
import com.esri.mo.data.feat.Table;
import com.esri.mo.map.dpy.BaseLayer;
import com.esri.mo.map.dpy.BaseMapFilter;
import com.esri.mo.map.dpy.DatasetLayer;
import com.esri.mo.map.dpy.DisplayArea;
import com.esri.mo.map.dpy.bb;
import com.esri.mo.util.EmptyCursor;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public abstract class BaseDatasetLayer
extends BaseLayer
implements DatasetLayer {
    private bb a;
    protected MapDataset _dset;

    static void a(BaseDatasetLayer baseDatasetLayer) {
        baseDatasetLayer.a();
    }

    public abstract boolean isOpaque();

    protected abstract void drawFilter(BaseSpatialFilter var1, Graphics2D var2, int var3) throws InterruptedException;

    public void drawWithinScale(DisplayArea displayArea, int n2) throws InterruptedException {
        if (this.getCapabilities().getCapability(2).isOkToUse() && !displayArea.getExtent().clem_disjointEnvelope(this.getExtent())) {
            BaseMapFilter baseMapFilter = this.createMapFilter(displayArea);
            this.drawFilter(baseMapFilter, displayArea.getGraphics(), n2);
        }
        return;
    }

    protected BaseMapFilter createMapFilter(DisplayArea displayArea) {
        BaseMapFilter baseMapFilter = new BaseMapFilter();
        baseMapFilter.setDisplayArea(displayArea);
        Envelope envelope = new Envelope();
        Rectangle2D.intersect(displayArea.getExtent(), this.getExtent(), envelope);
        baseMapFilter.setSpatialRelation(0);
        baseMapFilter.setGeometry(envelope);
        baseMapFilter.setUseCache(this.getCapabilities().getCapability(0).isOkToUse());
        return baseMapFilter;
    }

    public BaseSpatialFilter createSpatialSearchFilter(FeatureGeometry featureGeometry, Fields fields) {
        BaseSpatialFilter baseSpatialFilter = new BaseSpatialFilter();
        if (fields == null && this.getDataset() instanceof Table) {
            fields = ((Table)((Object)this.getDataset())).getFields();
        }
        baseSpatialFilter.setSubFields(fields);
        baseSpatialFilter.setScale(this.getMapScale());
        baseSpatialFilter.setGeometry(featureGeometry);
        baseSpatialFilter.setSpatialRelation(1);
        baseSpatialFilter.setUseCache(this.getCapabilities().getCapability(0).isOkToUse());
        return baseSpatialFilter;
    }

    public Cursor search(Envelope envelope, Fields fields) {
        Cursor cursor = null;
        if (this.getExtent().clem_disjointEnvelope(envelope)) {
            cursor = new EmptyCursor();
        } else {
            Envelope envelope2 = new Envelope();
            Rectangle2D.intersect(envelope, this.getDataset().getExtent(), envelope2);
            BaseSpatialFilter baseSpatialFilter = this.createSpatialSearchFilter(envelope2, fields);
            cursor = this.search(baseSpatialFilter);
        }
        return cursor;
    }

    public Cursor search(QueryFilter queryFilter) {
        boolean bl = queryFilter instanceof SpatialFilter;
        boolean bl2 = false;
        bl2 = bl ? this.getCapabilities().getCapability(2).isOkToUse() : this.getCapabilities().getCapability(1).isOkToUse();
        Cursor cursor = null;
        if (bl2) {
            if (bl) {
                ((SpatialFilter)queryFilter).setScale(this.getMapScale());
            }
            if (!this.getCapabilities().getCapability(0).isOkToUse()) {
                queryFilter.setUseCache(false);
            }
            cursor = this.getDataset().search(queryFilter);
        } else {
            cursor = new EmptyCursor();
        }
        return cursor;
    }

    public void fetch(Envelope envelope, double d2, int n2, int n3) {
        if (this.getCapabilities().getCapability(0).isOkToUse() && this.getCapabilities().getCapability(2).isOkToUse()) {
            this.getDataset().fetch(envelope, d2, n2, n3);
        }
        return;
    }

    public MapDataset getDataset() {
        return this._dset;
    }

    public void setNeedsRedraw(int n2, int n3) {
        if (n3 == 1 && !this.isOpaque()) {
            n3 = 2;
        }
        super.setNeedsRedraw(n2, n3);
        return;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (1 == this.getNeedsRedraw(0) && !this.isOpaque()) {
            this.setNeedsRedraw(0, 2);
        }
        return;
    }

    private final void a() {
        this.setNeedsRedraw(this.isOpaque() ? 1 : 2);
        return;
    }

    public void setDataset(MapDataset mapDataset) {
        if (mapDataset == null) {
            throw new IllegalArgumentException();
        }
        this._dset = mapDataset;
        this.setName(mapDataset.getName());
        this.a = new bb(this, null);
        mapDataset.addDataListener(this.a);
        return;
    }

    public Envelope getExtent() {
        return this.getDataset().getExtent();
    }
}

