/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.file.shp;

import com.esri.mo.file.shp.PointMShp;
import com.esri.mo.file.shp.ShapeZ;
import com.esri.mo.util.LittleEndian;

public class PointZShp
extends PointMShp
implements ShapeZ {
    protected int mZstart = 0;
    protected int mZdata = 0;

    protected void bufferToData() {
        if (this.mNullShape) {
            return;
        }
        this.mPnt = new double[4];
        LittleEndian.getDouble(this.mBuffer, 4, this.mPnt, 0, 4);
        return;
    }

    public void putValue() {
        double[] dArray;
        if (this.mNullShape) {
            byte[] byArray = new byte[4];
            this.mOwner.a(byArray);
            LittleEndian.putInteger(byArray, 0, 0);
            return;
        }
        if (this.mPnt == null) {
            byte[] byArray = new byte[this.mBuffer.length];
            this.mOwner.a(byArray);
            System.arraycopy(this.mBuffer, 0, byArray, 0, this.mBuffer.length);
            return;
        }
        byte[] byArray = new byte[36];
        this.mOwner.a(byArray);
        LittleEndian.putInteger(byArray, 0, 11);
        LittleEndian.putDouble(byArray, 4, this.mPnt, 0, 4);
        dArray = new double[]{this.mPnt[this.mXdata], dArray[0]};
        this.mOwner.a(dArray);
        dArray[0] = this.mPnt[this.mYdata];
        dArray[1] = dArray[0];
        this.mOwner.b(dArray);
        dArray[0] = this.mPnt[this.mZdata];
        dArray[1] = dArray[0];
        this.mOwner.c(dArray);
        dArray[0] = this.mPnt[this.mMdata];
        dArray[1] = dArray[0];
        this.mOwner.d(dArray);
        return;
    }

    public void setNumPoints(int n2) {
        if (n2 != 1) {
            throw new IllegalArgumentException();
        }
        this.mPnt = new double[4];
        this.mXdata = 0;
        this.mYdata = 1;
        this.mZdata = 2;
        this.mMdata = 3;
        this.mNullShape = false;
        return;
    }

    public double[] getRangeZ() {
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        double[] dArray = new double[2];
        if (this.mPnt != null) {
            dArray[0] = this.mPnt[this.mZdata];
            dArray[1] = dArray[0];
            return dArray;
        }
        dArray[0] = LittleEndian.getDouble(this.mBuffer, this.mZstart);
        dArray[1] = dArray[0];
        return dArray;
    }

    public void setZAt(int n2, double d2) {
        if (n2 != 0) {
            throw new IllegalArgumentException();
        }
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mPnt == null) {
            this.bufferToData();
        }
        this.mPnt[this.mZdata] = d2;
        return;
    }

    public void setZ(double[] dArray) {
        if (dArray.length > 1) {
            throw new IllegalArgumentException();
        }
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mPnt == null) {
            this.bufferToData();
        }
        this.mPnt[this.mZdata] = dArray[0];
        return;
    }

    public double getZAt(int n2) {
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mPnt != null) {
            return this.mPnt[this.mZdata];
        }
        return LittleEndian.getDouble(this.mBuffer, this.mZstart);
    }

    public double[] getZ() {
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        double[] dArray = new double[1];
        if (this.mPnt != null) {
            dArray[0] = this.mPnt[this.mZdata];
            return dArray;
        }
        LittleEndian.getDouble(this.mBuffer, this.mZstart, dArray, 0, 1);
        return dArray;
    }

    public void getValue() {
        this.mBuffer = this.mOwner.a();
        this.mPnt = null;
        int n2 = LittleEndian.getInteger(this.mBuffer, 0);
        if (n2 == 0) {
            this.mNullShape = true;
            this.mXstart = 0;
            this.mYstart = 0;
            this.mMstart = 0;
            this.mZstart = 0;
        } else {
            this.mNullShape = false;
            this.mXstart = 4;
            this.mYstart = 12;
            this.mZstart = 20;
            this.mMstart = 28;
        }
        this.mXdata = 0;
        this.mYdata = 0;
        this.mMdata = 0;
        this.mZdata = 0;
        return;
    }
}

