/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.file.shp;

import com.esri.mo.file.shp.Shape;
import com.esri.mo.file.shp.ShpField;
import com.esri.mo.util.LittleEndian;

public class PointShp
extends ShpField
implements Shape {
    protected byte[] mBuffer = null;
    protected int mYstart = 0;
    protected int mXstart = 0;
    protected int mYdata = 0;
    protected int mXdata = 0;
    protected double[] mPnt = null;

    protected void bufferToData() {
        if (this.mNullShape) {
            return;
        }
        this.mPnt = new double[2];
        LittleEndian.getDouble(this.mBuffer, 4, this.mPnt, 0, 2);
        return;
    }

    public void putValue() {
        double[] dArray;
        if (this.mNullShape) {
            byte[] byArray = new byte[4];
            this.mOwner.a(byArray);
            LittleEndian.putInteger(byArray, 0, 0);
            return;
        }
        if (this.mPnt == null) {
            byte[] byArray = new byte[this.mBuffer.length];
            this.mOwner.a(byArray);
            System.arraycopy(this.mBuffer, 0, byArray, 0, this.mBuffer.length);
            return;
        }
        byte[] byArray = new byte[20];
        this.mOwner.a(byArray);
        LittleEndian.putInteger(byArray, 0, 1);
        LittleEndian.putDouble(byArray, 4, this.mPnt, 0, 2);
        dArray = new double[]{this.mPnt[this.mXdata], dArray[0]};
        this.mOwner.a(dArray);
        dArray[0] = this.mPnt[this.mYdata];
        dArray[1] = dArray[0];
        this.mOwner.b(dArray);
        return;
    }

    public void setNumPoints(int n2) {
        if (n2 != 1) {
            throw new IllegalArgumentException();
        }
        this.mPnt = new double[2];
        this.mXdata = 0;
        this.mYdata = 1;
        this.mNullShape = false;
        return;
    }

    public void setYAt(int n2, double d2) {
        if (n2 != 0) {
            throw new IllegalArgumentException();
        }
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mPnt == null) {
            this.bufferToData();
        }
        this.mPnt[this.mYdata] = d2;
        return;
    }

    public void setXAt(int n2, double d2) {
        if (n2 != 0) {
            throw new IllegalArgumentException();
        }
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mPnt == null) {
            this.bufferToData();
        }
        this.mPnt[this.mXdata] = d2;
        return;
    }

    public void setY(double[] dArray) {
        if (dArray.length > 1) {
            throw new IllegalArgumentException();
        }
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mPnt == null) {
            this.bufferToData();
        }
        this.mPnt[this.mYdata] = dArray[0];
        return;
    }

    public void setX(double[] dArray) {
        if (dArray.length > 1) {
            throw new IllegalArgumentException();
        }
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mPnt == null) {
            this.bufferToData();
        }
        this.mPnt[this.mXdata] = dArray[0];
        return;
    }

    public int getNumPoints() {
        if (this.mNullShape) {
            return 0;
        }
        return 1;
    }

    public double[] getRangeY() {
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        double[] dArray = new double[2];
        if (this.mPnt != null) {
            dArray[0] = this.mPnt[this.mYdata];
            dArray[1] = dArray[0];
            return dArray;
        }
        dArray[0] = LittleEndian.getDouble(this.mBuffer, this.mYstart);
        dArray[1] = dArray[0];
        return dArray;
    }

    public double[] getRangeX() {
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        double[] dArray = new double[2];
        if (this.mPnt != null) {
            dArray[0] = this.mPnt[this.mXdata];
            dArray[1] = dArray[0];
            return dArray;
        }
        dArray[0] = LittleEndian.getDouble(this.mBuffer, this.mXstart);
        dArray[1] = dArray[0];
        return dArray;
    }

    public double getYAt(int n2) {
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mPnt != null) {
            return this.mPnt[this.mYdata];
        }
        return LittleEndian.getDouble(this.mBuffer, this.mYstart);
    }

    public double getXAt(int n2) {
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mPnt != null) {
            return this.mPnt[this.mXdata];
        }
        return LittleEndian.getDouble(this.mBuffer, this.mXstart);
    }

    public double[] getY() {
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        double[] dArray = new double[1];
        if (this.mPnt != null) {
            dArray[0] = this.mPnt[this.mYdata];
            return dArray;
        }
        LittleEndian.getDouble(this.mBuffer, this.mYstart, dArray, 0, 1);
        return dArray;
    }

    public double[] getX() {
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        double[] dArray = new double[1];
        if (this.mPnt != null) {
            dArray[0] = this.mPnt[this.mXdata];
            return dArray;
        }
        LittleEndian.getDouble(this.mBuffer, this.mXstart, dArray, 0, 1);
        return dArray;
    }

    public void getValue() {
        this.mBuffer = this.mOwner.a();
        this.mPnt = null;
        int n2 = LittleEndian.getInteger(this.mBuffer, 0);
        if (n2 == 0) {
            this.mNullShape = true;
            this.mXstart = 0;
            this.mYstart = 0;
        } else {
            this.mNullShape = false;
            this.mXstart = 4;
            this.mYstart = 12;
        }
        this.mXdata = 0;
        this.mYdata = 0;
        return;
    }
}

