/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.file.shp;

import com.esri.mo.file.shp.MultiPartShapeZ;
import com.esri.mo.file.shp.ShpField;
import com.esri.mo.file.shp.c;
import com.esri.mo.util.LittleEndian;

public class MultiPatchShp
extends ShpField
implements MultiPartShapeZ {
    private int[] a = null;
    protected c[] mParts = null;
    protected int mZStart = 0;
    protected int mMStart = 0;
    protected int mTypeStart = 0;
    protected int mPartStart = 0;
    protected int mPointStart = 0;
    protected byte[] mBuffer = null;
    public static final int PART_RING = 5;
    public static final int PART_FIRSTRING = 4;
    public static final int PART_INNERRING = 3;
    public static final int PART_OUTERRING = 2;
    public static final int PART_TRIANGLEFAN = 1;
    public static final int PART_TRIANGLESTRIP = 0;

    protected void bufferToData() {
        if (this.mNullShape) {
            return;
        }
        int n2 = LittleEndian.getInteger(this.mBuffer, 36);
        int n3 = LittleEndian.getInteger(this.mBuffer, 40);
        this.mParts = new c[n2];
        this.a = new int[n2];
        int[] nArray = new int[n2 + 1];
        nArray[n2] = n3;
        LittleEndian.getInteger(this.mBuffer, this.mPartStart, nArray, 0, n2);
        LittleEndian.getInteger(this.mBuffer, this.mTypeStart, this.a, 0, n2);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = nArray[n4 + 1] - nArray[n4];
            double[] dArray = new double[n5];
            this.mParts[n4] = new c(n5);
            int n6 = this.mMStart + 16 + nArray[n4] * 8;
            LittleEndian.getDouble(this.mBuffer, n6, dArray, 0, n5);
            this.mParts[n4].setM(dArray);
            n6 = this.mZStart + 16 + nArray[n4] * 8;
            LittleEndian.getDouble(this.mBuffer, n6, dArray, 0, n5);
            this.mParts[n4].setZ(dArray);
            int n7 = this.mPointStart + nArray[n4] * 16;
            n6 = 0;
            while (n6 < n5) {
                dArray[n6] = LittleEndian.getDouble(this.mBuffer, n7);
                n7 += 16;
                ++n6;
            }
            this.mParts[n4].setX(dArray);
            n7 = this.mPointStart + nArray[n4] * 16 + 8;
            n6 = 0;
            while (n6 < n5) {
                dArray[n6] = LittleEndian.getDouble(this.mBuffer, n7);
                n7 += 16;
                ++n6;
            }
            this.mParts[n4].setY(dArray);
            ++n4;
        }
        return;
    }

    public void putValue() {
        if (this.mNullShape) {
            byte[] byArray = new byte[4];
            this.mOwner.a(byArray);
            LittleEndian.putInteger(byArray, 0, 0);
            return;
        }
        if (this.mParts == null) {
            byte[] byArray = new byte[this.mBuffer.length];
            this.mOwner.a(byArray);
            System.arraycopy(this.mBuffer, 0, byArray, 0, this.mBuffer.length);
            return;
        }
        int n2 = this.getNumPoints();
        int n3 = this.mParts.length;
        double[] dArray = this.getRangeX();
        double[] dArray2 = this.getRangeY();
        double[] dArray3 = this.getRangeZ();
        double[] dArray4 = this.getRangeM();
        int n4 = 44;
        int n5 = n4 + 4 * n3;
        int n6 = n5 + 4 * n3;
        int n7 = n6 + 16 * n2;
        int n8 = n7 + 8 * (n2 + 2);
        int n9 = n8 + 8 * (n2 + 2);
        byte[] byArray = new byte[n9];
        this.mOwner.a(byArray);
        LittleEndian.putInteger(byArray, 0, 31);
        LittleEndian.putDouble(byArray, 4, dArray[0]);
        LittleEndian.putDouble(byArray, 12, dArray2[0]);
        LittleEndian.putDouble(byArray, 20, dArray[1]);
        LittleEndian.putDouble(byArray, 28, dArray2[1]);
        LittleEndian.putInteger(byArray, 36, n3);
        LittleEndian.putInteger(byArray, 40, n2);
        LittleEndian.putInteger(byArray, n5, this.a, 0, n3);
        LittleEndian.putDouble(byArray, n7, dArray3, 0, 2);
        LittleEndian.putDouble(byArray, n8, dArray4, 0, 2);
        int n10 = 0;
        int n11 = n4;
        int n12 = n6;
        int n13 = n7 + 16;
        int n14 = n8 + 16;
        int n15 = 0;
        while (n15 < n3) {
            LittleEndian.putInteger(byArray, n11, n10);
            n10 += this.mParts[n15].getNumPoints();
            n11 += 4;
            double[] dArray5 = this.mParts[n15].getZByRef();
            LittleEndian.putDouble(byArray, n13, dArray5, 0, dArray5.length);
            n13 += dArray5.length * 8;
            dArray5 = this.mParts[n15].getMByRef();
            LittleEndian.putDouble(byArray, n14, dArray5, 0, dArray5.length);
            n14 += dArray5.length * 8;
            double[] dArray6 = this.mParts[n15].getXByRef();
            double[] dArray7 = this.mParts[n15].getYByRef();
            int n16 = 0;
            while (n16 < dArray6.length) {
                LittleEndian.putDouble(byArray, n12, dArray6[n16]);
                LittleEndian.putDouble(byArray, n12 + 8, dArray7[n16]);
                n12 += 16;
                ++n16;
            }
            ++n15;
        }
        this.mOwner.a(dArray);
        this.mOwner.b(dArray2);
        this.mOwner.c(dArray3);
        this.mOwner.d(dArray4);
        return;
    }

    public void setPartType(int n2, int n3) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.mParts == null) {
            this.bufferToData();
        }
        this.a[n2] = n3;
        return;
    }

    public void setNumPoints(int n2, int n3) {
        if (this.mNullShape || n3 < 3) {
            throw new IllegalArgumentException();
        }
        if (this.mParts == null) {
            this.bufferToData();
        }
        this.mParts[n2] = new c(n3);
        return;
    }

    public void setZ(int n2, double[] dArray) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts == null) {
            this.bufferToData();
        }
        this.mParts[n2].setZ(dArray);
        return;
    }

    public void setZAt(int n2, int n3, double d2) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts == null) {
            this.bufferToData();
        }
        this.mParts[n2].setZAt(n3, d2);
        return;
    }

    public void setM(int n2, double[] dArray) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts == null) {
            this.bufferToData();
        }
        this.mParts[n2].setM(dArray);
        return;
    }

    public void setMAt(int n2, int n3, double d2) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts == null) {
            this.bufferToData();
        }
        this.mParts[n2].setMAt(n3, d2);
        return;
    }

    public void setX(int n2, double[] dArray) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts == null) {
            this.bufferToData();
        }
        this.mParts[n2].setX(dArray);
        return;
    }

    public void setXAt(int n2, int n3, double d2) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts == null) {
            this.bufferToData();
        }
        this.mParts[n2].setXAt(n3, d2);
        return;
    }

    public void setY(int n2, double[] dArray) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts == null) {
            this.bufferToData();
        }
        this.mParts[n2].setY(dArray);
        return;
    }

    public void setYAt(int n2, int n3, double d2) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts == null) {
            this.bufferToData();
        }
        this.mParts[n2].setYAt(n3, d2);
        return;
    }

    public void setNumParts(int n2) {
        this.mParts = new c[n2];
        this.a = new int[n2];
        this.mNullShape = false;
        return;
    }

    public double getZAt(int n2, int n3) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts != null) {
            return this.mParts[n2].getZAt(n3);
        }
        int n4 = this.mPartStart + n2 * 4;
        int n5 = LittleEndian.getInteger(this.mBuffer, n4);
        n4 = this.mZStart + 16 + (n5 + n3) * 8;
        return LittleEndian.getDouble(this.mBuffer, n4);
    }

    public double[] getZ(int n2) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts != null) {
            return this.mParts[n2].getZ();
        }
        int n3 = this.getNumPoints(n2);
        double[] dArray = new double[n3];
        int n4 = this.mPartStart + n2 * 4;
        int n5 = LittleEndian.getInteger(this.mBuffer, n4);
        n4 = this.mZStart + 16 + n5 * 8;
        LittleEndian.getDouble(this.mBuffer, n4, dArray, 0, n3);
        return dArray;
    }

    public double getMAt(int n2, int n3) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts != null) {
            return this.mParts[n2].getMAt(n3);
        }
        int n4 = this.mPartStart + n2 * 4;
        int n5 = LittleEndian.getInteger(this.mBuffer, n4);
        n4 = this.mMStart + 16 + (n5 + n3) * 8;
        return LittleEndian.getDouble(this.mBuffer, n4);
    }

    public double[] getM(int n2) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts != null) {
            return this.mParts[n2].getM();
        }
        int n3 = this.getNumPoints(n2);
        double[] dArray = new double[n3];
        int n4 = this.mPartStart + n2 * 4;
        int n5 = LittleEndian.getInteger(this.mBuffer, n4);
        n4 = this.mMStart + 16 + n5 * 8;
        LittleEndian.getDouble(this.mBuffer, n4, dArray, 0, n3);
        return dArray;
    }

    public double getYAt(int n2, int n3) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts != null) {
            return this.mParts[n2].getYAt(n3);
        }
        int n4 = this.mPartStart + n2 * 4;
        int n5 = LittleEndian.getInteger(this.mBuffer, n4);
        n4 = this.mPointStart + n5 * 16 + n3 * 16 + 8;
        return LittleEndian.getDouble(this.mBuffer, n4);
    }

    /*
     * Unable to fully structure code
     */
    public double[] getY(int var1_1) {
        var7_2 = -1;
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts != null) {
            return this.mParts[var1_1].getY();
        }
        var6_3 = this.getNumPoints(var1_1);
        var2_4 = new double[var6_3];
        var4_5 = this.mPartStart + var1_1 * 4;
        var5_6 = LittleEndian.getInteger(this.mBuffer, var4_5);
        var4_5 = this.mPointStart + 8 + var5_6 * 16;
        var3_7 = 0;
        {
            switch (var7_2) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    var2_4[var3_7] = LittleEndian.getDouble(this.mBuffer, var4_5);
                    var4_5 += 16;
                    ++var3_7;
                    case 0: {
                        var7_2 = -1;
                    }
                    break;
                }
            }
        }
        if (var3_7 < var6_3) ** continue;
        return var2_4;
    }

    public double getXAt(int n2, int n3) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts != null) {
            return this.mParts[n2].getXAt(n3);
        }
        int n4 = this.mPartStart + n2 * 4;
        int n5 = LittleEndian.getInteger(this.mBuffer, n4);
        n4 = this.mPointStart + n5 * 16 + n3 * 16;
        return LittleEndian.getDouble(this.mBuffer, n4);
    }

    /*
     * Unable to fully structure code
     */
    public double[] getX(int var1_1) {
        var7_2 = -1;
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts != null) {
            return this.mParts[var1_1].getX();
        }
        var6_3 = this.getNumPoints(var1_1);
        var2_4 = new double[var6_3];
        var4_5 = this.mPartStart + var1_1 * 4;
        var5_6 = LittleEndian.getInteger(this.mBuffer, var4_5);
        var4_5 = this.mPointStart + var5_6 * 16;
        var3_7 = 0;
        {
            switch (var7_2) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    var2_4[var3_7] = LittleEndian.getDouble(this.mBuffer, var4_5);
                    var4_5 += 16;
                    ++var3_7;
                    case 0: {
                        var7_2 = -1;
                    }
                    break;
                }
            }
        }
        if (var3_7 < var6_3) ** continue;
        return var2_4;
    }

    /*
     * Unable to fully structure code
     */
    public double[] getRangeZ() {
        var4_1 = -1;
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mParts != null) {
            var1_2 = this.mParts[0].getZRange();
            var3_4 = 1;
            {
                switch (var4_1) {
                    case 1: {
                        continue block6;
                    }
                    while (true) {
                        var2_5 = this.mParts[var3_4].getZRange();
                        this.a(var1_2, var2_5);
                        ++var3_4;
                        case 0: {
                            var4_1 = -1;
                        }
                        break;
                    }
                }
            }
            if (var3_4 < this.mParts.length) ** continue;
            return var1_2;
        }
        var1_3 = new double[2];
        LittleEndian.getDouble(this.mBuffer, this.mZStart, var1_3, 0, 2);
        return var1_3;
    }

    /*
     * Unable to fully structure code
     */
    public double[] getRangeM() {
        var4_1 = -1;
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mParts != null) {
            var1_2 = this.mParts[0].getMRange();
            var3_4 = 1;
            {
                switch (var4_1) {
                    case 1: {
                        continue block6;
                    }
                    while (true) {
                        var2_5 = this.mParts[var3_4].getMRange();
                        this.a(var1_2, var2_5);
                        ++var3_4;
                        case 0: {
                            var4_1 = -1;
                        }
                        break;
                    }
                }
            }
            if (var3_4 < this.mParts.length) ** continue;
            return var1_2;
        }
        var1_3 = new double[2];
        LittleEndian.getDouble(this.mBuffer, this.mMStart, var1_3, 0, 2);
        return var1_3;
    }

    /*
     * Unable to fully structure code
     */
    public double[] getRangeY() {
        var4_1 = -1;
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mParts != null) {
            var1_2 = this.mParts[0].getYRange();
            var3_4 = 1;
            {
                switch (var4_1) {
                    case 1: {
                        continue block6;
                    }
                    while (true) {
                        var2_5 = this.mParts[var3_4].getYRange();
                        this.a(var1_2, var2_5);
                        ++var3_4;
                        case 0: {
                            var4_1 = -1;
                        }
                        break;
                    }
                }
            }
            if (var3_4 < this.mParts.length) ** continue;
            return var1_2;
        }
        var1_3 = new double[]{LittleEndian.getDouble(this.mBuffer, 12), LittleEndian.getDouble(this.mBuffer, 28)};
        return var1_3;
    }

    /*
     * Unable to fully structure code
     */
    public double[] getRangeX() {
        var4_1 = -1;
        if (this.mNullShape) {
            throw new UnsupportedOperationException();
        }
        if (this.mParts != null) {
            var1_2 = this.mParts[0].getXRange();
            var3_4 = 1;
            {
                switch (var4_1) {
                    case 1: {
                        continue block6;
                    }
                    while (true) {
                        var2_5 = this.mParts[var3_4].getXRange();
                        this.a(var1_2, var2_5);
                        ++var3_4;
                        case 0: {
                            var4_1 = -1;
                        }
                        break;
                    }
                }
            }
            if (var3_4 < this.mParts.length) ** continue;
            return var1_2;
        }
        var1_3 = new double[]{LittleEndian.getDouble(this.mBuffer, 4), LittleEndian.getDouble(this.mBuffer, 20)};
        return var1_3;
    }

    public int getPartType(int n2) {
        if (this.mNullShape) {
            throw new IllegalArgumentException();
        }
        if (this.mParts != null) {
            return this.a[n2];
        }
        int n3 = this.mTypeStart + 4 * n2;
        return LittleEndian.getInteger(this.mBuffer, n3);
    }

    public int getNumPoints(int n2) {
        if (this.mNullShape) {
            return 0;
        }
        if (this.mParts != null) {
            return this.mParts[n2].getNumPoints();
        }
        int n3 = this.getNumParts();
        int n4 = this.mPartStart + 4 * n2;
        int n5 = LittleEndian.getInteger(this.mBuffer, n4);
        int n6 = n2 == n3 - 1 ? this.getNumPoints() : LittleEndian.getInteger(this.mBuffer, n4 + 4);
        return n6 - n5;
    }

    /*
     * Unable to fully structure code
     */
    public int getNumPoints() {
        var3_1 = -1;
        if (this.mNullShape) {
            return 0;
        }
        if (this.mParts != null) {
            var2_2 = 0;
            var1_3 = 0;
            {
                switch (var3_1) {
                    case 1: {
                        continue block6;
                    }
                    while (true) {
                        var2_2 += this.mParts[var1_3].getNumPoints();
                        ++var1_3;
                        case 0: {
                            var3_1 = -1;
                        }
                        break;
                    }
                }
            }
            if (var1_3 < this.mParts.length) ** continue;
            return var2_2;
        }
        return LittleEndian.getInteger(this.mBuffer, 40);
    }

    public int getNumParts() {
        if (this.mNullShape) {
            return 0;
        }
        if (this.mParts != null) {
            return this.mParts.length;
        }
        return LittleEndian.getInteger(this.mBuffer, 36);
    }

    public void getValue() {
        this.mBuffer = this.mOwner.a();
        this.mParts = null;
        this.a = null;
        int n2 = LittleEndian.getInteger(this.mBuffer, 0);
        if (n2 == 0) {
            this.mNullShape = true;
            this.mPartStart = 0;
            this.mTypeStart = 0;
            this.mPointStart = 0;
            this.mZStart = 0;
            this.mMStart = 0;
        } else {
            this.mNullShape = false;
            int n3 = LittleEndian.getInteger(this.mBuffer, 36);
            int n4 = LittleEndian.getInteger(this.mBuffer, 40);
            this.mPartStart = 44;
            this.mTypeStart = this.mPartStart + 4 * n3;
            this.mPointStart = this.mTypeStart + 4 * n3;
            this.mZStart = this.mPointStart + 16 * n4;
            this.mMStart = this.mZStart + 8 * (n4 + 2);
        }
        return;
    }
}

