/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.file.shp;

import com.esri.mo.file.shp.DbfCodePageException;
import com.esri.mo.file.shp.DbfField;
import com.esri.mo.file.shp.DbfFieldNameException;
import com.esri.mo.file.shp.DbfFieldPrecisionException;
import com.esri.mo.file.shp.DbfFieldValueException;
import com.esri.mo.file.shp.DbfFieldWidthException;
import com.esri.mo.file.shp.DbfNullValue;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public class DbfNumericField
extends DbfField {
    private DecimalFormat a;

    private void a() {
        if (this.mDec == 0) {
            this.a.setDecimalSeparatorAlwaysShown(false);
            this.a.setMaximumFractionDigits(this.mDec);
        } else {
            this.a.setDecimalSeparatorAlwaysShown(true);
            this.a.setMaximumFractionDigits(this.mDec);
        }
        return;
    }

    public void setNumDec(int n2) {
        if (n2 < 0 || n2 >= this.mWidth) {
            throw new IllegalArgumentException();
        }
        this.mDec = n2;
        this.a();
        return;
    }

    public void setWidth(int n2) {
        if (n2 < 1 || n2 > 20 || n2 <= this.mDec) {
            throw new IllegalArgumentException();
        }
        this.mWidth = n2;
        this.a();
        return;
    }

    public int putValue(byte[] byArray, Object object) {
        try {
            byte[] byArray2 = null;
            if (object instanceof DbfNullValue) {
                String string = new String(" ");
                byArray2 = string.getBytes(this.mCodepage);
                if (this.checkOverflow(byArray, byArray2)) {
                    return DbfField.VALUE_OVERFLOW;
                }
                this.checkUnderflow(byArray, byArray2, 0, ' ');
                return DbfField.VALUE_OK;
            }
            if (object instanceof Double || object instanceof Float) {
                double d2 = ((Number)object).doubleValue();
                String string = this.a.format(d2);
                byArray2 = string.getBytes(this.mCodepage);
                if (this.checkOverflow(byArray, byArray2)) {
                    return DbfField.VALUE_OVERFLOW;
                }
                this.checkUnderflow(byArray, byArray2, 1, ' ');
                return DbfField.VALUE_OK;
            }
            if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
                long l2 = ((Number)object).longValue();
                String string = this.a.format(l2);
                byArray2 = string.getBytes(this.mCodepage);
                if (this.checkOverflow(byArray, byArray2)) {
                    return DbfField.VALUE_OVERFLOW;
                }
                this.checkUnderflow(byArray, byArray2, 1, ' ');
                return DbfField.VALUE_OK;
            }
            throw new IllegalArgumentException();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DbfFieldValueException();
        }
    }

    public Object getValue(byte[] byArray) {
        String string;
        if (this.mPos < 1 || this.mOwner == null) {
            throw new UnsupportedOperationException();
        }
        try {
            string = new String(byArray, this.mPos, this.mWidth, this.mCodepage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DbfCodePageException(this.mCodepage);
        }
        try {
            String string2 = string.trim();
            if (this.mDec > 0) {
                return new Double(string2);
            }
            return new Long(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.isSpaces(string)) {
                return new DbfNullValue();
            }
            throw new DbfFieldValueException();
        }
    }

    public Object getDefaultValue() {
        if (this.mDec > 0) {
            return new Double(0.0);
        }
        return new Long(0L);
    }

    public DbfNumericField(String string, int n2, int n3) throws DbfFieldNameException, DbfFieldPrecisionException, DbfFieldWidthException {
        if (n2 < 1 || n2 > 255) {
            throw new DbfFieldWidthException(string);
        }
        if (n3 >= n2 || n3 < 0) {
            throw new DbfFieldPrecisionException(string);
        }
        this.setName(string);
        this.mType = 2;
        this.mWidth = n2;
        this.mDec = n3;
        this.mPos = 0;
        this.mOwner = null;
        this.mCodepage = null;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setMinusSign('-');
        decimalFormatSymbols.setDecimalSeparator('.');
        this.a = new DecimalFormat();
        this.a.setDecimalFormatSymbols(decimalFormatSymbols);
        ((NumberFormat)this.a).setGroupingUsed(false);
        this.a();
    }
}

