/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.file.shp;

import com.esri.mo.file.shp.DbfCodePageException;
import com.esri.mo.file.shp.DbfField;
import com.esri.mo.file.shp.DbfFieldNameException;
import com.esri.mo.file.shp.DbfFieldValueException;
import com.esri.mo.file.shp.DbfFieldWidthException;
import com.esri.mo.file.shp.DbfNullValue;
import java.io.UnsupportedEncodingException;

public class DbfMemoField
extends DbfField {
    public void setNumDec(int n2) {
        this.mDec = 0;
    }

    public void setWidth(int n2) {
        this.mWidth = 10;
    }

    public int putValue(byte[] byArray, Object object) {
        try {
            byte[] byArray2 = null;
            if (object instanceof DbfNullValue) {
                String string = new String(" ");
                byArray2 = string.getBytes(this.mCodepage);
                if (this.checkOverflow(byArray, byArray2)) {
                    return DbfField.VALUE_OVERFLOW;
                }
                this.checkUnderflow(byArray, byArray2, 0, ' ');
                return DbfField.VALUE_OK;
            }
            if (object instanceof Long) {
                String string = object.toString();
                byArray2 = string.getBytes(this.mCodepage);
                if (this.checkOverflow(byArray, byArray2)) {
                    return DbfField.VALUE_OVERFLOW;
                }
                this.checkUnderflow(byArray, byArray2, 1, ' ');
                return DbfField.VALUE_OK;
            }
            throw new IllegalArgumentException();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DbfFieldValueException();
        }
    }

    public Object getValue(byte[] byArray) {
        String string;
        if (this.mPos < 1 || this.mOwner == null) {
            throw new UnsupportedOperationException();
        }
        try {
            string = new String(byArray, this.mPos, this.mWidth, this.mCodepage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DbfCodePageException(this.mCodepage);
        }
        try {
            String string2 = string.trim();
            return new Long(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.isSpaces(string)) {
                return new DbfNullValue();
            }
            throw new DbfFieldValueException();
        }
    }

    public Object getDefaultValue() {
        return new Long(0L);
    }

    public DbfMemoField(String string, int n2) throws DbfFieldNameException, DbfFieldWidthException {
        if (n2 != 10) {
            throw new DbfFieldWidthException(string);
        }
        this.setName(string);
        this.mType = -2;
        this.mWidth = n2;
        this.mDec = 0;
        this.mPos = 0;
        this.mOwner = null;
        this.mCodepage = null;
    }

    public DbfMemoField(String string) {
        this.setName(string);
        this.mType = -2;
        this.mWidth = 10;
        this.mDec = 0;
        this.mPos = 0;
        this.mOwner = null;
        this.mCodepage = null;
    }
}

