/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.file.shp;

import com.esri.mo.file.shp.DbfCharacterField;
import com.esri.mo.file.shp.DbfCodePageException;
import com.esri.mo.file.shp.DbfDateField;
import com.esri.mo.file.shp.DbfFieldNameException;
import com.esri.mo.file.shp.DbfFieldTypeException;
import com.esri.mo.file.shp.DbfFieldValueException;
import com.esri.mo.file.shp.DbfFile;
import com.esri.mo.file.shp.DbfLogicalField;
import com.esri.mo.file.shp.DbfMemoField;
import com.esri.mo.file.shp.DbfNumericField;
import com.esri.mo.util.Endian;
import java.io.UnsupportedEncodingException;

public abstract class DbfField {
    public static int VALUE_OVERFLOW;
    public static int VALUE_OK;
    protected String mCodepage;
    protected DbfFile mOwner;
    protected int mPos;
    protected int mDec;
    protected int mWidth;
    protected int mType;
    protected String mName;

    static {
        VALUE_OK = 1;
        VALUE_OVERFLOW = 0;
    }

    private boolean a(char c2) {
        if (c2 >= 'A' && c2 <= 'Z') {
            return true;
        }
        if (c2 >= '0' && c2 <= '9') {
            return false;
        }
        if (c2 <= ' ') {
            return false;
        }
        if (c2 >= '!' && c2 <= '/') {
            return false;
        }
        if (c2 >= ':' && c2 <= '@') {
            return false;
        }
        if (c2 >= '[' && c2 <= '`') {
            return false;
        }
        return c2 < '{' || c2 > '~';
    }

    private boolean b(char c2) {
        return c2 == '_';
    }

    private boolean c(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isAstericks(String var1_1) {
        var4_2 = -1;
        var3_3 = var1_1.length();
        var2_4 = 0;
        {
            switch (var4_2) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    if (var1_1.charAt(var2_4) != '*') {
                        return false;
                    }
                    ++var2_4;
                    case 0: {
                        var4_2 = -1;
                    }
                    break;
                }
            }
        }
        if (var2_4 < var3_3) ** continue;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isSpaces(String var1_1) {
        var4_2 = -1;
        var3_3 = var1_1.length();
        var2_4 = 0;
        {
            switch (var4_2) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    if (var1_1.charAt(var2_4) != ' ') {
                        return false;
                    }
                    ++var2_4;
                    case 0: {
                        var4_2 = -1;
                    }
                    break;
                }
            }
        }
        if (var2_4 < var3_3) ** continue;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean checkOverflow(byte[] var1_1, byte[] var2_2) {
        var8_3 = -1;
        if (var2_2.length <= this.mWidth) {
            return false;
        }
        var5_4 = new StringBuffer(this.mWidth);
        var4_5 = 0;
        {
            switch (var8_3) {
                case 1: {
                    continue block8;
                }
                while (true) {
                    var5_4.append('*');
                    ++var4_5;
                    case 0: {
                        var8_3 = -1;
                    }
                    break;
                }
            }
        }
        if (var4_5 < this.mWidth) ** continue;
        var6_6 = var5_4.toString();
        try {
            var3_7 = var6_6.getBytes(this.mCodepage);
        }
        catch (UnsupportedEncodingException var7_8) {
            throw new DbfFieldValueException();
        }
        System.arraycopy(var3_7, 0, var1_1, this.mPos, this.mWidth);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void checkUnderflow(byte[] var1_1, byte[] var2_2, int var3_3, char var4_4) {
        var11_5 = -1;
        if (var2_2.length == this.mWidth) {
            System.arraycopy(var2_2, 0, var1_1, this.mPos, this.mWidth);
            return;
        }
        var7_6 = this.mWidth - var2_2.length;
        var8_7 = new StringBuffer(var7_6);
        var6_8 = 0;
        {
            switch (var11_5) {
                case 1: {
                    continue block8;
                }
                while (true) {
                    var8_7.append(var4_4);
                    ++var6_8;
                    case 0: {
                        var11_5 = -1;
                    }
                    break;
                }
            }
        }
        if (var6_8 < var7_6) ** continue;
        var9_9 = var8_7.toString();
        try {
            var5_10 = var9_9.getBytes(this.mCodepage);
        }
        catch (UnsupportedEncodingException var10_11) {
            throw new DbfFieldValueException();
        }
        if (var3_3 == 0) {
            System.arraycopy(var2_2, 0, var1_1, this.mPos, var2_2.length);
            System.arraycopy(var5_10, 0, var1_1, this.mPos + var2_2.length, var7_6);
        } else {
            System.arraycopy(var5_10, 0, var1_1, this.mPos, var7_6);
            System.arraycopy(var2_2, 0, var1_1, this.mPos + var7_6, this.mWidth - var7_6);
        }
        return;
    }

    public byte[] getValueAsBytes() {
        if (this.mPos < 1 || this.mOwner == null) {
            throw new UnsupportedOperationException();
        }
        byte[] byArray = this.mOwner.a();
        byte[] byArray2 = new byte[this.mWidth];
        System.arraycopy(byArray, this.mPos, byArray2, 0, this.mWidth);
        return byArray2;
    }

    /*
     * Unable to fully structure code
     */
    private boolean b(String var1_1) {
        var5_2 = -1;
        var3_3 = var1_1.length();
        var2_4 = 0;
        {
            switch (var5_2) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    var4_5 = var1_1.charAt(var2_4);
                    if (var4_5 < '0' || var4_5 > '9') {
                        return true;
                    }
                    ++var2_4;
                    case 0: {
                        var5_2 = -1;
                    }
                    break;
                }
            }
        }
        if (var2_4 < var3_3) ** continue;
        return false;
    }

    public abstract int putValue(byte[] var1, Object var2);

    public int putValue(Object object) {
        byte[] byArray = this.mOwner.a();
        return this.putValue(byArray, object);
    }

    public abstract Object getValue(byte[] var1);

    public Object getValue() {
        byte[] byArray = this.mOwner.a();
        return this.getValue(byArray);
    }

    public abstract Object getDefaultValue();

    public boolean isBinary() {
        return this.mType == -2;
    }

    public boolean isBoolean() {
        return this.mType == -7;
    }

    public boolean isDate() {
        return this.mType == 91;
    }

    public boolean isNumeric() {
        return this.mType == 2;
    }

    public boolean isString() {
        return this.mType == 1;
    }

    public DbfFile getOwner() {
        return this.mOwner;
    }

    public void setOwner(DbfFile dbfFile) {
        if (dbfFile == null) {
            throw new IllegalArgumentException();
        }
        this.mOwner = dbfFile;
        this.mCodepage = this.mOwner.getFileCodePage();
        return;
    }

    public int getPosition() {
        return this.mPos;
    }

    public void setPosition(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException();
        }
        this.mPos = n2;
        return;
    }

    public byte[] toBytes(String string) throws DbfCodePageException, DbfFieldTypeException {
        byte[] byArray;
        byte[] byArray2 = new byte[32];
        try {
            byArray = this.mName.getBytes(string);
        }
        catch (Exception exception) {
            throw new DbfCodePageException(string);
        }
        int n2 = byArray.length;
        if (n2 > 10) {
            n2 = 10;
        }
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        switch (this.mType) {
            case 1: {
                byArray2[11] = 67;
                break;
            }
            case 91: {
                byArray2[11] = 68;
                break;
            }
            case -7: {
                byArray2[11] = 76;
                break;
            }
            case -2: {
                byArray2[11] = 77;
                break;
            }
            case 2: {
                byArray2[11] = 78;
                break;
            }
            default: {
                throw new DbfFieldTypeException();
            }
        }
        byArray2[16] = (byte)this.mWidth;
        byArray2[17] = (byte)this.mDec;
        return byArray2;
    }

    public byte[] toBytes() {
        if (this.mCodepage == null) {
            throw new DbfCodePageException();
        }
        return this.toBytes(this.mCodepage);
    }

    public abstract void setNumDec(int var1);

    public int getNumDec() {
        return this.mDec;
    }

    public abstract void setWidth(int var1);

    public int getWidth() {
        return this.mWidth;
    }

    public int getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    /*
     * Unable to fully structure code
     */
    protected void setName(String var1_1) throws DbfFieldNameException {
        var4_2 = -1;
        if (var1_1 == null) {
            throw new DbfFieldNameException();
        }
        if (var1_1.length() < 1 || var1_1.length() > 10) {
            throw new DbfFieldNameException(var1_1);
        }
        var2_3 = 0;
        {
            switch (var4_2) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    var3_4 = var1_1.charAt(var2_3);
                    if (var2_3 == 0) {
                        if (!this.a(var3_4)) {
                            throw new DbfFieldNameException();
                        }
                    } else if (!(this.a(var3_4) || this.c(var3_4) || this.b(var3_4))) {
                        throw new DbfFieldNameException();
                    }
                    ++var2_3;
                    case 0: {
                        var4_2 = -1;
                    }
                    break;
                }
            }
        }
        if (var2_3 < var1_1.length()) ** continue;
        this.mName = new String(var1_1);
        return;
    }

    /*
     * Unable to fully structure code
     */
    public static DbfField create(byte[] var0, String var1_1) throws DbfFieldTypeException, DbfCodePageException {
        block17: {
            var8_2 = -1;
            var3_3 = 0;
            var2_4 = 0;
            {
                switch (var8_2) {
                    case 1: {
                        continue block15;
                    }
lbl8:
                    // 1 sources

                    while (var0[var2_4] != 0) {
                        ++var3_3;
                        ++var2_4;
                        case 0: {
                            var8_2 = -1;
                            break block15;
                        }
                    }
                    break block17;
                }
            }
            if (var2_4 < 12) ** GOTO lbl8
        }
        try {
            var6_5 = new String(var0, 0, var3_3, var1_1);
        }
        catch (UnsupportedEncodingException var7_6) {
            throw new DbfCodePageException(var1_1);
        }
        var4_7 = Endian.getUnsignedByte(var0, 16);
        var5_8 = Endian.getUnsignedByte(var0, 17);
        switch (var0[11]) {
            case 67: {
                return new DbfCharacterField(var6_5, var4_7);
            }
            case 68: {
                return new DbfDateField(var6_5, var4_7);
            }
            case 76: {
                return new DbfLogicalField(var6_5, var4_7);
            }
            case 70: 
            case 78: {
                return new DbfNumericField(var6_5, var4_7, var5_8);
            }
            case 66: 
            case 71: 
            case 77: {
                return new DbfMemoField(var6_5, var4_7);
            }
        }
        throw new DbfFieldTypeException(var6_5);
    }

    public static DbfField create(String string, int n2, int n3, int n4) {
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return new DbfCharacterField(string, n3);
            }
            case 91: {
                return new DbfDateField(string);
            }
            case -7: {
                return new DbfLogicalField(string);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return new DbfNumericField(string, n3, n4);
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return new DbfNumericField(string, n3, 0);
            }
            case -4: 
            case -3: 
            case -2: {
                return new DbfMemoField(string);
            }
        }
        throw new IllegalArgumentException();
    }
}

