/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.file.shp;

import com.esri.mo.file.shp.DbfCodePageException;
import com.esri.mo.file.shp.DbfField;
import com.esri.mo.file.shp.DbfFieldNameException;
import com.esri.mo.file.shp.DbfFieldValueException;
import com.esri.mo.file.shp.DbfFieldWidthException;
import com.esri.mo.file.shp.DbfNullValue;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DbfDateField
extends DbfField {
    private SimpleDateFormat a;

    public void setNumDec(int n2) {
        this.mDec = 0;
    }

    public void setWidth(int n2) {
        this.mWidth = 8;
    }

    public int putValue(byte[] byArray, Object object) {
        try {
            byte[] byArray2 = null;
            if (object instanceof DbfNullValue) {
                String string = new String(" ");
                byArray2 = string.getBytes(this.mCodepage);
                if (this.checkOverflow(byArray, byArray2)) {
                    return DbfField.VALUE_OVERFLOW;
                }
                this.checkUnderflow(byArray, byArray2, 0, ' ');
                return DbfField.VALUE_OK;
            }
            if (object instanceof Date) {
                String string = this.a.format((Date)object);
                byArray2 = string.getBytes(this.mCodepage);
                if (this.checkOverflow(byArray, byArray2)) {
                    return DbfField.VALUE_OVERFLOW;
                }
                this.checkUnderflow(byArray, byArray2, 1, ' ');
                return DbfField.VALUE_OK;
            }
            throw new IllegalArgumentException();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DbfFieldValueException();
        }
    }

    public Object getValue(byte[] byArray) {
        String string;
        if (this.mPos < 1 || this.mOwner == null) {
            throw new UnsupportedOperationException();
        }
        try {
            string = new String(byArray, this.mPos, this.mWidth, this.mCodepage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DbfCodePageException(this.mCodepage);
        }
        try {
            return this.a.parse(string);
        }
        catch (ParseException parseException) {
            if (this.isSpaces(string)) {
                return new DbfNullValue();
            }
            throw new DbfFieldValueException();
        }
    }

    public Object getDefaultValue() {
        return new Date(0L);
    }

    public DbfDateField(String string, int n2) throws DbfFieldNameException, DbfFieldWidthException {
        this(string);
        if (n2 != 8) {
            throw new DbfFieldWidthException(string);
        }
        this.mWidth = n2;
    }

    public DbfDateField(String string) {
        this.setName(string);
        this.mType = 91;
        this.mWidth = 8;
        this.mDec = 0;
        this.mPos = 0;
        this.mOwner = null;
        this.mCodepage = null;
        this.a = new SimpleDateFormat("yyyyMMdd");
        this.a.setTimeZone(TimeZone.getTimeZone("GMT0"));
    }
}

