/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.data.odb;

import com.esri.mo.data.feat.BaseRow;
import com.esri.mo.data.feat.DataID;
import com.esri.mo.data.odb.CacheListener;
import com.esri.mo.data.odb.LRUObjectCache;
import com.esri.mo.data.odb.ObjectDataStore;
import com.esri.mo.util.MessageCentre;
import java.io.File;
import java.io.IOException;

public class CachedObjectDataStore
extends ObjectDataStore
implements CacheListener {
    private double a;
    private double b;
    private LRUObjectCache c;

    public void overflow(Comparable comparable, Object object, boolean bl) {
        try {
            if (!bl) {
                super.putObject(comparable, object);
            }
        }
        catch (IOException iOException) {
            MessageCentre.get().log(this, iOException);
        }
        return;
    }

    public boolean removeObject(Comparable comparable) throws IOException {
        if (this.c.removeObject(comparable) != null) {
            return true;
        }
        return super.removeObject(comparable);
    }

    public void putObject(Comparable comparable, Object object) throws IOException {
        this.c.putObject(comparable, object, false);
        return;
    }

    public void resetStatistics() {
        this.a = 0.0;
        this.b = 0.0;
        return;
    }

    public double getHitRatio() {
        if (this.a == 0.0) {
            return -1.0;
        }
        return (this.a - this.b) / this.a;
    }

    public boolean hasObject(Comparable comparable) {
        if (!this.c.hasObject(comparable)) {
            return super.hasObject(comparable);
        }
        return true;
    }

    public Object getObject(Comparable comparable) throws ClassNotFoundException, IOException {
        Object object = this.c.getObject(comparable);
        if (object == null) {
            this.b += 1.0;
            object = super.getObject(comparable);
            if (object instanceof BaseRow) {
                ((BaseRow)object).setDataID((DataID)comparable);
            }
            if (object != null) {
                this.c.putObject(comparable, object, true);
            }
        }
        this.a += 1.0;
        return object;
    }

    public void setMaximumMemorySize(int n2) {
        this.c.setMaximumSize(n2);
        return;
    }

    public int getMaximumMemorySize() {
        return this.c.getMaximumSize();
    }

    public CachedObjectDataStore(File file, boolean bl, String string, int n2) throws IOException {
        super(file, bl, string);
        this.c = new LRUObjectCache(this, n2);
        this.resetStatistics();
    }
}

