/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.data.feat;

import com.esri.mo.axl.map.FieldElement;
import com.esri.mo.axl.map.FieldValueElement;
import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Geometry;
import com.esri.mo.data.feat.Field;
import com.esri.mo.data.text.CombinedScientificDoubleFormat;
import com.esri.mo.data.text.DoubleConversion;
import com.esri.mo.util.Date;
import com.esri.mo.util.Resource;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class BaseField
implements Serializable,
Field {
    private DateFormat h;
    private DateFormat g;
    private CombinedScientificDoubleFormat f;
    private NumberFormat e;
    private int c;
    private int b;
    private int a;
    private String d;

    public FieldElement toAXL(XmlDocument xmlDocument, Object object) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = (FieldElement)((Object)xmlDocument.createElement("FIELD"));
        if (fieldElement == null) {
            throw new IncompleteDictionaryException();
        }
        fieldElement.setName(this.getName());
        fieldElement.setPrecision(this.getPrecision());
        fieldElement.setSize(this.getDisplaySize());
        fieldElement.setType(this.getType());
        if (object != null) {
            FieldValueElement fieldValueElement = (FieldValueElement)((Object)xmlDocument.createElement("FIELDVALUE"));
            if (object instanceof FeatureGeometry) {
                FeatureGeometry featureGeometry = (FeatureGeometry)object;
                fieldValueElement.setValue((Object)featureGeometry.toAXL(xmlDocument));
            } else if (object instanceof java.util.Date) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT0"));
                fieldValueElement.setValue(simpleDateFormat.format((java.util.Date)object));
            } else if ((this.isDate() || this.isTimeStamp()) && object instanceof String) {
                java.util.Date date;
                try {
                    date = (java.util.Date)this.a((String)object, Locale.getDefault());
                }
                catch (Exception exception) {
                    date = new java.util.Date(0L);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT0"));
                fieldValueElement.setValue(simpleDateFormat.format(date));
            } else {
                fieldValueElement.setValue(object.toString());
            }
            fieldElement.setFieldValue(fieldValueElement);
        }
        return fieldElement;
    }

    public boolean isNumeric() {
        return this.isInteger() || this.isDouble() || this.isLong() || this.isByte() || this.isShort() || this.isBigDecimal() || this.isFloat();
    }

    public boolean isComparable() {
        return this.isString() || this.isInteger() || this.isDouble() || this.isDate() || this.isTime() || this.isTimeStamp() || this.isLong() || this.isShort() || this.isByte() || this.isFloat() || this.isBigDecimal();
    }

    public boolean isTimeStamp() {
        return this.a == 93;
    }

    public boolean isTime() {
        return this.a == 92;
    }

    public boolean isDate() {
        return this.a == 91;
    }

    public boolean isByteArray() {
        return this.a == -2 || this.a == -3 || this.a == -4;
    }

    public boolean isDouble() {
        return this.a == 8;
    }

    public boolean isFloat() {
        return this.a == 6 || this.a == 7;
    }

    public boolean isLong() {
        return this.a == -5;
    }

    public boolean isInteger() {
        return this.a == 4;
    }

    public boolean isShort() {
        return this.a == 5;
    }

    public boolean isByte() {
        return this.a == -6;
    }

    public boolean isBoolean() {
        return this.a == -7;
    }

    public boolean isBigDecimal() {
        return this.a == 2 || this.a == 3;
    }

    public boolean isString() {
        return this.a == 1 || this.a == 12 || this.a == -1;
    }

    public boolean isObject() {
        return this.a == 1111 || this.a == 2000;
    }

    public boolean isShape() {
        return this.a == -98;
    }

    public Object defaultValue() {
        if (this.isInteger()) {
            return new Integer(0);
        }
        if (this.isDouble()) {
            return new Double(0.0);
        }
        if (this.isDate()) {
            return new Date(0L);
        }
        if (this.isTime()) {
            return new Time(0L);
        }
        if (this.isTimeStamp()) {
            return new Timestamp(0L);
        }
        if (this.isBoolean()) {
            return new Boolean(false);
        }
        if (this.isLong()) {
            return new Long(0L);
        }
        if (this.isShort()) {
            return new Short(0);
        }
        if (this.isByte()) {
            return new Byte(0);
        }
        if (this.isFloat()) {
            return new Float(0.0f);
        }
        if (this.isBigDecimal()) {
            return new BigDecimal(0.0);
        }
        if (this.isByteArray()) {
            return new byte[0];
        }
        return "";
    }

    public Object parse(String string) {
        try {
            if (this.isString()) {
                return string;
            }
            if (this.isInteger()) {
                return new Integer(string);
            }
            if (this.isDouble()) {
                return new Double(string);
            }
            if (this.isDate()) {
                return java.sql.Date.valueOf(string);
            }
            if (this.isTime()) {
                return Time.valueOf(string);
            }
            if (this.isTimeStamp()) {
                return Timestamp.valueOf(string);
            }
            if (this.isBoolean()) {
                return new Boolean(string);
            }
            if (this.isLong()) {
                return new Long(string);
            }
            if (this.isShort()) {
                return new Short(string);
            }
            if (this.isByte()) {
                return new Byte(string);
            }
            if (this.isFloat()) {
                return new Float(string);
            }
            if (this.isBigDecimal()) {
                return new BigDecimal(string);
            }
            if (this.isByteArray()) {
                return string.getBytes();
            }
        }
        catch (Exception exception) {
            return this.defaultValue();
        }
        return string;
    }

    public Object parseNoDefault(String string, Locale locale) throws Exception {
        if (this.isString()) {
            return string;
        }
        if (this.isInteger()) {
            return new Integer(this.getIntegerFormat(locale).parse(string).intValue());
        }
        if (this.isDouble()) {
            return new Double(DoubleConversion.stringToDouble(string, this.getDoubleFormat(locale)));
        }
        if (this.isDate()) {
            return this.a(string, locale);
        }
        if (this.isTime()) {
            return Time.valueOf(string);
        }
        if (this.isTimeStamp()) {
            return Timestamp.valueOf(string);
        }
        if (this.isBoolean()) {
            return new Boolean(string);
        }
        if (this.isLong()) {
            return new Long(this.getIntegerFormat(locale).parse(string).longValue());
        }
        if (this.isShort()) {
            return new Short(this.getIntegerFormat(locale).parse(string).shortValue());
        }
        if (this.isByte()) {
            return new Byte(this.getIntegerFormat(locale).parse(string).byteValue());
        }
        if (this.isFloat()) {
            return new Float(DoubleConversion.stringToDouble(string, this.getDoubleFormat(locale)));
        }
        if (this.isBigDecimal()) {
            return new BigDecimal(string);
        }
        if (this.isByteArray()) {
            return string.getBytes();
        }
        return string;
    }

    public Object parse(String string, Locale locale) {
        try {
            return this.parseNoDefault(string, locale);
        }
        catch (Exception exception) {
            return this.defaultValue();
        }
    }

    private final Object a(String string, Locale locale) throws Exception {
        java.util.Date date = null;
        try {
            date = this.getDateTimeFormat(locale).parse(string);
        }
        catch (Exception exception) {
            date = this.getDateFormat(locale).parse(string);
        }
        Date date2 = new Date(date.getTime());
        return date2;
    }

    public DateFormat getDateFormat(Locale locale) {
        if (this.h == null) {
            this.h = BaseField.getStandardDateFormat(locale);
        }
        return this.h;
    }

    public DateFormat getDateTimeFormat(Locale locale) {
        if (this.g == null) {
            this.g = BaseField.getStandardDateTimeFormat(locale);
        }
        return this.g;
    }

    public CombinedScientificDoubleFormat getCombinedFormat(Locale locale) {
        CombinedScientificDoubleFormat combinedScientificDoubleFormat = this.f;
        if (combinedScientificDoubleFormat == null || !this.f.getLocale().equals(locale)) {
            NumberFormat numberFormat = BaseField.getStandardDoubleFormat(locale);
            numberFormat.setMaximumFractionDigits(this.getPrecision());
            numberFormat.setMaximumIntegerDigits(this.getDisplaySize() - this.getPrecision() - 1);
            this.f = combinedScientificDoubleFormat = new CombinedScientificDoubleFormat(numberFormat, locale);
        }
        return combinedScientificDoubleFormat;
    }

    public NumberFormat getDoubleFormat(Locale locale) {
        return this.getCombinedFormat(locale).getRegular();
    }

    public NumberFormat getIntegerFormat(Locale locale) {
        NumberFormat numberFormat = this.e;
        if (numberFormat == null) {
            this.e = numberFormat = BaseField.getStandardIntegerFormat(locale);
        }
        return numberFormat;
    }

    public static NumberFormat getStandardDoubleFormat(Locale locale) {
        return DoubleConversion.getStandardFormat(locale);
    }

    public static DateFormat getStandardDateFormat(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT0"));
        dateFormat.setLenient(true);
        return dateFormat;
    }

    public static DateFormat getStandardDateTimeFormat(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT0"));
        dateFormat.setLenient(true);
        return dateFormat;
    }

    public static NumberFormat getStandardIntegerFormat(Locale locale) {
        NumberFormat numberFormat = DoubleConversion.getStandardFormat(locale);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumFractionDigits(0);
        return numberFormat;
    }

    private final String a(byte[] byArray) {
        return new String(byArray, 0, byArray.length);
    }

    public String format(Object object, Locale locale) {
        if (object == null) {
            return Resource.getBundleText("NullDisplayText");
        }
        try {
            if (this.isString()) {
                return object.toString();
            }
            if (this.isInteger()) {
                return this.getIntegerFormat(locale).format(((Number)object).longValue());
            }
            if (this.isDouble()) {
                return this.getCombinedFormat(locale).format(((Number)object).doubleValue());
            }
            if (this.isDate()) {
                return this.getDateTimeFormat(locale).format((java.util.Date)object);
            }
            if (this.isTime()) {
                return object.toString();
            }
            if (this.isTimeStamp()) {
                return object.toString();
            }
            if (this.isBoolean()) {
                return object.toString();
            }
            if (this.isLong()) {
                return this.getIntegerFormat(locale).format(((Number)object).longValue());
            }
            if (this.isShort()) {
                return this.getIntegerFormat(locale).format(((Number)object).longValue());
            }
            if (this.isByte()) {
                return this.getIntegerFormat(locale).format(((Number)object).longValue());
            }
            if (this.isFloat()) {
                return this.getCombinedFormat(locale).format(((Number)object).doubleValue());
            }
            if (this.isBigDecimal()) {
                return this.getIntegerFormat(locale).format(((Number)object).longValue());
            }
            if (this.isByteArray()) {
                return this.a((byte[])object);
            }
            return object.toString();
        }
        catch (Exception exception) {
            return object.toString();
        }
    }

    public String format(Object object) {
        return this.format(object, Locale.getDefault());
    }

    public boolean equals(Field field) {
        return this.d.equalsIgnoreCase(field.getName()) && this.a == field.getType();
    }

    public void setPrecision(int n2) {
        this.c = n2;
    }

    public int getPrecision() {
        return this.c;
    }

    public void setDisplaySize(int n2) {
        this.b = n2;
    }

    public int getDisplaySize() {
        return this.b;
    }

    public void setType(int n2) {
        this.a = n2;
    }

    public int getType() {
        return this.a;
    }

    public String getInternalName() {
        return this.getName();
    }

    public void setName(String string) {
        this.d = string;
    }

    public String getName() {
        return this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.d);
        stringBuffer.append(",");
        stringBuffer.append(this.a);
        stringBuffer.append(",");
        stringBuffer.append(this.b);
        stringBuffer.append(",");
        stringBuffer.append(this.c);
        return stringBuffer.toString();
    }

    public Object cloneData(Object object) {
        if (this.isString() && object instanceof String) {
            return new String((String)object);
        }
        if (this.isInteger() && object instanceof Integer) {
            return new Integer((Integer)object);
        }
        if (this.isDouble() && object instanceof Double) {
            return new Double((Double)object);
        }
        if (this.isShape() && object instanceof Geometry) {
            return ((Geometry)object).clone();
        }
        if (this.isDate()) {
            if (object instanceof Date) {
                return ((Date)object).clone();
            }
            return ((java.util.Date)object).clone();
        }
        if (this.isTime() && object instanceof Time) {
            return ((Time)object).clone();
        }
        if (this.isTimeStamp() && object instanceof Timestamp) {
            return ((Timestamp)object).clone();
        }
        if (this.isBoolean() && object instanceof Boolean) {
            return new Boolean((Boolean)object);
        }
        if (this.isLong() && object instanceof Long) {
            return new Long((Long)object);
        }
        if (this.isShort() && object instanceof Short) {
            return new Short((Short)object);
        }
        if (this.isByte() && object instanceof Byte) {
            return new Byte((Byte)object);
        }
        if (this.isFloat() && object instanceof Float) {
            return new Float(((Float)object).floatValue());
        }
        if (this.isBigDecimal() && object instanceof BigDecimal) {
            BigDecimal bigDecimal = new BigDecimal(0.0);
            return bigDecimal.add((BigDecimal)object);
        }
        if (this.isByteArray() && object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        throw new IllegalArgumentException();
    }

    public Object clone() {
        return new BaseField(this.d, this.a, this.b, this.c);
    }

    public BaseField(String string, int n2, int n3, int n4) {
        this.d = string;
        this.a = n2;
        this.b = n3;
        this.c = n4;
    }
}

