/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geom;

import com.esri.mo.axl.geom.GeometryElement;
import com.esri.mo.axl.geom.PointElement;
import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.cs.geom.BaseMultiPoint;
import com.esri.mo.cs.geom.BasePointIterator;
import com.esri.mo.cs.geom.BasePointsArray;
import com.esri.mo.cs.geom.Clementini;
import com.esri.mo.cs.geom.ClementiniGeometry;
import com.esri.mo.cs.geom.Cogo;
import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Geometry;
import com.esri.mo.cs.geom.HitResult;
import com.esri.mo.cs.geom.MultiPoint;
import com.esri.mo.cs.geom.PointApplicator;
import com.esri.mo.cs.geom.PointCollection;
import com.esri.mo.cs.geom.Polygon;
import com.esri.mo.cs.geom.Polyline;
import com.esri.mo.cs.geom.b;
import com.esri.mo.util.FloatingPointCompare;
import com.sun.xml.tree.XmlDocument;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Point
extends Point2D.Double
implements Externalizable,
Comparable,
MultiPoint {
    public void fromAXL(GeometryElement geometryElement) throws IOException {
        if (!(geometryElement instanceof PointElement)) {
            throw new IllegalArgumentException();
        }
        PointElement pointElement = (PointElement)geometryElement;
        this.setX(pointElement.getX());
        this.setY(pointElement.getY());
        return;
    }

    public GeometryElement toAXL(XmlDocument xmlDocument) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        PointElement pointElement = (PointElement)((Object)xmlDocument.createElement("POINT"));
        if (pointElement == null) {
            throw new IncompleteDictionaryException();
        }
        pointElement.set(this.getX(), this.getY());
        return pointElement;
    }

    public Polygon convexHull() {
        return null;
    }

    public ClementiniGeometry clem_getBoundary() {
        return b.a();
    }

    public boolean clem_onBoundary(double d2, double d3) {
        return false;
    }

    public int clem_relatePolyline(Polyline polyline) {
        return Clementini.inverseRelate(polyline.clem_relatePoint(this.x, this.y));
    }

    public int clem_relateMultiPoint(MultiPoint multiPoint) {
        return Clementini.inverseRelate(multiPoint.clem_relatePoint(this.x, this.y));
    }

    public int clem_relateEnvelope(Envelope envelope) {
        return Clementini.inverseRelate(envelope.clem_relatePoint(this.x, this.y));
    }

    public int clem_relatePolygonBoundary(Polygon polygon) {
        if (polygon.clem_touchPoint(this.x, this.y)) {
            return 0;
        }
        return 2;
    }

    public int clem_relatePolygon(Polygon polygon) {
        return Clementini.inverseRelate(polygon.clem_relatePoint(this.x, this.y));
    }

    public int clem_relate(ClementiniGeometry clementiniGeometry) {
        return Clementini.inverseRelate(clementiniGeometry.clem_relatePoint(this.x, this.y));
    }

    public int clem_relatePoint(double d2, double d3) {
        if (this.clem_disjointPoint(d2, d3)) {
            return 2;
        }
        return 5;
    }

    public int clem_relatePoint(Point point) {
        return this.clem_relatePoint(point.x, point.y);
    }

    public boolean equal(ClementiniGeometry clementiniGeometry) {
        if (clementiniGeometry instanceof Point) {
            Point point = (Point)clementiniGeometry;
            if (FloatingPointCompare.eq(this.x, point.x) && FloatingPointCompare.eq(this.y, point.y)) {
                return true;
            }
        }
        return false;
    }

    public boolean clem_containEnvelope(Envelope envelope) {
        return false;
    }

    public boolean clem_containPolygon(Polygon polygon) {
        return false;
    }

    public boolean clem_containPolyline(Polyline polyline) {
        return false;
    }

    public boolean clem_containPolygonBoundary(Polygon polygon) {
        return false;
    }

    public boolean clem_containMultiPoint(MultiPoint multiPoint) {
        if (multiPoint.size() > 1) {
            return false;
        }
        return multiPoint.clem_containPoint(this.x, this.y);
    }

    public boolean clem_containPoint(double d2, double d3) {
        return !this.clem_disjointPoint(d2, d3);
    }

    public boolean clem_containPoint(Point point) {
        return !this.clem_disjointPoint(point.x, point.y);
    }

    public boolean clem_contain(ClementiniGeometry clementiniGeometry) {
        int n2 = Clementini.inverseRelate(clementiniGeometry.clem_relatePoint(this.x, this.y));
        return n2 == 6 || n2 == 5;
    }

    public boolean clem_crossEnvelope(Envelope envelope) {
        return false;
    }

    public boolean clem_crossPolygon(Polygon polygon) {
        return false;
    }

    public boolean clem_crossPolygonBoundary(Polygon polygon) {
        return false;
    }

    public boolean clem_crossPolyline(Polyline polyline) {
        return false;
    }

    public boolean clem_crossMultiPoint(MultiPoint multiPoint) {
        return false;
    }

    public boolean clem_cross(ClementiniGeometry clementiniGeometry) {
        return false;
    }

    public boolean clem_overlapEnvelope(Envelope envelope) {
        return false;
    }

    public boolean clem_overlapPolygon(Polygon polygon) {
        return false;
    }

    public boolean clem_overlapPolygonBoundary(Polygon polygon) {
        return false;
    }

    public boolean clem_overlapPolyline(Polyline polyline) {
        return false;
    }

    public boolean clem_overlapMultiPoint(MultiPoint multiPoint) {
        return false;
    }

    public boolean clem_overlap(ClementiniGeometry clementiniGeometry) {
        return false;
    }

    public boolean clem_insideEnvelope(Envelope envelope) {
        return envelope.clem_containPoint(this.x, this.y);
    }

    public boolean clem_insidePolygon(Polygon polygon) {
        return polygon.clem_containPoint(this.x, this.y);
    }

    public boolean clem_insidePolygonBoundary(Polygon polygon) {
        return polygon.clem_touchPoint(this.x, this.y);
    }

    public boolean clem_insidePolyline(Polyline polyline) {
        return polyline.clem_containPoint(this.x, this.y);
    }

    public boolean clem_insideMultiPoint(MultiPoint multiPoint) {
        return multiPoint.clem_containPoint(this.x, this.y);
    }

    public boolean clem_inside(ClementiniGeometry clementiniGeometry) {
        return clementiniGeometry.clem_containPoint(this.x, this.y);
    }

    public boolean clem_touch(ClementiniGeometry clementiniGeometry) {
        return clementiniGeometry.clem_touchPoint(this.x, this.y);
    }

    public boolean clem_touchEnvelope(Envelope envelope) {
        return envelope.clem_touchPoint(this.x, this.y);
    }

    public boolean clem_touchPolygonBoundary(Polygon polygon) {
        return false;
    }

    public boolean clem_touchPolygon(Polygon polygon) {
        return polygon.clem_touchPoint(this.x, this.y);
    }

    public boolean clem_touchPolyline(Polyline polyline) {
        return polyline.clem_touchPoint(this.x, this.y);
    }

    public boolean clem_touchMultiPoint(MultiPoint multiPoint) {
        return false;
    }

    public boolean clem_touchPoint(double d2, double d3) {
        return false;
    }

    public FeatureGeometry clip(Envelope envelope) {
        if (envelope.clem_disjointPoint(this.x, this.y)) {
            return null;
        }
        return new Point(this.x, this.y);
    }

    public boolean combineWith(FeatureGeometry featureGeometry) {
        return false;
    }

    public boolean clem_disjointEnvelope(Envelope envelope) {
        return envelope.clem_disjointPoint(this.x, this.y);
    }

    public boolean clem_disjointPolygon(Polygon polygon) {
        return polygon.clem_disjointPoint(this.x, this.y);
    }

    public boolean clem_disjointPolygonBoundary(Polygon polygon) {
        return !polygon.clem_touchPoint(this.x, this.y);
    }

    public boolean clem_disjointPolyline(Polyline polyline) {
        return polyline.clem_disjointPoint(this.x, this.y);
    }

    public boolean clem_disjointMultiPoint(MultiPoint multiPoint) {
        return multiPoint.clem_disjointPoint(this.x, this.y);
    }

    public boolean clem_disjointPoint(double d2, double d3) {
        return !Cogo.equal(this.x, this.y, d2, d3);
    }

    public boolean clem_disjoint(ClementiniGeometry clementiniGeometry) {
        return clementiniGeometry.clem_disjointPoint(this.x, this.y);
    }

    public boolean hitTest(Point point, double d2, HitResult hitResult) {
        double d3 = this.distance(point);
        if (d3 <= d2) {
            hitResult.partIndex = 0;
            hitResult.pointIndex = 0;
            hitResult.distance = d3;
            return true;
        }
        return false;
    }

    public void translate(double d2, double d3) {
        this.x += d2;
        this.y += d3;
        return;
    }

    public double distanceSqToEnvelope(Envelope envelope) {
        return envelope.distanceSqToPoint(this.x, this.y);
    }

    public double distanceSqToPolyline(Polyline polyline) {
        return polyline.distanceSqToPoint(this.x, this.y);
    }

    public double distanceSqToPolygon(Polygon polygon) {
        return polygon.distanceSqToPoint(this.x, this.y);
    }

    public double distanceSqToMultiPoint(MultiPoint multiPoint) {
        return multiPoint.distanceSqToPoint(this.x, this.y);
    }

    public double distanceSqTo(FeatureGeometry featureGeometry) {
        return featureGeometry.distanceSqToPoint(this.x, this.y);
    }

    public double distanceSqToPoint(double d2, double d3) {
        return this.distanceSq(d2, d3);
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        return FloatingPointCompare.le(this.x, d2) && FloatingPointCompare.le(this.x, d2 + d4) && FloatingPointCompare.le(d3, this.y) && FloatingPointCompare.le(this.y, d3 + d5);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public final Rectangle2D getBounds2D() {
        return this.getEnvelope();
    }

    public final Rectangle getBounds() {
        return this.getEnvelope().toRectangle();
    }

    public final boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    public final boolean contains(double d2, double d3, double d4, double d5) {
        return false;
    }

    public boolean contains(Point2D point2D) {
        return false;
    }

    public boolean contains(double d2, double d3) {
        return false;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return new BasePointIterator(affineTransform, this);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new BasePointIterator(affineTransform, this);
    }

    public Geometry getGeometry(int n2) {
        return this.getPoint(n2);
    }

    public int size() {
        return 1;
    }

    public Object clone() {
        return new Point(this);
    }

    public Point getPoint(int n2) {
        if (n2 == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public final Polygon buffer(double d2, double d3) {
        return new BaseMultiPoint(this.getPoints()).buffer(d2, d3);
    }

    public PointCollection getPoints() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        dArray[0] = this.x;
        dArray2[0] = this.y;
        return new BasePointsArray(dArray, dArray2);
    }

    public void apply(PointApplicator pointApplicator) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        dArray[0] = this.x;
        dArray2[0] = this.y;
        pointApplicator.apply(dArray, dArray2);
        this.x = dArray[0];
        this.y = dArray2[0];
        return;
    }

    public Envelope getEnvelopeByRef() {
        return this.getEnvelope(null);
    }

    public Envelope getEnvelope(Envelope envelope) {
        if (envelope == null) {
            envelope = new Envelope();
        }
        envelope.x = this.x;
        envelope.y = this.y;
        envelope.width = 0.0;
        envelope.height = 0.0;
        return envelope;
    }

    public Envelope getEnvelope() {
        return this.getEnvelope(null);
    }

    public void setY(double d2) {
        this.y = d2;
    }

    public void setX(double d2) {
        this.x = d2;
    }

    public Point(Point point) {
        super(point.x, point.y);
    }

    public Point(double d2, double d3) {
        super(d2, d3);
    }

    public Point() {
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        return;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        return;
    }

    public int compareTo(Object object) {
        Point point = (Point)object;
        if (FloatingPointCompare.eq(this.x, point.x)) {
            if (FloatingPointCompare.eq(this.y, point.y)) {
                return 0;
            }
            if (this.y < point.y) {
                return -1;
            }
            return 1;
        }
        if (this.x < point.x) {
            return -1;
        }
        return 1;
    }
}

