/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geom;

import com.esri.mo.axl.geom.EnvelopeElement;
import com.esri.mo.axl.geom.GeometryElement;
import com.esri.mo.cs.geom.BasePointsArray;
import com.esri.mo.cs.geom.BasePolygon;
import com.esri.mo.cs.geom.BaseRing;
import com.esri.mo.cs.geom.Clementini;
import com.esri.mo.cs.geom.ClementiniGeometry;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Geometry;
import com.esri.mo.cs.geom.HitResult;
import com.esri.mo.cs.geom.MultiPoint;
import com.esri.mo.cs.geom.Path;
import com.esri.mo.cs.geom.Point;
import com.esri.mo.cs.geom.PointApplicator;
import com.esri.mo.cs.geom.PointCollection;
import com.esri.mo.cs.geom.Polygon;
import com.esri.mo.cs.geom.Polyline;
import com.esri.mo.cs.geom.RelativeCompare;
import com.esri.mo.cs.geom.Ring;
import com.esri.mo.cs.geom.SegmentHitResult;
import com.esri.mo.cs.geom.a;
import com.esri.mo.cs.geom.h;
import com.esri.mo.util.FloatingPointCompare;
import com.sun.xml.tree.XmlDocument;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.NumberFormat;

public class Envelope
extends Rectangle2D.Double
implements Polygon {
    private static final Envelope a = new Envelope(0.0, 0.0, -1.0, -1.0);

    public Polygon convexHull() {
        return (Polygon)this.clone();
    }

    public Polygon exclusiveOr(Polygon polygon) {
        return BasePolygon.exclusiveOr(this, polygon);
    }

    public FeatureGeometry clip(Envelope envelope) {
        if (this.getEnvelopeByRef().clem_disjointEnvelope(envelope)) {
            return null;
        }
        if (this.getEnvelopeByRef().clem_insideEnvelope(envelope)) {
            return (FeatureGeometry)this.clone();
        }
        double d2 = this.getXMin();
        double d3 = this.getXMax();
        double d4 = this.getYMin();
        double d5 = this.getYMax();
        double d6 = envelope.getXMin();
        double d7 = envelope.getXMax();
        double d8 = envelope.getYMin();
        double d9 = envelope.getYMax();
        if (d2 < d6) {
            d2 = d6;
        }
        if (d4 < d8) {
            d4 = d8;
        }
        if (d3 > d7) {
            d3 = d7;
        }
        if (d5 > d9) {
            d5 = d9;
        }
        return new Envelope(d2, d4, d3 - d2, d5 - d4);
    }

    public boolean combineWith(FeatureGeometry featureGeometry) {
        double d2 = this.getXMin();
        double d3 = this.getXMax();
        double d4 = this.getYMin();
        double d5 = this.getYMax();
        Envelope envelope = (Envelope)featureGeometry;
        double d6 = envelope.getXMin();
        double d7 = envelope.getXMax();
        double d8 = envelope.getYMin();
        double d9 = envelope.getYMax();
        if (d6 < d2) {
            d2 = d6;
        }
        if (d8 < d4) {
            d4 = d8;
        }
        if (d7 > d3) {
            d3 = d7;
        }
        if (d9 > d5) {
            d5 = d9;
        }
        this.x = d2;
        this.y = d4;
        this.width = d3 - d2;
        this.height = d5 - d4;
        return true;
    }

    public Polygon intersection(Polygon polygon) {
        return BasePolygon.intersection(this, polygon);
    }

    public Polygon subtract(Polygon polygon) {
        return BasePolygon.subtract(this, polygon);
    }

    public Polygon union(Polygon polygon) {
        return BasePolygon.union(this, polygon);
    }

    public ClementiniGeometry clem_getBoundary() {
        return new a(this);
    }

    public void fromAXL(GeometryElement geometryElement) throws IOException {
        if (!(geometryElement instanceof EnvelopeElement)) {
            throw new IllegalArgumentException();
        }
        EnvelopeElement envelopeElement = (EnvelopeElement)geometryElement;
        this.x = envelopeElement.getMinX();
        this.y = envelopeElement.getMinY();
        this.width = envelopeElement.getMaxX() - this.x;
        this.height = envelopeElement.getMaxY() - this.y;
        return;
    }

    public GeometryElement toAXL(XmlDocument xmlDocument) {
        EnvelopeElement envelopeElement = (EnvelopeElement)((Object)xmlDocument.createElement("ENVELOPE"));
        envelopeElement.set(this.getMinX(), this.getMinY(), this.getMaxX(), this.getMaxY());
        return envelopeElement;
    }

    public boolean equals(Envelope envelope, double d2) {
        if (envelope == null) {
            throw new IllegalArgumentException();
        }
        return FloatingPointCompare.eq(envelope.x, this.x, d2) && FloatingPointCompare.eq(envelope.y, this.y, d2) && FloatingPointCompare.eq(envelope.width, this.width, d2) && FloatingPointCompare.eq(envelope.height, this.height, d2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof Envelope) {
            return this.equals((Envelope)object, 2.220446049250313E-16);
        }
        return false;
    }

    public Point getPoint(int n2, int n3) {
        return this.getRing(0).getPoints().getPoint(n3);
    }

    public boolean segmentHitTest(Point point, double d2, SegmentHitResult segmentHitResult) {
        segmentHitResult.start.partIndex = 0;
        segmentHitResult.end.partIndex = 0;
        return this.getRing(0).getPoints().segmentHitTest(point, d2, segmentHitResult, false);
    }

    public boolean hitTest(Point point, double d2, HitResult hitResult) {
        hitResult.partIndex = 0;
        return this.getRing(0).getPoints().hitTest(point, d2, hitResult);
    }

    public boolean isBox() {
        return this.getWidth() > 0.0 && this.getHeight() > 0.0;
    }

    public boolean isNothing() {
        return this.getWidth() < 0.0 || this.getHeight() < 0.0;
    }

    public boolean isLine() {
        if (this.isPoint()) {
            return false;
        }
        return this.getWidth() == 0.0 || this.getHeight() == 0.0;
    }

    public boolean isPoint() {
        return this.getWidth() == 0.0 && this.getHeight() == 0.0;
    }

    public Envelope calcIntersection(Envelope envelope) {
        double d2 = this.getXMin();
        double d3 = this.getYMin();
        double d4 = this.getXMax();
        double d5 = this.getYMax();
        double d6 = envelope.getXMin();
        double d7 = envelope.getYMin();
        double d8 = envelope.getXMax();
        double d9 = envelope.getYMax();
        if (d8 < d2 || d6 > d4) {
            return a;
        }
        if (d9 < d3 || d7 > d5) {
            return a;
        }
        double d10 = d6 <= d2 ? d2 : d6;
        double d11 = d8 >= d4 ? d4 : d8;
        double d12 = d7 <= d3 ? d3 : d7;
        double d13 = d9 >= d5 ? d5 : d9;
        return new Envelope(d10, d12, d11 - d10, d13 - d12);
    }

    public boolean clem_overlapEnvelope(Envelope envelope) {
        if (FloatingPointCompare.gt(this.getXMax(), envelope.x) && FloatingPointCompare.gt(this.getYMax(), envelope.y) && FloatingPointCompare.gt(envelope.getXMax(), this.x) && FloatingPointCompare.gt(envelope.getYMax(), this.y)) {
            if (this.clem_containEnvelope(envelope)) {
                return false;
            }
            return !envelope.clem_containEnvelope(this);
        }
        return false;
    }

    public boolean clem_overlapPolygon(Polygon polygon) {
        return polygon.clem_overlapEnvelope(this);
    }

    public boolean clem_overlapPolygonBoundary(Polygon polygon) {
        return false;
    }

    public boolean clem_overlapPolyline(Polyline polyline) {
        return false;
    }

    public boolean clem_overlapMultiPoint(MultiPoint multiPoint) {
        return false;
    }

    public boolean clem_overlap(ClementiniGeometry clementiniGeometry) {
        return clementiniGeometry.clem_overlapEnvelope(this);
    }

    public boolean clem_insideEnvelope(Envelope envelope) {
        return envelope.clem_containEnvelope(this);
    }

    public boolean clem_insidePolygonBoundary(Polygon polygon) {
        return false;
    }

    public boolean clem_insidePolygon(Polygon polygon) {
        return polygon.clem_containEnvelope(this);
    }

    public boolean clem_insidePolyline(Polyline polyline) {
        return false;
    }

    public boolean clem_insideMultiPoint(MultiPoint multiPoint) {
        return false;
    }

    public boolean clem_inside(ClementiniGeometry clementiniGeometry) {
        return clementiniGeometry.clem_containEnvelope(this);
    }

    public boolean entirelyContainEnvelope(Envelope envelope) {
        return RelativeCompare.lt(this.getXMin(), envelope.getXMin()) && RelativeCompare.lt(this.getYMin(), envelope.getYMin()) && RelativeCompare.gt(this.getXMax(), envelope.getXMax()) && RelativeCompare.gt(this.getYMax(), envelope.getYMax());
    }

    public boolean clem_containEnvelope(Envelope envelope) {
        return RelativeCompare.le(this.getXMin(), envelope.getXMin()) && RelativeCompare.le(this.getYMin(), envelope.getYMin()) && RelativeCompare.ge(this.getXMax(), envelope.getXMax()) && RelativeCompare.ge(this.getYMax(), envelope.getYMax());
    }

    public boolean clem_containPolygon(Polygon polygon) {
        return polygon.clem_insideEnvelope(this);
    }

    public boolean clem_containPolygonBoundary(Polygon polygon) {
        return polygon.clem_insideEnvelope(this);
    }

    public boolean clem_containPolyline(Polyline polyline) {
        return polyline.clem_insideEnvelope(this);
    }

    public boolean clem_containMultiPoint(MultiPoint multiPoint) {
        return multiPoint.clem_insideEnvelope(this);
    }

    public boolean clem_containPoint(double d2, double d3) {
        return RelativeCompare.lt(this.x, d2) && RelativeCompare.lt(this.y, d3) && RelativeCompare.gt(this.x + this.width, d2) && RelativeCompare.gt(this.y + this.height, d3);
    }

    public boolean clem_containPoint(Point point) {
        return this.clem_containPoint(point.x, point.y);
    }

    public boolean clem_contain(ClementiniGeometry clementiniGeometry) {
        return clementiniGeometry.clem_insideEnvelope(this);
    }

    private boolean a(Envelope envelope) {
        return FloatingPointCompare.eq(this.getXMax(), envelope.getXMin()) || FloatingPointCompare.eq(this.getYMax(), envelope.getYMin()) || FloatingPointCompare.eq(this.getXMin(), envelope.getXMax()) || FloatingPointCompare.eq(this.getYMin(), envelope.getYMax());
    }

    public boolean clem_crossEnvelope(Envelope envelope) {
        return false;
    }

    public boolean clem_crossPolygon(Polygon polygon) {
        return false;
    }

    public boolean clem_crossPolygonBoundary(Polygon polygon) {
        return this.clem_relatePolygonBoundary(polygon) == 3;
    }

    public boolean clem_crossPolyline(Polyline polyline) {
        return this.clem_relatePolyline(polyline) == 3;
    }

    public boolean clem_crossMultiPoint(MultiPoint multiPoint) {
        return multiPoint.clem_crossEnvelope(this);
    }

    public boolean clem_cross(ClementiniGeometry clementiniGeometry) {
        return clementiniGeometry.clem_crossEnvelope(this);
    }

    public boolean clem_touchEnvelope(Envelope envelope) {
        if (this.clem_disjointEnvelope(envelope)) {
            return false;
        }
        return this.a(envelope);
    }

    public boolean clem_touchPolygon(Polygon polygon) {
        return polygon.clem_touchEnvelope(this);
    }

    public boolean clem_touchPoint(double d2, double d3) {
        return !this.clem_disjointPoint(d2, d3) && (FloatingPointCompare.eq(d2, this.x) || FloatingPointCompare.eq(d3, this.y) || FloatingPointCompare.eq(d2, this.x + this.width) || FloatingPointCompare.eq(d3, this.y + this.height));
    }

    /*
     * Unable to fully structure code
     */
    public boolean clem_touchPolygonBoundary(Polygon var1_1) {
        var7_2 = -1;
        var2_3 = false;
        if (this.clem_disjointEnvelope(var1_1.getEnvelopeByRef())) {
            return false;
        }
        if (this.clem_containEnvelope(var1_1.getEnvelopeByRef())) {
            return false;
        }
        var4_4 = this.getRing(0);
        var5_5 = var1_1.getRings();
        var6_6 = 0;
        {
            switch (var7_2) {
                case 1: {
                    continue block11;
                }
                while (true) {
                    if (!var5_5[var6_6].getEnvelopeByRef().clem_disjointEnvelope(this)) {
                        var3_7 = var4_4.clem_relateRingBoundary(var5_5[var6_6]);
                        switch (var3_7) {
                            case 3: {
                                return false;
                            }
                            case 2: {
                                break;
                            }
                            case 1: {
                                var2_3 = true;
                            }
                        }
                    }
                    ++var6_6;
                    case 0: {
                        var7_2 = -1;
                    }
                    break;
                }
            }
        }
        if (var6_6 < var5_5.length) ** continue;
        return var2_3;
    }

    public boolean clem_touchPolyline(Polyline polyline) {
        return this.clem_relatePolyline(polyline) == 1;
    }

    public boolean clem_touchMultiPoint(MultiPoint multiPoint) {
        return multiPoint.clem_touchEnvelope(this);
    }

    public boolean clem_onBoundary(double d2, double d3) {
        return FloatingPointCompare.eq(this.x, d2) ? FloatingPointCompare.ge(d3, this.y) && FloatingPointCompare.le(d3, this.y + this.height) : (FloatingPointCompare.eq(this.x + this.width, d2) ? FloatingPointCompare.ge(d3, this.y) && FloatingPointCompare.le(d3, this.y) : (FloatingPointCompare.eq(this.y, d3) ? d2 > this.x && d2 < this.x + this.width : FloatingPointCompare.eq(this.y + this.height, d3) && d2 > this.x && d2 < this.x + this.width));
    }

    public boolean clem_touch(ClementiniGeometry clementiniGeometry) {
        return clementiniGeometry.clem_touchEnvelope(this);
    }

    public boolean clem_disjointEnvelope(Envelope envelope) {
        return RelativeCompare.lt(this.getXMax(), envelope.getXMin()) || RelativeCompare.gt(this.getXMin(), envelope.getXMax()) || RelativeCompare.lt(this.getYMax(), envelope.getYMin()) || RelativeCompare.gt(this.getYMin(), envelope.getYMax());
    }

    public boolean clem_disjointPolygon(Polygon polygon) {
        return polygon.clem_disjointEnvelope(this);
    }

    public boolean clem_disjointPolygonBoundary(Polygon polygon) {
        return this.a(polygon.getRings(), polygon.getEnvelopeByRef());
    }

    public boolean clem_disjointPolyline(Polyline polyline) {
        return this.a(polyline.getPaths(), polyline.getEnvelopeByRef());
    }

    /*
     * Unable to fully structure code
     */
    private boolean a(Path[] var1_1, Envelope var2_2) {
        var13_3 = -1;
        if (this.clem_disjointEnvelope(var2_2)) {
            return true;
        }
        var3_4 = this.getXMin();
        var5_5 = this.getYMin();
        var7_6 = this.getXMax();
        var9_7 = this.getYMax();
        var12_8 = 0;
        {
            switch (var13_3) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    if (!var1_1[var12_8].getEnvelopeByRef().clem_disjointEnvelope(this)) {
                        if (!this.entirelyContainEnvelope(var1_1[var12_8].getEnvelopeByRef())) {
                            if (var1_1[var12_8].intersectsLine(var3_4, var5_5, var3_4, var9_7) || var1_1[var12_8].intersectsLine(var3_4, var9_7, var7_6, var9_7) || var1_1[var12_8].intersectsLine(var7_6, var9_7, var7_6, var5_5) || var1_1[var12_8].intersectsLine(var7_6, var5_5, var3_4, var5_5)) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                    }
                    ++var12_8;
                    case 0: {
                        var13_3 = -1;
                    }
                    break;
                }
            }
        }
        if (var12_8 < var1_1.length) ** continue;
        return true;
    }

    public boolean clem_disjointMultiPoint(MultiPoint multiPoint) {
        return multiPoint.clem_disjointEnvelope(this);
    }

    public boolean clem_disjointPoint(double d2, double d3) {
        return FloatingPointCompare.lt(d2, this.x) || FloatingPointCompare.gt(d2, this.x + this.width) || FloatingPointCompare.lt(d3, this.y) || FloatingPointCompare.gt(d3, this.y + this.height);
    }

    public boolean clem_disjointPoint(Point point) {
        return this.clem_disjointPoint(point.x, point.y);
    }

    public boolean clem_disjoint(ClementiniGeometry clementiniGeometry) {
        return clementiniGeometry.clem_disjointEnvelope(this);
    }

    public void translate(double d2, double d3) {
        this.x += d2;
        this.y += d3;
        return;
    }

    public int clem_relatePolyline(Polyline polyline) {
        if (this.getEnvelopeByRef().clem_disjointEnvelope(polyline.getEnvelopeByRef())) {
            return 2;
        }
        return this.a(polyline.getPaths());
    }

    public int clem_relateMultiPoint(MultiPoint multiPoint) {
        return Clementini.inverseRelate(multiPoint.clem_relateEnvelope(this));
    }

    public int clem_relateEnvelope(Envelope envelope) {
        if (this.clem_disjointEnvelope(envelope)) {
            return 2;
        }
        if (this.a(envelope)) {
            return 1;
        }
        if (this.clem_containEnvelope(envelope)) {
            if (envelope.clem_containEnvelope(this)) {
                return 5;
            }
            return 6;
        }
        if (envelope.clem_containEnvelope(this)) {
            return 0;
        }
        return 4;
    }

    public int clem_relatePolygonBoundary(Polygon polygon) {
        if (this.getEnvelopeByRef().clem_disjointEnvelope(polygon.getEnvelopeByRef())) {
            return 2;
        }
        return this.a(polygon.getRings());
    }

    /*
     * Unable to fully structure code
     */
    private int a(Path[] var1_1) {
        var7_2 = -1;
        var2_3 = false;
        var3_4 = false;
        var4_5 = false;
        var5_6 = false;
        var6_7 = 0;
        {
            switch (var7_2) {
                case 1: {
                    continue block15;
                }
                while (true) {
                    switch (this.a(var1_1[var6_7])) {
                        case 3: {
                            return 3;
                        }
                        case 1: {
                            var3_4 = true;
                            var4_5 = true;
                            break;
                        }
                        case 34: {
                            var4_5 = true;
                            break;
                        }
                        case 0: {
                            var2_3 = true;
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            var5_6 = true;
                            break;
                        }
                        case 6: {
                            var2_3 = true;
                            break;
                        }
                        default: {
                            var3_4 = true;
                        }
                    }
                    ++var6_7;
                    case 0: {
                        var7_2 = -1;
                    }
                    break;
                }
            }
        }
        if (var6_7 < var1_1.length) ** continue;
        if (var3_4) {
            if (var2_3) {
                return 3;
            }
            if (var4_5 || var5_6) {
                return 1;
            }
        } else {
            if (var2_3) {
                return 6;
            }
            if (var4_5 || var5_6) {
                return 1;
            }
        }
        return 2;
    }

    /*
     * Unable to fully structure code
     */
    private int a(Path var1_1) {
        var10_2 = -1;
        if (this.getEnvelopeByRef().clem_disjointEnvelope(var1_1.getEnvelopeByRef())) {
            return 2;
        }
        if (this.entirelyContainEnvelope(var1_1.getEnvelopeByRef())) {
            return 6;
        }
        var2_3 = false;
        var3_4 = false;
        var4_5 = false;
        var5_6 = var1_1.getPoints().getXByRef();
        var6_7 = var1_1.getPoints().getYByRef();
        var7_8 = 0;
        {
            switch (var10_2) {
                case 1: {
                    continue block20;
                }
                while (true) {
                    switch (this.clem_relatePoint(var5_6[var7_8], var6_7[var7_8])) {
                        case 6: {
                            var2_3 = true;
                            break;
                        }
                        case 1: {
                            var3_4 = true;
                            break;
                        }
                        case 2: {
                            var4_5 = true;
                            break;
                        }
                    }
                    ++var7_8;
                    case 0: {
                        var10_2 = -1;
                    }
                    break;
                }
            }
        }
        if (var7_8 < var5_6.length) ** continue;
        if (var2_3 && var4_5) {
            return 3;
        }
        var9_9 = this.getRing(0);
        var8_10 = var1_1 instanceof Ring != false ? var9_9.clem_relateRingBoundary((Ring)var1_1) : var9_9.pathRelatePath(var1_1);
        switch (var8_10) {
            case 2: {
                if (var4_5) {
                    return 2;
                }
                return 6;
            }
            case 1: {
                if (var2_3) {
                    return 6;
                }
                if (this.clem_containEnvelope(var1_1.getEnvelopeByRef())) {
                    return 6;
                }
                return 1;
            }
            case 3: {
                return 3;
            }
            case 6: {
                return 34;
            }
            case 5: {
                return 6;
            }
            case 0: {
                return 1;
            }
            case 4: {
                if (var2_3) {
                    return 6;
                }
                return 1;
            }
        }
        return 2;
    }

    public int clem_relatePolygon(Polygon polygon) {
        if (polygon instanceof Envelope) {
            return this.clem_relateEnvelope((Envelope)polygon);
        }
        return Clementini.inverseRelate(polygon.clem_relateEnvelope(this));
    }

    public int clem_relate(ClementiniGeometry clementiniGeometry) {
        return Clementini.inverseRelate(clementiniGeometry.clem_relateEnvelope(this));
    }

    public int clem_relatePoint(double d2, double d3) {
        if (this.clem_disjointPoint(d2, d3)) {
            return 2;
        }
        if (FloatingPointCompare.eq(d2, this.x) || FloatingPointCompare.eq(d3, this.y) || FloatingPointCompare.eq(d2, this.x + this.width) || FloatingPointCompare.eq(d3, this.y + this.height)) {
            return 1;
        }
        return 6;
    }

    public int clem_relatePoint(Point point) {
        return this.clem_relatePoint(point.x, point.y);
    }

    public Polygon buffer(double d2, double d3) {
        double d4 = this.x + this.width;
        double d5 = this.y + this.height;
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        dArray[0] = dArray[4] = this.x;
        dArray2[0] = dArray2[4] = this.y;
        dArray[3] = d4;
        dArray2[3] = this.y;
        dArray[2] = d4;
        dArray2[2] = d5;
        dArray[1] = this.x;
        dArray2[1] = d5;
        BasePointsArray basePointsArray = new BasePointsArray(dArray, dArray2);
        PointCollection pointCollection = h.a(basePointsArray, d2, d3);
        return new BasePolygon(new BaseRing(pointCollection));
    }

    public Ring[] getInteriorRings(Ring ring) {
        return null;
    }

    public Ring[] getExteriorRings() {
        Ring[] ringArray = new Ring[]{this.getRing(0)};
        return ringArray;
    }

    public Ring getRing(int n2) {
        if (n2 == 0) {
            double[] dArray = new double[5];
            double[] dArray2 = new double[5];
            dArray[0] = this.x;
            dArray2[0] = this.y;
            dArray[1] = this.x;
            dArray2[1] = this.y + this.height;
            dArray[2] = this.x + this.width;
            dArray2[2] = dArray2[1];
            dArray[3] = dArray[2];
            dArray2[3] = this.y;
            dArray[4] = this.x;
            dArray2[4] = this.y;
            return new BaseRing(new BasePointsArray(dArray, dArray2));
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void apply(PointApplicator pointApplicator) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[9];
        dArray[0] = this.x;
        dArray2[0] = this.y;
        dArray[1] = this.x;
        dArray2[1] = this.y + this.height;
        dArray[2] = this.x + this.width;
        dArray2[2] = dArray2[1];
        dArray[3] = dArray[2];
        dArray2[3] = this.y;
        dArray[4] = this.x;
        dArray2[4] = this.y + this.height / 2.0;
        dArray[5] = this.x + this.width / 2.0;
        dArray2[5] = this.y + this.height / 2.0;
        dArray[6] = this.x + this.width / 2.0;
        dArray2[6] = this.y;
        dArray[7] = this.x + this.width / 2.0;
        dArray2[7] = this.y + this.height;
        dArray[8] = this.x + this.width;
        dArray2[8] = this.y + this.height / 2.0;
        pointApplicator.apply(dArray, dArray2);
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = -1.7976931348623157E308;
        int n2 = 0;
        while (n2 < 9) {
            if (Math.abs(dArray[n2]) < 1.0E20) {
                if (dArray[n2] < d2) {
                    d2 = dArray[n2];
                }
                if (dArray[n2] > d4) {
                    d4 = dArray[n2];
                }
                if (dArray2[n2] < d3) {
                    d3 = dArray2[n2];
                }
                if (dArray2[n2] > d5) {
                    d5 = dArray2[n2];
                }
            }
            ++n2;
        }
        this.x = d2;
        this.y = d3;
        this.width = d4 - d2;
        this.height = d5 - d3;
        return;
    }

    public double distanceSqToPolyline(Polyline polyline) {
        return polyline.distanceSqToEnvelope(this);
    }

    public double distanceSqToPolygon(Polygon polygon) {
        return polygon.distanceSqToEnvelope(this);
    }

    public double distanceSqToMultiPoint(MultiPoint multiPoint) {
        return multiPoint.distanceSqToEnvelope(this);
    }

    public double distanceSqToEnvelope(Envelope envelope) {
        double d2 = this.getXMin();
        double d3 = this.getYMin();
        double d4 = this.getXMax();
        double d5 = this.getYMax();
        double d6 = envelope.getXMin();
        double d7 = envelope.getYMin();
        double d8 = envelope.getXMax();
        double d9 = envelope.getYMax();
        if (d4 < d6) {
            if (d5 < d7) {
                return Point2D.distanceSq(d4, d5, d6, d7);
            }
            if (d3 > d9) {
                return Point2D.distanceSq(d4, d3, d6, d9);
            }
            double d10 = d6 - d4;
            return d10 * d10;
        }
        if (d2 > d8) {
            if (d9 < d3) {
                return Point2D.distanceSq(d8, d9, d2, d3);
            }
            if (d7 > d5) {
                return Point2D.distanceSq(d8, d7, d2, d5);
            }
            double d11 = d2 - d8;
            return d11 * d11;
        }
        if (d5 < d7) {
            double d12 = d7 - d5;
            return d12 * d12;
        }
        if (d3 > d9) {
            double d13 = d3 - d9;
            return d13 * d13;
        }
        return 0.0;
    }

    public double distanceSqTo(FeatureGeometry featureGeometry) {
        return featureGeometry.distanceSqToEnvelope(this);
    }

    public double distanceSqToPoint(double d2, double d3) {
        double d4 = this.getXMin();
        double d5 = this.getYMin();
        double d6 = this.getXMax();
        double d7 = this.getYMax();
        if (d2 < d4) {
            if (d3 < d5) {
                return Point2D.distanceSq(d4, d5, d2, d3);
            }
            if (d3 > d7) {
                return Point2D.distanceSq(d4, d7, d2, d3);
            }
            double d8 = d4 - d2;
            return d8 * d8;
        }
        if (d2 > d6) {
            if (d3 < d5) {
                return Point2D.distanceSq(d6, d5, d2, d3);
            }
            if (d3 > d7) {
                return Point2D.distanceSq(d6, d7, d2, d3);
            }
            double d9 = d6 - d2;
            return d9 * d9;
        }
        if (d3 < d5) {
            double d10 = d5 - d3;
            return d10 * d10;
        }
        if (d3 > d7) {
            double d11 = d3 - d7;
            return d11 * d11;
        }
        return 0.0;
    }

    public Geometry getGeometry(int n2) throws ArrayIndexOutOfBoundsException {
        return this.getRing(n2);
    }

    public int size() {
        return 1;
    }

    public final boolean contains(double d2, double d3) {
        return this.getXMin() < d2 && d2 < this.getXMax() && this.getYMin() < d3 && d3 < this.getYMax();
    }

    public final double getYMax() {
        return this.y + this.height;
    }

    public final double getYMin() {
        return this.y;
    }

    public final double getXMax() {
        return this.x + this.width;
    }

    public final double getXMin() {
        return this.x;
    }

    public double getInsidePerimeter() {
        return 0.0;
    }

    public double getOutsidePerimeter() {
        return 2.0 * this.getWidth() + 2.0 * this.getHeight();
    }

    public double getArea() {
        return this.width * this.height;
    }

    public void grow(double d2) {
        double d3 = this.x + this.width * 0.5;
        double d4 = this.y + this.height * 0.5;
        if (d2 <= 0.0) {
            return;
        }
        this.width *= d2;
        this.height *= d2;
        this.x = d3 - this.width * 0.5;
        this.y = d4 - this.height * 0.5;
        return;
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(6);
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumIntegerDigits(20);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setGroupingUsed(false);
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(numberFormat.format(this.x));
        stringBuffer.append(",");
        stringBuffer.append(numberFormat.format(this.y));
        stringBuffer.append(" ");
        stringBuffer.append(numberFormat.format(this.x + this.width));
        stringBuffer.append(",");
        stringBuffer.append(numberFormat.format(this.y + this.height));
        return stringBuffer.toString();
    }

    public Object clone() {
        return new Envelope(this.x, this.y, this.width, this.height);
    }

    public Ring[] getRings() {
        return this.getExteriorRings();
    }

    public Rectangle toRectangle() {
        return new Rectangle((int)Math.round(this.x), (int)Math.round(this.y), (int)Math.round(this.width), (int)Math.round(this.height));
    }

    public boolean clipLine(double d2, double d3, double d4, double d5, int n2, Point point) {
        double d6;
        double d7;
        double d8 = this.x + this.width;
        double d9 = this.y + this.height;
        double d10 = d4 - d2;
        double d11 = d5 - d3;
        if (Math.abs(d10) < 1.0E-12 && Math.abs(d11) < 1.0E-12) {
            return false;
        }
        if ((n2 & 8) != 0) {
            d7 = d2 + d10 * (d9 - d3) / d11;
            d6 = d9;
            if (d7 > d8 || d7 < this.x) {
                return this.clipLine(d7, d6, d4, d5, n2 & 7, point);
            }
        } else if ((n2 & 2) != 0) {
            d7 = d2 + d10 * (this.y - d3) / d11;
            d6 = this.y;
            if (d7 > d8 || d7 < this.x) {
                return this.clipLine(d7, d6, d4, d5, n2 & 0xD, point);
            }
        } else if ((n2 & 4) != 0) {
            d6 = d3 + d11 * (d8 - d2) / d10;
            d7 = d8;
            if (d6 > d9 || d6 < this.y) {
                return this.clipLine(d7, d6, d4, d5, n2 & 0xB, point);
            }
        } else if ((n2 & 1) != 0) {
            d6 = d3 + d11 * (this.x - d2) / d10;
            d7 = this.x;
            if (d6 > d9 || d6 < this.y) {
                return this.clipLine(d7, d6, d4, d5, n2 & 0xE, point);
            }
        } else {
            return false;
        }
        point.x = d7;
        point.y = d6;
        return true;
    }

    public Envelope getEnvelope(Envelope envelope) {
        if (envelope == null) {
            envelope = new Envelope();
        }
        envelope.x = this.x;
        envelope.y = this.y;
        envelope.width = this.width;
        envelope.height = this.height;
        return envelope;
    }

    public Envelope getEnvelopeByRef() {
        return this;
    }

    public Envelope getEnvelope() {
        return this.getEnvelope(null);
    }

    public Envelope(Rectangle rectangle) {
        super(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Envelope(Envelope envelope) {
        super(envelope.x, envelope.y, envelope.getWidth(), envelope.getHeight());
    }

    public Envelope(double d2, double d3, double d4, double d5) {
        super(d2, d3, d4, d5);
    }

    public Envelope() {
    }
}

