/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geom;

import com.esri.mo.cs.geom.Point;
import com.esri.mo.cs.geom.UnitVector2D;
import com.esri.mo.cs.geom.Vector2D;
import com.esri.mo.util.FloatingPointCompare;

public final class Cogo {
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_180 = Math.PI / 180;
    public static final double TWO_PI = Math.PI * 2;

    public static final double signum(double d2) {
        return d2 < 0.0 ? -1.0 : (d2 > 0.0 ? 1.0 : 0.0);
    }

    public static final boolean equal(double d2, double d3, double d4, double d5) {
        return FloatingPointCompare.eq(d2, d4) && FloatingPointCompare.eq(d3, d5);
    }

    public static final boolean equal(Point point, Point point2) {
        return FloatingPointCompare.eq(point.x, point2.x) && FloatingPointCompare.eq(point.y, point2.y);
    }

    public static final double offset(Point point, UnitVector2D unitVector2D, Point point2) {
        double d2 = point2.x - point.x;
        double d3 = point2.y - point.y;
        return -unitVector2D.cross(d2, d3);
    }

    public static final double station(Point point, UnitVector2D unitVector2D, Point point2) {
        double d2 = point2.x - point.x;
        double d3 = point2.y - point.y;
        return unitVector2D.dot(d2, d3);
    }

    public static final double station(Point point, Point point2, Point point3) {
        double d2 = point3.x - point.x;
        double d3 = point3.y - point.y;
        double d4 = point2.x - point.x;
        double d5 = point2.y - point.y;
        double d6 = d4 * d4 + d5 * d5;
        if (d6 < 1.0E-40) {
            return 0.0;
        }
        d6 = Math.sqrt(d6);
        return Vector2D.dot(d4, d5, d2, d3) / d6;
    }

    public static final void locateOffsetPoint(Point point, UnitVector2D unitVector2D, double d2, Point point2) {
        point2.x = point.x + unitVector2D.y * d2;
        point2.y = point.y - unitVector2D.x * d2;
        return;
    }

    public static final void locatePoint(Point point, UnitVector2D unitVector2D, double d2, double d3, Point point2) {
        point2.x = point.x + unitVector2D.x * d2 + unitVector2D.y * d3;
        point2.y = point.y + unitVector2D.y * d2 - unitVector2D.x * d3;
        return;
    }

    public static final int arcArc(Point point, double d2, Point point2, double d3, Point[] pointArray) {
        double d4 = Math.abs(d2);
        double d5 = Math.abs(d3);
        double d6 = point.distance(point2);
        if (FloatingPointCompare.eq(d6, 0.0)) {
            return 0;
        }
        double d7 = d4 + d5 - d6;
        if (FloatingPointCompare.lt(d7, 0.0)) {
            return 0;
        }
        double d8 = d6 - Math.abs(d4 - d5);
        if (FloatingPointCompare.lt(d8, 0.0)) {
            return 0;
        }
        double d9 = d6 * 2.0;
        double d10 = d4 * d4 / d9;
        double d11 = d5 * d5 / d9;
        double d12 = d10 - d11 + d6 * 0.5;
        double d13 = Math.sqrt((d4 - d12) * (d4 + d12));
        UnitVector2D unitVector2D = new UnitVector2D(point, point2);
        Cogo.locatePoint(point, unitVector2D, d12, d13, pointArray[0]);
        if (FloatingPointCompare.gt(d7, 0.0) && FloatingPointCompare.gt(d8, 0.0)) {
            Cogo.locatePoint(point, unitVector2D, d12, -d13, pointArray[1]);
            return 2;
        }
        return 1;
    }

    public static final int lineLine(Point point, Point point2, Point point3, Point point4, Point point5) {
        double d2 = point3.x - point.x;
        double d3 = point3.y - point.y;
        double d4 = point2.x - point.x;
        double d5 = point2.y - point.y;
        double d6 = point4.x - point3.x;
        double d7 = point4.y - point3.y;
        double d8 = d5 * d6 - d4 * d7;
        if (FloatingPointCompare.eq(d8, 0.0)) {
            return 0;
        }
        double d9 = (d6 * d3 - d2 * d7) / d8;
        point5.x = point.x + d4 * d9;
        point5.y = point.y + d5 * d9;
        return 1;
    }

    public static final int arcLine(Point point, double d2, Point point2, UnitVector2D unitVector2D, double d3, Point[] pointArray) {
        double d4 = Math.abs(d2);
        double d5 = Cogo.station(point2, unitVector2D, point);
        double d6 = Cogo.offset(point2, unitVector2D, point);
        double d7 = Math.abs(d6 -= d3) - d4;
        if (FloatingPointCompare.eq(d7, 0.0)) {
            Cogo.locatePoint(point2, unitVector2D, d5, d3, pointArray[0]);
            return 1;
        }
        if (d7 < 0.0) {
            double d8 = Math.sqrt(Math.abs((d4 - d6) * (d4 + d6)));
            Cogo.locatePoint(point2, unitVector2D, d5 + d8, d3, pointArray[0]);
            Cogo.locatePoint(point2, unitVector2D, d5 - d8, d3, pointArray[1]);
            return 2;
        }
        return 0;
    }

    public static final double rightOf(Point point, Point point2, Point point3) {
        double d2 = point2.x - point.x;
        double d3 = point2.y - point.y;
        double d4 = point3.x - point.x;
        double d5 = point3.y - point.y;
        return d3 * d4 - d2 * d5;
    }

    public static final double azimuth(double d2, double d3) {
        return Cogo.angle(d3, d2);
    }

    public static final double azimuth(Point point, Point point2) {
        return Cogo.angle(point2.y - point.y, point2.x - point.x);
    }

    public static final double angle(Point point, Point point2) {
        return Cogo.angle(point2.x - point.x, point2.y - point.y);
    }

    public static final double angle(double d2, double d3) {
        double d4;
        if (d2 == 0.0 && d3 == 0.0) {
            d4 = 0.0;
        } else {
            d4 = Math.atan2(d3, d2);
            if (d4 < 0.0) {
                d4 += Math.PI * 2;
            }
        }
        return d4;
    }

    public static final double clockwiseAngle(Point point, Point point2, Point point3) {
        double d2 = Cogo.angle(point2, point);
        double d3 = Cogo.angle(point2, point3);
        d2 = Cogo.angle180(d2);
        d3 = Cogo.angle180(d3);
        return Cogo.angle360(d2 - d3);
    }

    public static final double angle180(double d2) {
        double d3 = Cogo.angle360(d2);
        if (d3 > Math.PI) {
            d3 -= Math.PI * 2;
        }
        return d3;
    }

    public static final double angle360(double d2) {
        double d3 = Math.IEEEremainder(d2, Math.PI * 2);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    private Cogo() {
    }
}

