/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class WinkelTripel
extends GenericProjection {
    private double e;
    private double d;
    private double c;
    private double a;
    private double b;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        try {
            double d2 = point3D.x - this.c;
            if (d2 > 3.141592653589893) {
                d2 -= Math.PI * 2;
            }
            if (d2 < -3.141592653589893) {
                d2 += Math.PI * 2;
            }
            double d3 = 0.5 * d2;
            double d4 = Math.sin(d3);
            if (Utilities.angleIsZero(Math.abs(point3D.y) - 1.5707963267948966)) {
                point3D.x = 0.5 * this._ellipsoid.getRadius() * this.e * d3;
                point3D.y = this._ellipsoid.getRadius() * point3D.y;
            } else {
                double d5 = Math.tan(point3D.y);
                double d6 = Math.sqrt(d4 * d4 + d5 * d5);
                if (Math.abs(d6) < 1.0E-12) {
                    point3D.x = 0.0;
                    point3D.y = 0.0;
                } else {
                    double d7 = Math.acos(Math.cos(point3D.y) * Math.cos(d3));
                    point3D.x = 0.5 * this._ellipsoid.getRadius() * (this.e * d3 + 2.0 * d7 * d4 / d6);
                    point3D.y = 0.5 * this._ellipsoid.getRadius() * (point3D.y + d7 * d5 / d6);
                }
            }
            point3D.x += this.b;
            point3D.y += this.a;
        }
        catch (Exception exception) {
            throw new CalculationException();
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        try {
            double d2;
            double d3;
            double d4 = point3D.x;
            double d5 = point3D.y;
            double d6 = d4 / (this.e * this._ellipsoid.getRadius());
            double d7 = d5 / this._ellipsoid.getRadius();
            int n2 = 0;
            do {
                point3D.x = d6;
                point3D.y = d7;
                this.fromGeographic(point3D);
                d3 = d4 - point3D.x;
                d2 = d5 - point3D.y;
                d6 += d3 / (this.e * this._ellipsoid.getRadius());
                d7 += d2 / this._ellipsoid.getRadius();
            } while ((Math.abs(d3) > 1.0E-12 || Math.abs(d2) > 1.0E-12) && ++n2 < 50);
            point3D.x = d6;
            point3D.y = d7;
        }
        catch (Exception exception) {
            throw new CalculationException();
        }
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        this.e = Math.cos(this.d);
        return;
    }

    public WinkelTripel(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this.b = d4;
        this.a = d5;
        this.c = d2;
        this.d = d3;
        this._ellipsoid = ellipsoid;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new WinkelTripel(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        WinkelTripel winkelTripel = null;
        winkelTripel = (WinkelTripel)super.clone();
        winkelTripel.c = this.c;
        winkelTripel.d = this.d;
        winkelTripel.a = this.a;
        winkelTripel.b = this.b;
        try {
            winkelTripel.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return winkelTripel;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new WinkelTripel(unit, unit2, stringArray, n2, this.getSchema());
    }

    private void a() {
        this.c = (Double)this.getValues()[2];
        this.d = (Double)this.getValues()[3];
        this.b = (Double)this.getValues()[4];
        this.a = (Double)this.getValues()[5];
        return;
    }

    public WinkelTripel(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public WinkelTripel(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    WinkelTripel() {
    }
}

