/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.axl.client.csg3CatchImpl;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Winkel2
extends GenericProjection {
    private double d;
    private double c;
    private double a;
    private double b;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            Winkel2 winkel2 = new Winkel2(new Ellipsoid(1.0, 0.0), Utilities.decimalDegreesToRadians(-90.0), Utilities.decimalDegreesToRadians(-10.0), 0.0, 0.0);
            Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(-50.0), 0.0);
            winkel2.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            winkel2.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
            return;
        }
        catch (Exception exception) {
            // empty catch block
            return;
        }
        catch (csg3CatchImpl csg3CatchImpl2) {
            throw csg3CatchImpl2;
        }
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.longitude180(point3D.x - this.c);
        double d3 = 2.0 * point3D.y / Math.PI;
        d3 = Math.abs(d3) <= 1.0 ? d3 : (d3 > 0.0 ? 1.0 : -1.0);
        point3D.x = this.b + this._ellipsoid.getRadius() * d2 * (Math.sqrt(1.0 - d3 * d3) + Math.cos(this.d)) / 2.0;
        point3D.y = this.a + this._ellipsoid.getRadius() * point3D.y;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        point3D.y /= this._ellipsoid.getRadius();
        double d2 = 2.0 * point3D.y / Math.PI;
        d2 = Math.abs(d2) <= 1.0 ? d2 : (d2 > 0.0 ? 1.0 : -1.0);
        point3D.x = Utilities.longitude180(this.c + 2.0 * point3D.x / (this._ellipsoid.getRadius() * (Math.sqrt(1.0 - d2 * d2) + Math.cos(this.d))));
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public Winkel2(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d4;
        this.a = d5;
        this.c = d2;
        this.d = d3;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Winkel2(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Winkel2 winkel2 = null;
        winkel2 = (Winkel2)super.clone();
        winkel2.c = this.c;
        winkel2.d = this.d;
        winkel2.a = this.a;
        winkel2.b = this.b;
        try {
            winkel2.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return winkel2;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Winkel2(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.d);
        this.setValue(4, this.b);
        this.setValue(5, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.d = this.getValue(3);
        this.b = this.getValue(4);
        this.a = this.getValue(5);
        return;
    }

    public Winkel2(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Winkel2(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Winkel2() {
    }
}

