/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class VanDerGrinten1
extends GenericProjection {
    private double c;
    private double a;
    private double b;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        try {
            double d2 = Utilities.longitude180(point3D.x - this.c);
            double d3 = Math.abs(2.0 * point3D.y / Math.PI);
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            double d4 = Math.asin(d3);
            double d5 = Math.sin(d4);
            double d6 = Math.cos(d4);
            if (Utilities.angleIsZero(point3D.y)) {
                point3D.y = 0.0;
                point3D.x = this._ellipsoid.getRadius() * d2;
            } else if (Utilities.angleIsZero(d2) || Utilities.angleIsZero(Math.abs(point3D.y) - 1.5707963267948966)) {
                point3D.x = 0.0;
                point3D.y = Utilities.signum(point3D.y) * Math.abs(Math.PI * this._ellipsoid.getRadius() * Math.tan(d4 / 2.0));
            } else {
                double d7 = 0.5 * Math.abs(Math.PI / d2 - d2 / Math.PI);
                double d8 = d6 / (d5 + d6 - 1.0);
                double d9 = d7 * d7 + d8;
                double d10 = d8 * (2.0 / d5 - 1.0);
                double d11 = d10 * d10;
                double d12 = d7 * d7;
                double d13 = d11 + d12;
                double d14 = d8 - d11;
                double d15 = d9 * d9;
                point3D.x = Utilities.signum(d2) * Math.PI * this._ellipsoid.getRadius() * (d7 * d14 + Math.sqrt(d12 * d14 * d14 - d13 * (d8 * d8 - d11))) / d13;
                point3D.y = Utilities.signum(point3D.y) * Math.PI * this._ellipsoid.getRadius() * (d10 * d9 - d7 * Math.sqrt((d12 + 1.0) * d13 - d15)) / d13;
            }
            point3D.x += this.b;
            point3D.y += this.a;
        }
        catch (Exception exception) {
            throw new CalculationException();
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        try {
            point3D.y -= this.a;
            point3D.x -= this.b;
            double d2 = point3D.x / (Math.PI * this._ellipsoid.getRadius());
            double d3 = point3D.y / (Math.PI * this._ellipsoid.getRadius());
            double d4 = d2 * d2;
            double d5 = d3 * d3;
            double d6 = d4 + d5;
            double d7 = -Math.abs(d3) * (1.0 + d6);
            double d8 = d7 - 2.0 * d5 + d4;
            double d9 = -2.0 * d7 + 1.0 + 2.0 * d5 + d6 * d6;
            double d10 = d8 * d8;
            double d11 = d10 * d8;
            double d12 = d9 * d9;
            double d13 = d12 * d9;
            double d14 = d5 / d9 + (2.0 * d11 / d13 - 9.0 * d7 * d8 / d12) / 27.0;
            double d15 = (d7 - d10 / (3.0 * d9)) / d9;
            double d16 = 2.0 * Math.sqrt(-d15 / 3.0);
            double d17 = 0.3333333333333333 * Math.acos(3.0 * d14 / (d15 * d16));
            point3D.y = Utilities.signum(point3D.y) * Math.PI * (-d16 * Math.cos(d17 + 1.0471975511965976) - d8 / (3.0 * d9));
            point3D.x = Math.abs(d2) < 1.0E-10 ? this.c : this.c + Math.PI * (d6 - 1.0 + Math.sqrt(1.0 + 2.0 * (d4 - d5) + d6 * d6)) / (2.0 * d2);
        }
        catch (Exception exception) {
            throw new CalculationException();
        }
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public VanDerGrinten1(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d3;
        this.a = d4;
        this.c = d2;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new VanDerGrinten1(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        VanDerGrinten1 vanDerGrinten1 = null;
        vanDerGrinten1 = (VanDerGrinten1)super.clone();
        vanDerGrinten1.c = this.c;
        vanDerGrinten1.a = this.a;
        vanDerGrinten1.b = this.b;
        try {
            vanDerGrinten1.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return vanDerGrinten1;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new VanDerGrinten1(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.b);
        this.setValue(4, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.b = this.getValue(3);
        this.a = this.getValue(4);
        return;
    }

    public VanDerGrinten1(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public VanDerGrinten1(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    VanDerGrinten1() {
    }
}

