/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.axl.client.csg3ReflImpl;
import com.esri.mo.cs.geod.DegreesOutOfRangeException;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.LatitudeOutOfRangeException;
import com.esri.mo.cs.geod.LongitudeOutOfRangeException;
import com.esri.mo.cs.geod.MinutesOutOfRangeException;
import com.esri.mo.cs.geod.ReferencedCoordinateSystem;
import com.esri.mo.cs.geod.ReferencedCoordinateSystemImpl;
import com.esri.mo.cs.geod.ReferencedCoordinateTransformation;
import com.esri.mo.cs.geod.SecondsOutOfRangeException;
import com.esri.mo.cs.geom.Envelope;

public class Utilities {
    public static final double PI_PLUS_TINY = 3.141592653589893;
    public static final double PI_OVER_3 = 1.0471975511965976;
    public static final double PI_OVER_4 = 0.7853981633974483;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double DEGREE = Math.PI / 180;
    public static final double PI_OVER_180 = Math.PI / 180;
    public static final double TWO_PI = Math.PI * 2;
    public static final double EPSILON_ANGLE = 1.0E-13;
    public static final double SECONDS_TO_RADIANS = 4.84813681109536E-6;

    /*
     * Unable to fully structure code
     */
    public static final Envelope clipToHorizon(Envelope var0, ReferencedCoordinateSystem var1_1) {
        var10_2 = -1;
        var2_3 = new ReferencedCoordinateTransformation(ReferencedCoordinateSystemImpl.WGS84_IN_RADIANS, var1_1);
        var3_4 = new Envelope(-3.141592653589793, -1.5707963267948966, 6.283185307179586, 3.141592653589793);
        var4_5 = null;
        var5_6 = var1_1.getHorizon();
        var6_7 = 0;
        {
            switch (var10_2) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    var7_8 = (Envelope)var3_4.clone();
                    var8_9 = (Envelope)var5_6.clip(var7_8, var6_7);
                    if (var8_9 != null) {
                        if (var4_5 == null) {
                            var4_5 = (Envelope)var2_3.transform(var8_9);
                            if (var4_5 != null) {
                                var4_5 = (Envelope)var4_5.clip(var0);
                            }
                        } else {
                            var9_10 = (Envelope)var2_3.transform(var8_9);
                            if (var9_10 != null && (var9_10 = (Envelope)var9_10.clip(var0)) != null) {
                                var4_5.combineWith(var9_10);
                            }
                        }
                    }
                    ++var6_7;
                    case 0: {
                        var10_2 = -1;
                    }
                    break;
                }
            }
        }
        if (var6_7 < var5_6.size()) ** continue;
        var2_3.dispose();
        return var4_5;
    }

    public static final void validateLongitude(double d2) throws LongitudeOutOfRangeException {
        if (Math.abs(d2) > 3.141592653589893) {
            throw new LongitudeOutOfRangeException();
        }
        return;
    }

    public static final void validateLatitude(double d2) throws LatitudeOutOfRangeException {
        if (Math.abs(d2) > 1.5707963267949965) {
            throw new LatitudeOutOfRangeException();
        }
        return;
    }

    public static final double tanh(double d2) {
        double d3 = Math.exp(d2);
        return 0.5 * (d3 - 1.0 / d3) / (0.5 * (d3 + 1.0 / d3));
    }

    public static final double cosh(double d2) {
        double d3 = Math.exp(d2);
        return 0.5 * (d3 + 1.0 / d3);
    }

    public static final double sinh(double d2) {
        double d3 = Math.exp(d2);
        return 0.5 * (d3 - 1.0 / d3);
    }

    public static final int maximum(int n2, int n3) {
        return n2 > n3 ? n2 : n3;
    }

    public static final int minimum(int n2, int n3) {
        return n2 < n3 ? n2 : n3;
    }

    public static final double maximum(double d2, double d3) {
        return d2 > d3 ? d2 : d3;
    }

    public static final double minimum(double d2, double d3) {
        return d2 < d3 ? d2 : d3;
    }

    public static final double atan2(double d2, double d3) {
        double d4 = d3 * d3;
        if (d3 == 0.0 || d4 / (d4 + d2 * d2) < 1.0E-28) {
            return 1.5707963267948966 * Utilities.signum(d2);
        }
        return Math.atan2(d2, d3);
    }

    public static double cotan(double d2) {
        if (Utilities.angleIsZero(Math.abs(d2) - 1.5707963267948966)) {
            return 0.0;
        }
        if (Utilities.angleIsZero(d2)) {
            return 1.0E30;
        }
        return 1.0 / Math.tan(d2);
    }

    public static boolean angleIsHalfPi(double d2) {
        return Utilities.angleIsZero(d2 - 1.5707963267948966);
    }

    public static boolean angleIsZero(double d2) {
        return Math.abs(d2) < 1.0E-13;
    }

    public static double longitude180(double d2) {
        if (d2 > 3.141592653589893) {
            d2 -= Math.PI * 2;
        } else if (d2 < -3.141592653589893) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    public static double angle180(double d2) {
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        } else if (d2 < -Math.PI) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    public static double radiansToDecimalDegrees(double d2) {
        return d2 / (Math.PI / 180);
    }

    public static double decimalDegreesToRadians(double d2) {
        return d2 * (Math.PI / 180);
    }

    public static double radiansToDM(double d2) {
        double d3 = Math.abs(d2);
        double d4 = Utilities.radiansToDecimalDegrees(d3);
        double d5 = Math.floor(d4);
        double d6 = Math.floor((d4 - d5) * 60.0);
        double d7 = d5 + 0.01 * d6;
        return Utilities.signum(d2) * d7;
    }

    public static double DMToRadians(double d2) throws MinutesOutOfRangeException, DegreesOutOfRangeException {
        double d3 = Math.abs(d2);
        double d4 = Math.floor(d3);
        if (d4 >= 360.0) {
            throw new DegreesOutOfRangeException();
        }
        double d5 = (d3 - d4) * 100.0;
        if (d5 >= 60.0) {
            throw new MinutesOutOfRangeException();
        }
        double d6 = d4 + d5 / 60.0;
        return Utilities.signum(d2) * Utilities.decimalDegreesToRadians(d6);
    }

    public static double radiansToDMS(double d2) {
        double d3 = Math.abs(d2);
        double d4 = Utilities.radiansToDecimalDegrees(d3);
        double d5 = Math.floor(d4);
        double d6 = Math.floor((d4 - d5) * 60.0);
        double d7 = (d4 - d5 - d6 / 60.0) * 3600.0;
        if (d7 > 59.999999999) {
            d7 = 0.0;
            if ((d6 += 1.0) > 59.5) {
                d6 = 0.0;
                d5 += 1.0;
            }
        }
        double d8 = d5 + 0.01 * d6 + 1.0E-4 * d7;
        return Utilities.signum(d2) * d8;
    }

    public static double DMSToRadians(double d2) throws SecondsOutOfRangeException, MinutesOutOfRangeException, DegreesOutOfRangeException {
        double d3 = Math.abs(d2);
        double d4 = Math.floor(d3);
        if (d4 >= 360.0) {
            throw new DegreesOutOfRangeException();
        }
        double d5 = Math.floor((1.0E-13 + d3 - d4) * 100.0);
        double d6 = (d3 - d4 - d5 * 0.01) * 10000.0;
        if (d5 >= 60.0) {
            throw new MinutesOutOfRangeException();
        }
        if (d6 >= 60.0) {
            throw new SecondsOutOfRangeException();
        }
        double d7 = d4 + d5 / 60.0 + d6 / 3600.0;
        return Utilities.signum(d2) * Utilities.decimalDegreesToRadians(d7);
    }

    public static double signum(double d2) {
        return d2 < 0.0 ? -1.0 : 1.0;
    }

    public static Object getObject(String string) {
        String string2 = new String("com.esri.mo.cs.geod." + string);
        GeodeticObject geodeticObject = null;
        try {
            Class clazz = csg3ReflImpl.forName(string2);
            geodeticObject = (GeodeticObject)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        return geodeticObject;
    }
}

