/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.axl.client.csg3CatchImpl;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class TwoPointEquidistant
extends GenericProjection {
    private double h;
    private double a;
    private double k;
    private double d;
    private double l;
    private double e;
    private double i;
    private double f;
    private double j;
    private double g;
    private double b;
    private double c;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            TwoPointEquidistant twoPointEquidistant = new TwoPointEquidistant(new Ellipsoid(1.0, 0.0), Utilities.decimalDegreesToRadians(-90.0), Utilities.decimalDegreesToRadians(-10.0), Utilities.decimalDegreesToRadians(0.0), Utilities.decimalDegreesToRadians(10.0), 0.0, 0.0);
            Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(-50.0), 0.0);
            twoPointEquidistant.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            twoPointEquidistant.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
            return;
        }
        catch (Exception exception) {
            // empty catch block
            return;
        }
        catch (csg3CatchImpl csg3CatchImpl2) {
            throw csg3CatchImpl2;
        }
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = point3D.x;
        double d3 = point3D.y;
        double d4 = Math.sin(d3);
        double d5 = Math.cos(d3);
        double d6 = this.e * d4 + this.l * d5 * Math.cos(Utilities.longitude180(d2 - this.j));
        d6 = d6 > 1.0 ? 1.0 : (d6 < -1.0 ? -1.0 : d6);
        d6 = Math.acos(d6);
        double d7 = this.d * d4 + this.k * d5 * Math.cos(Utilities.longitude180(d2 - this.i));
        d7 = d7 > 1.0 ? 1.0 : (d7 < -1.0 ? -1.0 : d7);
        d7 = Math.acos(d7);
        double d8 = this.a;
        if (Utilities.angleIsZero(this.a)) {
            d8 = d8 >= 0.0 ? 1.0E-13 : -1.0E-13;
        }
        double d9 = this.l * this.k * d4 * Math.sin(Utilities.longitude180(this.i - this.j)) - this.l * this.d * d5 * Math.sin(Utilities.longitude180(d2 - this.j)) + this.e * this.k * d5 * Math.sin(Utilities.longitude180(d2 - this.i));
        double d10 = this._ellipsoid.getRadius();
        point3D.x = this.c + d10 * (d6 - d7) * (d6 + d7) / (2.0 * d8);
        point3D.y = this.b + Utilities.signum(d9) * d10 * Math.sqrt(Math.abs((-d8 + d6 - d7) * (-d8 - d6 + d7) * (-d8 + d6 + d7) * (d8 + d6 + d7))) / (2.0 * d8);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        double d2 = point3D.y - this.b;
        double d3 = point3D.x - this.c;
        double d4 = Utilities.longitude180(this.i - this.j);
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        double d7 = Math.tan(this.a / 2.0);
        double d8 = this._ellipsoid.getRadius();
        double d9 = Math.sqrt((d2 /= d8) * d2 + ((d3 /= d8) + this.a / 2.0) * (d3 + this.a / 2.0));
        double d10 = Math.sqrt(d2 * d2 + (d3 - this.a / 2.0) * (d3 - this.a / 2.0));
        double d11 = Math.cos(d9);
        double d12 = Math.cos(d10);
        double d13 = d11 + d12;
        double d14 = d11 - d12;
        double d15 = -Math.atan2(d14, d13 * d7);
        double d16 = Math.sqrt(d7 * d13 * (d7 * d13) + d14 * d14) / (2.0 * Math.sin(this.a / 2.0));
        d16 = d16 > 1.0 ? 1.0 : (d16 < -1.0 ? -1.0 : d16);
        d16 = d2 >= 0.0 ? Math.acos(d16) : -Math.acos(d16);
        double d17 = Math.atan2(this.k * d5, this.l * this.d - this.e * this.k * d6);
        double d18 = this.l * Math.sin(d17);
        d18 = d18 > 1.0 ? 1.0 : (d18 < -1.0 ? -1.0 : d18);
        d18 = Math.asin(d18);
        double d19 = this.e * this.d + this.l * this.k * d6;
        d19 = d19 > 1.0 ? 1.0 : (d19 < -1.0 ? -1.0 : d19);
        d19 = Math.acos(d19);
        d19 = Utilities.longitude180(Math.atan2(this.l * Math.cos(d17), this.e) - d19 / 2.0);
        double d20 = Math.sin(d16);
        double d21 = Math.cos(d16);
        d16 = Math.sin(d18) * d20 + Math.cos(d18) * d21 * Math.cos(d15 - d19);
        d16 = d16 > 1.0 ? 1.0 : (d16 < -1.0 ? -1.0 : d16);
        d16 = Math.asin(d16);
        d15 = Math.atan2(d21 * Math.sin(d15 - d19), Math.sin(d18) * d21 * Math.cos(d15 - d19) - Math.cos(d18) * d20);
        point3D.y = d16;
        point3D.x = Utilities.longitude180(d15 + this.h);
        return;
    }

    public void init() throws ValidationException {
        this.e = Math.sin(this.g);
        this.l = Math.cos(this.g);
        this.d = Math.sin(this.f);
        this.k = Math.cos(this.f);
        this.a = this.e * this.d + this.l * this.k * Math.cos(Utilities.longitude180(this.i - this.j));
        this.a = this.a > 1.0 ? 1.0 : (this.a < -1.0 ? -1.0 : this.a);
        this.a = Math.acos(this.a);
        this.h = Math.atan2(this.l * this.d * Math.cos(this.j) - this.e * this.k * Math.cos(this.i), this.e * this.k * Math.sin(this.i) - this.l * this.d * Math.sin(this.j));
        this.makeHorizon(this.h, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public TwoPointEquidistant(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.c = d6;
        this.b = d7;
        this.j = d2;
        this.i = d4;
        this.g = d3;
        this.f = d5;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new TwoPointEquidistant(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        TwoPointEquidistant twoPointEquidistant = null;
        twoPointEquidistant = (TwoPointEquidistant)super.clone();
        twoPointEquidistant.j = this.j;
        twoPointEquidistant.g = this.g;
        twoPointEquidistant.i = this.i;
        twoPointEquidistant.f = this.f;
        twoPointEquidistant.b = this.b;
        twoPointEquidistant.c = this.c;
        try {
            twoPointEquidistant.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return twoPointEquidistant;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new TwoPointEquidistant(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.g);
        this.setValue(3, this.j);
        this.setValue(4, this.f);
        this.setValue(5, this.i);
        this.setValue(6, this.c);
        this.setValue(7, this.b);
        return;
    }

    private void a() {
        this.g = this.getValue(2);
        this.j = this.getValue(3);
        this.f = this.getValue(4);
        this.i = this.getValue(5);
        this.c = this.getValue(6);
        this.b = this.getValue(7);
        return;
    }

    public TwoPointEquidistant(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public TwoPointEquidistant(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    TwoPointEquidistant() {
    }
}

