/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.DoubleHorizon;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.Horizon;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class TransverseMercator
extends GenericProjection {
    private double c;
    private double d;
    private double a;
    private double b;
    private double e;
    private double f;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (this._ellipsoid.isSphere()) {
            double d2 = Utilities.longitude180(point3D.x - this.c);
            double d3 = Math.cos(point3D.y) * Math.sin(d2);
            point3D.x = 0.5 * this._ellipsoid.getRadius() * this.e * Math.log((1.0 + d3) / (1.0 - d3)) + this.b;
            point3D.y = d2 < -1.5707963267948966 ? this._ellipsoid.getRadius() * this.e * (Math.atan(Math.tan(point3D.y) / Math.cos(d2)) - this.d) + this.a + 2.0 * this._ellipsoid.getRadius() * this.e * 1.5707963267948966 : (d2 > 1.5707963267948966 ? this._ellipsoid.getRadius() * this.e * (Math.atan(Math.tan(point3D.y) / Math.cos(d2)) - this.d) + this.a + 2.0 * this._ellipsoid.getRadius() * this.e * 1.5707963267948966 : this._ellipsoid.getRadius() * this.e * (Math.atan(Math.tan(point3D.y) / Math.cos(d2)) - this.d) + this.a);
        } else {
            double d4 = this._ellipsoid.meridianDistance(point3D.y);
            double d5 = this._ellipsoid.radiusOfCurvatureN(point3D.y);
            double d6 = Math.cos(point3D.y);
            double d7 = Math.sin(point3D.y);
            double d8 = Utilities.longitude180(point3D.x - this.c);
            double d9 = Math.abs(d6) < 1.0E-10 ? d7 / (Utilities.signum(d6) * 1.0E-10) : d7 / d6;
            double d10 = d9 * d9;
            double d11 = d10 * d10;
            double d12 = this._ellipsoid.eccentricityPrimeSquared() * d6 * d6;
            double d13 = d8 * d6;
            double d14 = d13 * d13;
            double d15 = d14 * d13;
            double d16 = this._ellipsoid.eccentricityPrimeSquared();
            point3D.x = this.b + this.e * d5 * (d13 + (1.0 - d10 + d12) * d15 / 6.0 + (5.0 - 18.0 * d10 + d11 + 72.0 * d12 - 58.0 * d16) * d15 * d14 / 120.0);
            point3D.y = this.a + this.e * (d4 - this.f + d5 * d9 * (d14 * 0.5 + (5.0 - d10 + 9.0 * d12 + 4.0 * d12 * d12) * d14 * d14 / 24.0 + (61.0 - 58.0 * d10 + d11 + 600.0 * d12 - 330.0 * d16) * d15 * d15 / 720.0));
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        if (this._ellipsoid.isSphere()) {
            point3D.y -= this.a;
            point3D.x -= this.b;
            double d2 = point3D.y * this._ellipsoid.getRadius() * this.e + this.d;
            double d3 = point3D.x / (this._ellipsoid.getRadius() * this.e);
            point3D.x = this.c + Math.atan(Utilities.sinh(d3) / Math.cos(d2));
            point3D.y = Math.asin(Math.sin(d2) / Utilities.cosh(d3));
        } else {
            double d4 = this.f + (point3D.y - this.a) / this.e;
            double d5 = this._ellipsoid.eccentricitySquared();
            double d6 = d5 * d5;
            double d7 = 1.5707963267948966 * d4 / this._ellipsoid.meridianDistanceToPole();
            double d8 = this._ellipsoid.rectifyingToLatitude(d7);
            double d9 = this._ellipsoid.eccentricityPrimeSquared();
            double d10 = Math.cos(d8);
            double d11 = Math.sin(d8);
            double d12 = d11 * d11;
            double d13 = d10 > 1.0E-14 ? d11 / d10 : 0.0;
            double d14 = d9 * d10 * d10;
            double d15 = d13 * d13;
            double d16 = 1.0 - d5 * d12;
            double d17 = Math.sqrt(d16);
            double d18 = this._ellipsoid.semiMajor() / d17;
            double d19 = this._ellipsoid.semiMajor() * (1.0 - d5) / (d16 * d17);
            double d20 = (point3D.x - this.b) / (d18 * this.e);
            double d21 = d20 * d20;
            double d22 = d14 * d14;
            double d23 = d20 * d21;
            double d24 = d21 * d21;
            double d25 = d24 * d20;
            double d26 = d24 * d21;
            double d27 = d15 * d15;
            point3D.y = d8 - d18 * d13 / d19 * (d21 * 0.5 - (5.0 + 3.0 * d15 + 10.0 * d14 - 4.0 * d22 - 9.0 * d9) * d24 / 24.0 + (61.0 + 90.0 * d15 + 298.0 * d14 + 45.0 * d27 - 252.0 * d9 - 3.0 * d22) * d26 / 720.0);
            point3D.x = this.c + (d20 - (1.0 + 2.0 * d15 + d14) * d23 / 6.0 + (5.0 - 2.0 * d14 + 28.0 * d15 - 3.0 * d22 + 8.0 * d9 + 24.0 * d27) * d25 / 120.0) / d10;
        }
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        if (!this._ellipsoid.isSphere()) {
            this.makeHorizon(this.c - 1.0471975511965976, this.c + 1.0471975511965976, -1.5707963267948966, 1.5707963267948966);
            this.f = this._ellipsoid.meridianDistance(this.d);
        } else {
            double d2 = this.c < 0.0 ? this.c + Math.PI : this.c - Math.PI;
            this.makeHorizon(this.c - 1.5707961522619713, this.c + 1.5707961522619713, -1.5706963267948966, 1.5706963267948966);
            Horizon horizon = this._horizon;
            this.makeHorizon(d2 - 1.5707961522619713, d2 + 1.5707961522619713, 1.0E-4, 1.5706963267948966);
            horizon = new DoubleHorizon(horizon, this._horizon);
            this.makeHorizon(d2 - 1.5707961522619713, d2 + 1.5707961522619713, -1.5706963267948966, -1.0E-4);
            this._horizon = new DoubleHorizon(horizon, this._horizon);
        }
        return;
    }

    public TransverseMercator(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d5;
        this.a = d6;
        this.c = d2;
        this.d = d3;
        this.e = d4;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new TransverseMercator(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        TransverseMercator transverseMercator = null;
        transverseMercator = (TransverseMercator)super.clone();
        transverseMercator.c = this.c;
        transverseMercator.d = this.d;
        transverseMercator.e = this.e;
        transverseMercator.a = this.a;
        transverseMercator.b = this.b;
        try {
            transverseMercator.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return transverseMercator;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new TransverseMercator(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.d);
        this.setValue(4, this.e);
        this.setValue(5, this.b);
        this.setValue(6, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.d = this.getValue(3);
        this.e = this.getValue(4);
        this.b = this.getValue(5);
        this.a = this.getValue(6);
        return;
    }

    public TransverseMercator(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public TransverseMercator(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    TransverseMercator() {
    }
}

