/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.cs.geod.ValidationMessageException;
import com.esri.mo.util.Resource;

public class Stereographic
extends GenericProjection {
    private double c;
    private double a;
    private double d;
    private double b;
    protected double _k0;
    protected double _lon0;
    protected double _lat1;
    protected double _y0;
    protected double _x0;

    public static void main(String[] stringArray) {
        Stereographic stereographic;
        Ellipsoid ellipsoid = new Ellipsoid(6378206.4, 0.00676866, true);
        try {
            stereographic = new Stereographic(ellipsoid, Utilities.decimalDegreesToRadians(-100.0), Utilities.decimalDegreesToRadians(40.0), 0.9999, 0.0, 0.0);
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return;
        }
        Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-90.0), Utilities.decimalDegreesToRadians(30.0), 0.0);
        try {
            stereographic.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            stereographic.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        ellipsoid = new Ellipsoid(6378206.4, 0.00676866, true);
        try {
            stereographic = new Stereographic(ellipsoid, Utilities.decimalDegreesToRadians(0.0), Utilities.decimalDegreesToRadians(0.0), 0.9999, 0.0, 0.0);
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return;
        }
        point3D = new Point3D(Utilities.decimalDegreesToRadians(100.0), Utilities.decimalDegreesToRadians(-40.0), 0.0);
        try {
            stereographic.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            stereographic.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        ellipsoid = new Ellipsoid(6378206.4, 0.0);
        try {
            stereographic = new Stereographic(ellipsoid, Utilities.decimalDegreesToRadians(-100.0), Utilities.decimalDegreesToRadians(40.0), 0.9999, 0.0, 0.0);
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return;
        }
        point3D = new Point3D(Utilities.decimalDegreesToRadians(-90.0), Utilities.decimalDegreesToRadians(30.0), 0.0);
        try {
            stereographic.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            stereographic.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        ellipsoid = new Ellipsoid(6378206.4, 0.0);
        try {
            stereographic = new Stereographic(ellipsoid, Utilities.decimalDegreesToRadians(0.0), Utilities.decimalDegreesToRadians(0.0), 0.9999, 0.0, 0.0);
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return;
        }
        point3D = new Point3D(Utilities.decimalDegreesToRadians(100.0), Utilities.decimalDegreesToRadians(-40.0), 0.0);
        try {
            stereographic.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            stereographic.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        return;
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2;
        double d3;
        double d4;
        double d5 = Utilities.longitude180(point3D.x - this._lon0);
        double d6 = Math.cos(d5);
        if (this._ellipsoid.isSphere()) {
            d4 = Math.cos(point3D.y);
            d3 = Math.sin(point3D.y);
            double d7 = 1.0 + this.a * d3 + this.c * d4 * d6;
            if (Math.abs(d7) * this._ellipsoid.getRadius() < 0.01) {
                d7 = 0.01 / this._ellipsoid.getRadius();
            }
            d2 = 2.0 * this._ellipsoid.getRadius() * this._k0 / d7;
        } else {
            double d8 = this._ellipsoid.conformalLatitude(point3D.y);
            d4 = Math.cos(d8);
            d3 = Math.sin(d8);
            double d9 = this.c * (1.0 + this.a * d3 + this.c * d4 * d6);
            if (Math.abs(d9) * this._ellipsoid.semiMajor() < 0.01) {
                d9 = 0.01 / this._ellipsoid.semiMajor();
            }
            d2 = 2.0 * this._ellipsoid.semiMajor() * this._k0 * this.b / d9;
        }
        point3D.x = this._x0 + d2 * d4 * Math.sin(d5);
        point3D.y = this._y0 + d2 * (this.c * d3 - this.a * d4 * d6);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this._y0;
        point3D.x -= this._x0;
        double d2 = Math.sqrt(point3D.x * point3D.x + point3D.y * point3D.y);
        if (this._ellipsoid.isSphere()) {
            double d3 = 2.0 * Math.atan2(d2, 2.0 * this._ellipsoid.getRadius() * this._k0);
            if (Math.abs(d2) < 1.0E-13) {
                point3D.x = this._lon0;
                point3D.y = this._lat1;
            } else {
                double d4 = Math.cos(d3);
                double d5 = Math.sin(d3);
                point3D.x = this._lon0 + Math.atan2(point3D.x * d5, d2 * this.c * d4 - point3D.y * this.a * d5);
                point3D.y = Math.asin(d4 * this.a + point3D.y * d5 * this.c / d2);
            }
        } else {
            double d6;
            if (Math.abs(d2) < 1.0E-13) {
                d6 = this.d;
                point3D.x = this._lon0;
            } else {
                double d7 = 2.0 * Math.atan2(d2 * this.c, 2.0 * this._ellipsoid.semiMajor() * this._k0 * this.b);
                double d8 = Math.cos(d7);
                double d9 = Math.sin(d7);
                d6 = Math.asin(d8 * this.a + point3D.y * d9 * this.c / d2);
                point3D.x = this._lon0 + Math.atan2(point3D.x * d9, d2 * this.c * d8 - point3D.y * this.a * d9);
            }
            point3D.y = this._ellipsoid.conformalLatitudeToLatitude(d6);
        }
        return;
    }

    public void init() throws ValidationException {
        if (this._k0 < 1.0E-12) {
            throw new ValidationMessageException(Resource.getBundleText("SScaleFactor"));
        }
        if (this._ellipsoid == null) {
            return;
        }
        this.makeHorizon(this._lon0, -1.5707963267948966, 1.5707963267948966);
        if (this._ellipsoid.isSphere()) {
            this.d = this._lat1;
        } else {
            this.b = this._ellipsoid.m(this._lat1);
            this.d = this._ellipsoid.conformalLatitude(this._lat1);
        }
        this.a = Math.sin(this.d);
        this.c = Math.cos(this.d);
        return;
    }

    public Stereographic(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this._x0 = d5;
        this._y0 = d6;
        this._lon0 = d2;
        this._lat1 = d3;
        this._k0 = d4;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Stereographic(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Stereographic stereographic = null;
        stereographic = (Stereographic)super.clone();
        stereographic._lon0 = this._lon0;
        stereographic._k0 = this._k0;
        stereographic._lat1 = this._lat1;
        stereographic._y0 = this._y0;
        stereographic._x0 = this._x0;
        try {
            stereographic.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return stereographic;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Stereographic(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this._lon0);
        this.setValue(3, this._lat1);
        this.setValue(4, this._k0);
        this.setValue(5, this._x0);
        this.setValue(6, this._y0);
        return;
    }

    private void a() {
        this._lon0 = this.getValue(2);
        this._lat1 = this.getValue(3);
        this._k0 = this.getValue(4);
        this._x0 = this.getValue(5);
        this._y0 = this.getValue(6);
        return;
    }

    public Stereographic(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    protected Stereographic(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Stereographic() {
    }
}

