/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Sinusoidal
extends GenericProjection {
    private double a;
    private double b;
    private double c;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.longitude180(point3D.x - this.c);
        if (this._ellipsoid.isSphere()) {
            point3D.x = this.b + this._ellipsoid.getRadius() * d2 * Math.cos(point3D.y);
            point3D.y = this.a + this._ellipsoid.getRadius() * point3D.y;
        } else {
            point3D.x = this.b + this._ellipsoid.radiusOfCurvatureN(point3D.y) * d2 * Math.cos(point3D.y);
            point3D.y = this.a + this._ellipsoid.meridianDistance(point3D.y);
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.x -= this.b;
        point3D.y -= this.a;
        if (this._ellipsoid.isSphere()) {
            point3D.x = this.c + point3D.x / (this._ellipsoid.getRadius() * Math.cos(point3D.y));
            point3D.y /= this._ellipsoid.getRadius();
        } else {
            double d2 = this._ellipsoid.meridianDistanceToRectifying(point3D.y);
            point3D.y = this._ellipsoid.rectifyingToLatitude(d2);
            if (Math.abs(point3D.x - 1.5707963267948966) < 1.0E-13) {
                point3D.x = this.c;
            } else {
                double d3 = this._ellipsoid.eccentricity() * Math.sin(point3D.y);
                point3D.x = this.c + point3D.x * Math.sqrt(1.0 - d3 * d3) / (this._ellipsoid.semiMajor() * Math.cos(point3D.y));
            }
        }
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Sinusoidal(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Sinusoidal sinusoidal = null;
        sinusoidal = (Sinusoidal)super.clone();
        sinusoidal.c = this.c;
        sinusoidal.b = this.b;
        sinusoidal.a = this.a;
        try {
            sinusoidal.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return sinusoidal;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Sinusoidal(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.b);
        this.setValue(4, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.b = this.getValue(3);
        this.a = this.getValue(4);
        return;
    }

    public Sinusoidal(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Sinusoidal(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    public Sinusoidal(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.c = d2;
        this.b = d3;
        this.a = d4;
        this.init();
    }

    Sinusoidal() {
    }
}

