/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Robinson
extends GenericProjection {
    private double h;
    private double f;
    private double g;
    private static double[] b;
    private static double[] a;
    private double e;
    private double c;
    private double d;

    static {
        a = new double[21];
        b = new double[21];
        Robinson.b[1] = -0.062;
        Robinson.a[1] = 0.9986;
        Robinson.b[2] = 0.0;
        Robinson.a[2] = 1.0;
        Robinson.b[3] = 0.062;
        Robinson.a[3] = 0.9986;
        Robinson.b[4] = 0.124;
        Robinson.a[4] = 0.9954;
        Robinson.b[5] = 0.186;
        Robinson.a[5] = 0.99;
        Robinson.b[6] = 0.248;
        Robinson.a[6] = 0.9822;
        Robinson.b[7] = 0.31;
        Robinson.a[7] = 0.973;
        Robinson.b[8] = 0.372;
        Robinson.a[8] = 0.96;
        Robinson.b[9] = 0.434;
        Robinson.a[9] = 0.9427;
        Robinson.b[10] = 0.4958;
        Robinson.a[10] = 0.9216;
        Robinson.b[11] = 0.5571;
        Robinson.a[11] = 0.8962;
        Robinson.b[12] = 0.6176;
        Robinson.a[12] = 0.8679;
        Robinson.b[13] = 0.6769;
        Robinson.a[13] = 0.835;
        Robinson.b[14] = 0.7346;
        Robinson.a[14] = 0.7986;
        Robinson.b[15] = 0.7903;
        Robinson.a[15] = 0.7597;
        Robinson.b[16] = 0.8435;
        Robinson.a[16] = 0.7186;
        Robinson.b[17] = 0.8936;
        Robinson.a[17] = 0.6732;
        Robinson.b[18] = 0.9394;
        Robinson.a[18] = 0.6213;
        Robinson.b[19] = 0.9761;
        Robinson.a[19] = 0.5722;
        Robinson.b[20] = 1.0;
        Robinson.a[20] = 0.5322;
    }

    public static void main(String[] stringArray) {
        Robinson robinson;
        try {
            robinson = new Robinson(new Ellipsoid(6371000.0, 0.0), 0.0, 0.0, 0.0);
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return;
        }
        Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(0.1), Utilities.decimalDegreesToRadians(38.0), 0.0);
        try {
            robinson.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            robinson.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        return;
    }

    private double a(int n2, double d2, double[] dArray) {
        return dArray[n2 + 2] + d2 * (dArray[n2 + 3] - dArray[n2 + 1]) / 2.0 + d2 * d2 * (dArray[n2 + 3] - 2.0 * dArray[n2 + 2] + dArray[n2 + 1]) / 2.0;
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.longitude180(point3D.x - this.e);
        if (point3D.y > 1.5707963267948966) {
            point3D.y = 1.5707963267948966;
        } else if (point3D.y < -1.5707963267948966) {
            point3D.y = -1.5707963267948966;
        }
        double d3 = Math.abs(point3D.y / Math.PI * 36.0);
        int n2 = (int)(d3 - 1.0E-14);
        point3D.x = this.g * this.a(n2, d3 -= (double)n2, a) * d2 + this.d;
        point3D.y = this.f * Utilities.signum(point3D.y) * this.a(n2, d3, b) + this.c;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        int n2;
        double d2;
        double d3;
        point3D.y -= this.c;
        point3D.x -= this.d;
        double d4 = Math.abs(point3D.y);
        double d5 = Math.abs(point3D.y / this.h);
        int n3 = 0;
        do {
            d2 = 0.2 * d5 / (Math.PI / 180);
            n2 = (int)(d2 - 1.0E-14);
            double d6 = this.f * this.a(n2, d2 -= (double)n2, b) + this.c;
            d3 = d4 - d6;
            if (!((d5 += d3 / this.h) < 0.0)) continue;
            d5 = 0.0;
        } while (++n3 < 50 && Math.abs(d3) > 1.0E-12);
        point3D.y = Utilities.signum(point3D.y) * d5;
        point3D.x = this.e + point3D.x / (this.g * this.a(n2, d2, a));
        if (point3D.x < -Math.PI) {
            point3D.x = -Math.PI;
        } else if (point3D.x > Math.PI) {
            point3D.x = Math.PI;
        }
        return;
    }

    public void init() throws ValidationException {
        this.h = this._ellipsoid.authalicR();
        this.g = 0.8487 * this.h;
        this.f = this.g * 0.5072 * Math.PI;
        this.makeHorizon(this.e, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public Robinson(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.d = d3;
        this.c = d4;
        this.e = d2;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Robinson(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Robinson robinson = null;
        robinson = (Robinson)super.clone();
        robinson.e = this.e;
        robinson.c = this.c;
        robinson.d = this.d;
        try {
            robinson.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return robinson;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Robinson(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.e);
        this.setValue(3, this.d);
        this.setValue(4, this.c);
        return;
    }

    private void a() {
        this.e = this.getValue(2);
        this.d = this.getValue(3);
        this.c = this.getValue(4);
        return;
    }

    public Robinson(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Robinson(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Robinson() {
    }
}

