/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseNamedGeodeticObject;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.DatumTransformation;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticDatabase;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.GeographicCoordinateSystem;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.NoneDatumTransformation;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.VariableSchema;

public class ReferencedDatum
extends BaseNamedGeodeticObject {
    private int b;
    private DatumTransformation a;

    public boolean hasDatumTransformation() {
        return this.a != null && this.a.hasDatumTransformation();
    }

    public boolean isSameDatum(ReferencedDatum referencedDatum) {
        return referencedDatum.getName().equals(this.getName());
    }

    public void fromWGS84(Point3D point3D) throws CalculationException {
        this.a.inverse(point3D);
        return;
    }

    public void toWGS84(Point3D point3D) throws CalculationException {
        this.a.forward(point3D);
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new ReferencedDatum(geodeticRow);
    }

    public ReferencedDatum(GeodeticRow geodeticRow) throws InvalidRowDataException {
        super(geodeticRow, 0);
        GeographicCoordinateSystem geographicCoordinateSystem;
        if (geodeticRow.getLength() <= 3) {
            throw new InvalidRowDataException(geodeticRow);
        }
        String string = new String(this._name);
        int n2 = 0;
        n2 = string.indexOf(45);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if ((geographicCoordinateSystem = (GeographicCoordinateSystem)GeodeticDatabase.getDatabase().getGeographicCoordinateSystemTable().getObject(string)) == null) {
            System.out.println("Could not find " + string + ", " + n2 + ", " + this._name);
        }
        try {
            this.b = Integer.parseInt(geodeticRow.getColumn(3));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Row: " + geodeticRow.getColumn(0) + ", " + geodeticRow.getColumn(1) + ", " + geodeticRow.getColumn(3));
        }
        VariableSchema variableSchema = (VariableSchema)geodeticRow.getDatabase().getDatumTransformationSchemaTable().getObject(geodeticRow.getColumn(4));
        if (variableSchema == null) {
            throw new InvalidRowDataException(geodeticRow);
        }
        this.a = (DatumTransformation)variableSchema.useSchema(geodeticRow, 5);
        this.a.setFactory(variableSchema);
        if (this.a == null) {
            throw new InvalidRowDataException(geodeticRow);
        }
        this.a.setSourceEllipsoid(geographicCoordinateSystem.getEllipsoid());
        this.a.setTargetEllipsoid(Ellipsoid.WGS84);
    }

    public Ellipsoid getEllipsoid() {
        return this.a.sourceEllipsoid();
    }

    public DatumTransformation getDatumTransformation() {
        return this.a;
    }

    public int getDatumTransformationID() {
        return this.b;
    }

    ReferencedDatum(GeographicCoordinateSystem geographicCoordinateSystem) {
        this._description = new String(geographicCoordinateSystem.getDescription());
        this._longDescription = new String(geographicCoordinateSystem.getLongDescription());
        this._name = new String(geographicCoordinateSystem.getName());
        this._table = null;
        this.b = 0;
        this.a = new NoneDatumTransformation();
        this.a.setSourceEllipsoid(geographicCoordinateSystem.getEllipsoid());
        this.a.setTargetEllipsoid(Ellipsoid.WGS84);
    }

    ReferencedDatum() {
    }
}

