/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseNamedGeodeticObject;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Datum;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticDatabase;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.GeographicCoordinateSystem;
import com.esri.mo.cs.geod.Horizon;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.LatLonProjection;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.PrimeMeridian;
import com.esri.mo.cs.geod.Projection;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.ReferencedCoordinateSystem;
import com.esri.mo.cs.geod.ReferencedDatum;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.ValidationException;

public class ReferencedCoordinateSystemImpl
extends BaseNamedGeodeticObject
implements ReferencedCoordinateSystem {
    private int d;
    private PrimeMeridian b;
    private ReferencedDatum c;
    private Projection a;
    public static ReferencedCoordinateSystem WGS84_IN_RADIANS;
    public static ReferencedCoordinateSystem WGS84;

    static {
        try {
            WGS84 = new ReferencedCoordinateSystemImpl(GeographicCoordinateSystem.WGS84, new LatLonProjection(GeographicCoordinateSystem.WGS84.getEllipsoid(), GeographicCoordinateSystem.WGS84.getUnit()), "WGS84", "WGS84", "WGS84");
            WGS84_IN_RADIANS = new ReferencedCoordinateSystemImpl(GeographicCoordinateSystem.WGS84_IN_RADIANS, new LatLonProjection(GeographicCoordinateSystem.WGS84_IN_RADIANS.getEllipsoid(), GeographicCoordinateSystem.WGS84_IN_RADIANS.getUnit()), "WGS84", "WGS84", "WGS84");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasDatumTransformation() {
        return this.c.hasDatumTransformation();
    }

    public Datum getDatum() {
        return null;
    }

    public boolean needsDatumTransformation(ReferencedCoordinateSystem referencedCoordinateSystem) {
        return this.c.isSameDatum(referencedCoordinateSystem.getReferencedDatum());
    }

    public void setReferencedDatum(ReferencedDatum referencedDatum) {
        this.c = referencedDatum;
        this.a.setEllipsoid(this.c.getEllipsoid());
        return;
    }

    public void setUnit(Unit unit) {
        this.a.setUnit(unit);
        return;
    }

    public String getPECoordSysString() {
        if (!this.a.isLatitudeLongitude()) {
            return "PROJCS[\"" + this.getName() + "\",GEOGCS[\"" + this.c.getName() + "\",DATUM[\"" + this.c.getName() + "\"," + this.a.getEllipsoid().getPEString() + "]," + this.b.getPEString() + "]," + this.a.getPEString() + "]";
        }
        return "GEOGCS[\"" + this.getName() + "\",DATUM[\"" + this.c.getName() + "\"," + this.a.getEllipsoid().getPEString() + "]," + this.b.getPEString() + "]";
    }

    public String getPEString() {
        return new String("");
    }

    public String getPEDatumString() {
        if (this.c.getDatumTransformation().getPEString().length() < 1) {
            return "";
        }
        return "GEOGTRAN[\"" + this.c.getName() + "\",GEOGCS[\"" + this.c.getName() + "\",DATUM[\"" + this.c.getName() + "\"," + this.c.getEllipsoid().getPEString() + "]," + this.b.getPEString() + ",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.0174532925199433]]" + this.c.getDatumTransformation().getPEString() + "]";
    }

    public void convertToUseDatumShift(ReferencedCoordinateSystem referencedCoordinateSystem, Point3D point3D, Point3D point3D2) throws CalculationException {
        this.toGeographic(point3D);
        point3D.x += point3D2.x;
        point3D.y += point3D2.y;
        point3D.z += point3D2.z;
        referencedCoordinateSystem.fromGeographic(point3D);
        return;
    }

    public void convertTo(ReferencedCoordinateSystem referencedCoordinateSystem, Point3D point3D) throws CalculationException {
        this.toWGS84Geographic(point3D);
        referencedCoordinateSystem.fromWGS84Geographic(point3D);
        return;
    }

    public void fromWGS84Geographic(Point3D point3D) throws CalculationException {
        this.c.fromWGS84(point3D);
        this.fromGeographic(point3D);
        return;
    }

    public void toWGS84Geographic(Point3D point3D) throws CalculationException {
        this.toGeographic(point3D);
        this.c.toWGS84(point3D);
        return;
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        this.a.fromGeographic(point3D);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        this.a.toGeographic(point3D);
        return;
    }

    public Ellipsoid getEllipsoid() {
        return this.c.getEllipsoid();
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.b;
    }

    public ReferencedDatum getReferencedDatum() {
        return this.c;
    }

    public Unit getUnit() {
        return this.a.getUnit();
    }

    public Horizon getHorizon() {
        return this.a.getHorizon();
    }

    public Projection getProjection() {
        return this.a;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new ReferencedCoordinateSystemImpl(geodeticRow);
    }

    public ReferencedCoordinateSystemImpl(GeodeticRow geodeticRow) throws InvalidRowDataException {
        super(geodeticRow, 0);
        if (geodeticRow.getLength() <= 5) {
            throw new InvalidRowDataException(geodeticRow);
        }
        this.d = Integer.parseInt(geodeticRow.getColumn(3));
        this.c = (ReferencedDatum)GeodeticDatabase.getDatabase().getReferencedDatumTable().getObject(geodeticRow.getColumn(4));
        if (this.c == null) {
            System.out.println("Datum problem: " + geodeticRow.getColumn(4));
            throw new InvalidRowDataException(geodeticRow);
        }
        this.b = PrimeMeridian.GREENWICH;
        ProjectionSchema projectionSchema = (ProjectionSchema)geodeticRow.getDatabase().getProjectionSchemaTable().getObject(geodeticRow.getColumn(5));
        if (projectionSchema == null) {
            System.out.println("Projection Schema problem: " + geodeticRow.getColumn(5));
            throw new InvalidRowDataException(geodeticRow);
        }
        this.a = (Projection)projectionSchema.useSchema(geodeticRow, 6);
        if (this.a == null) {
            throw new InvalidRowDataException(geodeticRow);
        }
        this.a.setEllipsoid(this.c.getEllipsoid());
        try {
            this.a.init();
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
        }
    }

    public ReferencedCoordinateSystemImpl(ReferencedDatum referencedDatum, Projection projection, PrimeMeridian primeMeridian) throws ValidationException {
        this._name = new String();
        this._description = new String();
        this._longDescription = new String();
        this.d = 0;
        this.c = referencedDatum;
        this.b = primeMeridian;
        this.a = projection;
        this.a.setEllipsoid(this.c.getEllipsoid());
        this.a.init();
    }

    public ReferencedCoordinateSystemImpl(GeographicCoordinateSystem geographicCoordinateSystem, Projection projection, String string, String string2, String string3) throws ValidationException {
        this._name = new String(string);
        this._description = new String(string2);
        this._longDescription = new String(string3);
        this.d = 0;
        this.c = new ReferencedDatum(geographicCoordinateSystem);
        this.b = geographicCoordinateSystem.getPrimeMeridian();
        this.a = projection;
        this.a.setEllipsoid(this.c.getEllipsoid());
        this.a.init();
    }

    public ReferencedCoordinateSystemImpl(GeographicCoordinateSystem geographicCoordinateSystem, Projection projection) throws ValidationException {
        this._name = new String();
        this._description = new String();
        this._longDescription = new String();
        this.d = 0;
        this.c = new ReferencedDatum(geographicCoordinateSystem);
        this.b = geographicCoordinateSystem.getPrimeMeridian();
        this.a = projection;
        this.a.setEllipsoid(this.c.getEllipsoid());
        this.a.init();
    }

    public int getCoordSysID() {
        return this.d;
    }

    ReferencedCoordinateSystemImpl() {
    }
}

