/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.AngularUnit;
import com.esri.mo.cs.geod.GeoDialogInfo;
import com.esri.mo.cs.geod.GeodeticDatabase;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.LinearUnit;
import com.esri.mo.cs.geod.MessageListener;
import com.esri.mo.cs.geod.NamedObject;
import com.esri.mo.cs.geod.NumericField;
import com.esri.mo.cs.geod.Projection;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.RangeValidationException;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.ui.dlg.MessageBox;
import com.esri.mo.util.Resource;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProjectionParameterEntryPanel
extends JPanel
implements GeoDialogInfo {
    private boolean g;
    private JComponent[] f;
    private LinearUnit c;
    private AngularUnit h;
    private Projection b;
    private ProjectionSchema a;
    private MessageListener d;
    private JTextField[] e;

    public boolean usesEllipsoid() {
        return this.a.getExemplar().hasEllipsoidalSolution();
    }

    public boolean usesSpheroid() {
        return this.a.getExemplar().hasSphereSolution();
    }

    public ProjectionParameterEntryPanel(MessageListener messageListener, ProjectionSchema projectionSchema, boolean bl) {
        this.a = projectionSchema;
        try {
            this.c = (LinearUnit)GeodeticDatabase.getDatabase().getLinearUnitTable().getObject("METER");
            this.h = (AngularUnit)GeodeticDatabase.getDatabase().getAngularUnitTable().getObject("DEGREE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.d = messageListener;
        ProjectionParameterEntryPanel projectionParameterEntryPanel = this;
        projectionParameterEntryPanel.setLayout(new FlowLayout());
        int n2 = projectionSchema.getNumberOfParameters();
        int n3 = (n2 + 1) / 2;
        JPanel jPanel = new JPanel();
        if (!bl) {
            jPanel.setLayout(new GridLayout(n3, 4));
        } else {
            jPanel.setLayout(new GridLayout(n2, 2));
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(8);
        decimalFormat.setMinimumFractionDigits(3);
        decimalFormat.setMaximumIntegerDigits(10);
        if (n2 > 0) {
            this.f = new JComponent[n2];
        }
        this.g = false;
        int n4 = 0;
        while (n4 < n2) {
            jPanel.add(new JLabel(projectionSchema.getParameterSchema(n4).getDescription() + ": ", 4));
            try {
                this.f[n4] = projectionSchema.getParameterSchema(n4).createComponent(this);
                jPanel.add(this.f[n4]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n4;
        }
        if (!bl && n2 / 2 != n3) {
            jPanel.add(new JLabel(""));
            jPanel.add(new JLabel(""));
        }
        projectionParameterEntryPanel.add(jPanel);
        this.c = null;
        this.h = null;
    }

    public Projection getProjection() throws RangeValidationException, InvalidDataException {
        Object object;
        Object object2;
        String[] stringArray = new String[this.f.length];
        int n2 = 0;
        while (n2 < this.f.length) {
            block15: {
                if (this.f[n2] instanceof JComboBox) {
                    object2 = (NamedObject)((JComboBox)this.f[n2]).getSelectedItem();
                    stringArray[n2] = object2.getName().toString();
                } else if (this.f[n2] instanceof JTextField) {
                    stringArray[n2] = ((JTextField)this.f[n2]).getText();
                    if (this.f[n2] instanceof NumericField) {
                        try {
                            ((NumericField)this.f[n2]).validation();
                        }
                        catch (Exception exception) {
                            object = "";
                            if (exception instanceof InvalidDataException) {
                                object = ((InvalidDataException)exception).getMessageString();
                            } else if (exception instanceof RangeValidationException) {
                                object = ((RangeValidationException)exception).getMessageString();
                            }
                            MessageBox.showMessageDialog(this, this.a.getParameterSchema(n2).getDescription() + " " + (String)object, Resource.getBundleText("PPEPError"), 0);
                            if (exception instanceof InvalidDataException) {
                                throw (InvalidDataException)exception;
                            }
                            if (!(exception instanceof RangeValidationException)) break block15;
                            throw (RangeValidationException)exception;
                        }
                    }
                }
            }
            ++n2;
        }
        object2 = new GeodeticRow(stringArray);
        object = null;
        try {
            object = (Projection)this.a.useSchema((GeodeticRow)object2, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public void setLinearUnit(Unit unit) {
    }

    public void setAngularUnit(Unit unit) {
    }

    public Unit getLinearUnit() {
        if (this.c != null) {
            return this.c;
        }
        if (this.f.length > 1) {
            return (Unit)((JComboBox)this.f[1]).getSelectedItem();
        }
        return null;
    }

    public Unit getAngularUnit() {
        if (this.h != null) {
            return this.h;
        }
        return (Unit)((JComboBox)this.f[0]).getSelectedItem();
    }
}

