/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.CoordinateSystem;
import com.esri.mo.cs.geod.Datum;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeographicCoordinateSystem;
import com.esri.mo.cs.geod.Horizon;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.PrimeMeridian;
import com.esri.mo.cs.geod.Projection;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;

public class Projcs
implements CoordinateSystem {
    private boolean e;
    private double b;
    private GeographicCoordinateSystem d;
    private Projection a;
    private String c;

    public boolean hasDatumTransformation() {
        return false;
    }

    public Horizon getHorizon() {
        return this.a.getHorizon();
    }

    public String getPECoordSysString() {
        return "PROJCS[\"" + this.getName() + "\"," + this.d.getPECoordSysString() + this.a.getPEString() + "]";
    }

    public String getPEDatumString() {
        return "";
    }

    public void fromWGS84Geographic(Point3D point3D) throws CalculationException {
        if (this.e) {
            point3D.x = Utilities.angle180(point3D.x - this.b);
        }
        this.a.fromGeographic(point3D);
        return;
    }

    public void toWGS84Geographic(Point3D point3D) throws CalculationException {
        this.a.toGeographic(point3D);
        if (this.e) {
            point3D.x = Utilities.angle180(point3D.x + this.b);
        }
        return;
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (this.e) {
            point3D.x = Utilities.angle180(point3D.x - this.b);
        }
        this.a.fromGeographic(point3D);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        this.a.toGeographic(point3D);
        if (this.e) {
            point3D.x = Utilities.angle180(point3D.x + this.b);
        }
        return;
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.d.getPrimeMeridian();
    }

    public Ellipsoid getEllipsoid() {
        return this.a.getEllipsoid();
    }

    public Datum getDatum() {
        return this.d.getDatum();
    }

    public Unit getUnit() {
        return this.a.getUnit();
    }

    public String getName() {
        return this.c;
    }
}

