/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseNamedGeodeticObject;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.PEObject;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;

public class PrimeMeridian
extends BaseNamedGeodeticObject
implements PEObject {
    private double a;
    public static final PrimeMeridian GREENWICH = new PrimeMeridian("GREENWICH", 0.0);

    public String getPEString() {
        return "PRIMEM[\"" + this.getName() + "\"," + Utilities.radiansToDecimalDegrees(this.a) + "],UNIT[\"Degree\",0.0174532925199433]";
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new PrimeMeridian(geodeticRow);
    }

    public double getPrimeMeridian() {
        return this.a;
    }

    public PrimeMeridian(String string, double d2) {
        this.a = d2;
        this._name = new String(string);
    }

    public PrimeMeridian(GeodeticRow geodeticRow) throws InvalidRowDataException {
        super(geodeticRow, 0);
        if (geodeticRow.getLength() <= 4) {
            throw new InvalidRowDataException(geodeticRow);
        }
        try {
            Unit unit = (Unit)geodeticRow.getDatabase().getAngularUnitTable().getObject(geodeticRow.getColumn(3));
            this.a = unit.convertToMKS(geodeticRow.getColumn(4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidRowDataException(geodeticRow);
        }
    }

    PrimeMeridian() {
    }
}

