/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.cs.geom.RelativeCompare;

public class Polyconic
extends GenericProjection {
    private double e;
    private double a;
    private double b;
    private double c;
    private double d;

    public static void main(String[] stringArray) {
        Polyconic polyconic;
        Ellipsoid ellipsoid = new Ellipsoid(6378206.4, 0.00676866, true);
        try {
            polyconic = new Polyconic(ellipsoid, Utilities.decimalDegreesToRadians(-96.0), Utilities.decimalDegreesToRadians(30.0), 0.0, 0.0);
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return;
        }
        Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(40.0), 0.0);
        try {
            polyconic.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            polyconic.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        ellipsoid = new Ellipsoid(1.0, 0.0);
        try {
            polyconic = new Polyconic(ellipsoid, Utilities.decimalDegreesToRadians(-96.0), Utilities.decimalDegreesToRadians(30.0), 0.0, 0.0);
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return;
        }
        point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(40.0), 0.0);
        try {
            polyconic.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            polyconic.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        return;
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.angle180(point3D.x - this.c);
        if (Math.abs(point3D.y) < 1.0E-13) {
            point3D.x = this._ellipsoid.semiMajor() * d2;
            point3D.y = -this.e;
        } else {
            double d3 = d2 * Math.sin(point3D.y);
            double d4 = 1.0 / Math.tan(point3D.y);
            if (this._ellipsoid.isSphere()) {
                point3D.x = this._ellipsoid.getRadius() * d4 * Math.sin(d3);
                point3D.y = this._ellipsoid.getRadius() * (point3D.y - this.d + d4 * (1.0 - Math.cos(d3)));
            } else {
                double d5 = this._ellipsoid.radiusOfCurvatureN(point3D.y);
                point3D.x = d5 * d4 * Math.sin(d3);
                point3D.y = this._ellipsoid.meridianDistance(point3D.y) - this.e + d5 * d4 * (1.0 - Math.cos(d3));
            }
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.x -= this.b;
        point3D.y -= this.a;
        if (RelativeCompare.eq(point3D.y, -this.e)) {
            point3D.y = 0.0;
            point3D.x = point3D.x / this._ellipsoid.semiMajor() + this.c;
        } else {
            double d2 = (this.e + point3D.y) / this._ellipsoid.semiMajor();
            double d3 = d2 * d2 + point3D.x * point3D.x / (this._ellipsoid.semiMajor() * this._ellipsoid.semiMajor());
            double d4 = d2;
            if (this._ellipsoid.isSphere()) {
                double d5;
                double d6;
                while (Math.abs((d4 -= (d2 * (d4 * (d6 = Math.tan(d4)) + 1.0) - d4 - 0.5 * (d4 * d4 + d3) * d6) / ((d4 - d2) / d6 - 1.0)) - (d5 = d4)) > 1.0E-13) {
                }
                point3D.y = d4;
                point3D.x = Math.asin(point3D.x * Math.tan(d4) / this._ellipsoid.getRadius()) / Math.sin(d4) + this.c;
            } else {
                double d7;
                double d8;
                double d9;
                double d10;
                double d11;
                double d12;
                double d13 = this._ellipsoid.eccentricitySquared();
                do {
                    d7 = d4;
                    d11 = Math.sin(d4);
                    d9 = Math.sin(2.0 * d4);
                    double d14 = this._ellipsoid.meridianDistance(d4);
                    d8 = this._ellipsoid.meridianDistancePrime(d4);
                    d10 = d14 / this._ellipsoid.semiMajor();
                } while (Math.abs((d4 -= (d2 * ((d12 = Math.sqrt(1.0 - d13 * d11 * d11) * Math.tan(d4)) * d10 + 1.0) - d10 - 0.5 * (d10 * d10 + d3) * d12) / (d13 * d9 * (d10 * d10 + d3 - 2.0 * d2 * d10) / (4.0 * d12) + (d2 - d10) * (d12 * d8 - 2.0 / d9) - d8)) - d7) > 1.0E-13);
                d12 = Math.sqrt(1.0 - d13 * d11 * d11) * Math.tan(d4);
                point3D.y = d4;
                point3D.x = Math.asin(point3D.x * d12 / this._ellipsoid.semiMajor()) / Math.sin(d4) + this.c;
            }
        }
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        this.e = this._ellipsoid.isSphere() ? this._ellipsoid.getRadius() * this.d : this._ellipsoid.meridianDistance(this.d);
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Polyconic(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Polyconic polyconic = null;
        polyconic = (Polyconic)super.clone();
        polyconic.c = this.c;
        polyconic.d = this.d;
        polyconic.b = this.b;
        polyconic.a = this.a;
        try {
            polyconic.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return polyconic;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Polyconic(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.d);
        this.setValue(4, this.b);
        this.setValue(5, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.d = this.getValue(3);
        this.b = this.getValue(4);
        this.a = this.getValue(5);
        return;
    }

    public Polyconic(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public String getSchemaKey() {
        return "POLYCONIC";
    }

    public Polyconic(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    public Polyconic(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.d = d3;
        this.c = d2;
        this.b = d4;
        this.a = d5;
        this.init();
    }

    Polyconic() {
    }
}

