/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.cs.geod.ValidationMessageException;
import com.esri.mo.util.Resource;

public class PolarStereographic
extends GenericProjection {
    private boolean b;
    private double a;
    protected double _k0;
    protected double _lon0;
    protected double _latc;
    protected double _y0;
    protected double _x0;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (this._ellipsoid.isSphere()) {
            double d2;
            double d3 = 1.0;
            double d4 = 2.0 * this._ellipsoid.getRadius() * this._k0;
            if (this.b) {
                if (point3D.y > 0.0) {
                    point3D.y = 0.0;
                }
                d2 = 0.7853981633974483 + point3D.y / 2.0;
            } else {
                d3 = -1.0;
                if (point3D.y < 0.0) {
                    point3D.y = 0.0;
                }
                d2 = 0.7853981633974483 - point3D.y / 2.0;
            }
            if (Utilities.angleIsHalfPi(Math.abs(d2))) {
                point3D.x = 0.0;
                point3D.y = 0.0;
            } else {
                double d5 = Utilities.longitude180(point3D.x - this._lon0);
                point3D.x = (d4 *= Math.tan(d2)) * Math.sin(d5);
                point3D.y = d3 * d4 * Math.cos(d5);
            }
        } else {
            if (this.b) {
                if (point3D.y > 0.0) {
                    point3D.y = 0.0;
                }
                point3D.x = -point3D.x;
                point3D.y = -point3D.y;
            } else if (point3D.y < 0.0) {
                point3D.y = 0.0;
            }
            double d6 = Utilities.longitude180(point3D.x - this._lon0);
            double d7 = this.calcT(point3D.y);
            double d8 = this.a * d7;
            point3D.x = d8 * Math.sin(d6);
            point3D.y = -d8 * Math.cos(d6);
            if (this.b) {
                point3D.x = -point3D.x;
                point3D.y = -point3D.y;
            }
        }
        point3D.x += this._x0;
        point3D.y += this._y0;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this._y0;
        point3D.x -= this._x0;
        double d2 = Math.sqrt(point3D.x * point3D.x + point3D.y * point3D.y);
        if (this._ellipsoid.isSphere()) {
            double d3 = 2.0 * Math.atan2(d2, 2.0 * this._ellipsoid.getRadius() * this._k0);
            if (this.b) {
                if (Math.abs(d2) > 1.0E-13) {
                    point3D.x = this._lon0 + Math.atan2(point3D.x, point3D.y);
                    point3D.y = Math.asin(-Math.cos(d3));
                } else {
                    point3D.x = this._lon0;
                    point3D.y = this._latc;
                }
            } else if (Math.abs(d2) > 1.0E-13) {
                point3D.x = this._lon0 + Math.atan2(point3D.x, -point3D.y);
                point3D.y = Math.asin(Math.cos(d3));
            } else {
                point3D.x = this._lon0;
                point3D.y = this._latc;
            }
            point3D.x = Utilities.longitude180(point3D.x);
        } else {
            double d4;
            double d5;
            if (this.b) {
                point3D.x = -point3D.x;
                point3D.y = -point3D.y;
            }
            double d6 = d2 / this.a;
            point3D.x = Math.abs(d2) < 1.0E-13 ? this._lon0 : this._lon0 + Math.atan2(point3D.x, -point3D.y);
            if (point3D.x < Math.PI) {
                point3D.x += Math.PI * 2;
            } else if (point3D.x > Math.PI) {
                point3D.x -= Math.PI * 2;
            }
            double d7 = 1.5707963267948966 - 2.0 * Math.atan(d6);
            int n2 = 0;
            do {
                d4 = d7;
            } while (Math.abs((d7 = 1.5707963267948966 - 2.0 * Math.atan(d6 * Math.pow((1.0 - (d5 = this._ellipsoid.eccentricity() * Math.sin(d7))) / (1.0 + d5), this._ellipsoid.eccentricity() / 2.0))) - d4) > 1.0E-12 && ++n2 < 100);
            point3D.y = d7;
            if (this.b) {
                point3D.x = -point3D.x;
                point3D.y = -point3D.y;
            }
        }
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        if (this._k0 < 1.0E-12) {
            throw new ValidationMessageException(Resource.getBundleText("PSScaleFactor"));
        }
        if (this._latc < 0.0) {
            this.makeHorizon(this._lon0, -1.5707963267948966, 0.0);
            this.b = true;
        } else {
            this.b = false;
            this.makeHorizon(this._lon0, 0.0, 1.5707963267948966);
        }
        if (!this._ellipsoid.isSphere()) {
            if (this._latc < 0.0) {
                this._latc = -this._latc;
                this._lon0 = -this._lon0;
            }
            double d2 = this._ellipsoid.eccentricity();
            if (Math.abs(Math.abs(this._latc) - 1.5707963267948966) < 1.0E-13) {
                this.a = 2.0 * this._ellipsoid.semiMajor() * this._k0 / Math.sqrt(Math.pow(1.0 + d2, 1.0 + d2) * Math.pow(1.0 - d2, 1.0 - d2));
            } else {
                double d3 = this._ellipsoid.m(this._latc);
                double d4 = this.calcT(this._latc);
                this.a = d4 == 0.0 ? 0.0 : this._ellipsoid.semiMajor() * d3 / d4;
            }
        }
        return;
    }

    public PolarStereographic(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this._x0 = d5;
        this._y0 = d6;
        this._lon0 = d2;
        this._latc = d3;
        this._k0 = d4;
        this.init();
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this._lon0);
        this.setValue(3, this._latc);
        this.setValue(4, this._k0);
        this.setValue(5, this._x0);
        this.setValue(6, this._y0);
        return;
    }

    private void a() {
        this._lon0 = this.getValue(2);
        this._latc = this.getValue(3);
        this._k0 = this.getValue(4);
        this._x0 = this.getValue(5);
        this._y0 = this.getValue(6);
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        PolarStereographic polarStereographic = new PolarStereographic(this.getSchema(), geodeticRow, n2);
        return polarStereographic;
    }

    public Object clone() {
        PolarStereographic polarStereographic = null;
        polarStereographic = (PolarStereographic)super.clone();
        if (this.b) {
            polarStereographic._lon0 = -this._lon0;
            polarStereographic._latc = -this._latc;
        } else {
            polarStereographic._lon0 = this._lon0;
            polarStereographic._latc = this._latc;
        }
        polarStereographic._k0 = this._k0;
        polarStereographic._y0 = this._y0;
        polarStereographic._x0 = this._x0;
        try {
            polarStereographic.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return polarStereographic;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new PolarStereographic(unit, unit2, stringArray, n2, this.getSchema());
    }

    public PolarStereographic(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
    }

    protected PolarStereographic(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    public String getSchemaKey() {
        return "POLARSTEREO";
    }

    PolarStereographic() {
    }
}

