/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Orthographic
extends GenericProjection {
    private double c;
    private double f;
    private double d;
    private double e;
    private double a;
    private double b;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = point3D.x - this.d;
        double d3 = Math.sin(point3D.y);
        double d4 = Math.cos(point3D.y);
        double d5 = Math.cos(d2);
        double d6 = this.c * d3 + this.f * d4 * d5;
        point3D.x = this._ellipsoid.getRadius() * d4 * Math.sin(d2) + this.b;
        point3D.y = this._ellipsoid.getRadius() * (this.f * d3 - this.c * d4 * d5) + this.a;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        double d2 = Math.sqrt(point3D.x * point3D.x + point3D.y * point3D.y);
        if (Math.abs(d2) < 1.0E-13) {
            point3D.y = this.e;
            point3D.x = this.d;
        } else {
            double d3 = Math.asin(d2 / this._ellipsoid.getRadius());
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            point3D.x = this.d + Math.atan2(point3D.x * d5, d2 * this.f * d4 - point3D.y * this.c * d5);
            point3D.x = Utilities.angle180(point3D.x);
            point3D.y = Math.asin(d4 * this.c + point3D.y * d5 * this.f / d2);
        }
        return;
    }

    public void init() throws ValidationException {
        this.f = Math.cos(this.e);
        this.c = Math.sin(this.e);
        this.makeHorizon(this.d, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public Orthographic(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d4;
        this.a = d5;
        this.d = d2;
        this.e = d3;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Orthographic(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Orthographic orthographic = null;
        orthographic = (Orthographic)super.clone();
        orthographic.d = this.d;
        orthographic.e = this.e;
        orthographic.a = this.a;
        orthographic.b = this.b;
        try {
            orthographic.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return orthographic;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Orthographic(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.d);
        this.setValue(3, this.e);
        this.setValue(4, this.b);
        this.setValue(5, this.a);
        return;
    }

    private void a() {
        this.d = this.getValue(2);
        this.e = this.getValue(3);
        this.b = this.getValue(4);
        this.a = this.getValue(5);
        return;
    }

    public Orthographic(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Orthographic(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Orthographic() {
    }
}

