/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.HotineObliqueMercator;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class ObliqueMercator
extends HotineObliqueMercator {
    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2;
        double d3;
        double d4 = Utilities.angle180(point3D.x - this._lon0);
        double d5 = this.calcT(point3D.y);
        if (Math.abs(point3D.y - 1.5707963267948966) < 1.0E-13) {
            d3 = this._A / this._B * Math.log(Math.tan(0.7853981633974483 - Utilities.signum(point3D.y) * this._psi0 / 2.0));
            d2 = this._A * point3D.y / this._B;
        } else {
            double d6 = this._E / Math.pow(d5, this._B);
            double d7 = (d6 - 1.0 / d6) / 2.0;
            double d8 = (d6 + 1.0 / d6) / 2.0;
            double d9 = Math.sin(this._B * d4);
            double d10 = (-d9 * this._cospsi0 + d7 * this._sinpsi0) / d8;
            d3 = Math.abs(Math.abs(d10) - 1.0) < 1.0E-13 ? 1.0E30 : this._A * Math.log((1.0 - d10) / (1.0 + d10)) / (2.0 * this._B);
            double d11 = Math.cos(this._B * d4);
            d2 = Math.abs(d11) < 1.0E-13 ? this._A * this._B * d4 : this._A * Math.atan((d7 * this._cospsi0 + d9 * this._sinpsi0) / d11) / this._B;
        }
        point3D.x = d3 * this._cosrectskew + (d2 += this._uc * Utilities.signum(d4)) * this._sinrectskew + this._x0;
        point3D.y = d2 * this._cosrectskew - d3 * this._sinrectskew + this._y0;
        return;
    }

    protected double getUc() {
        return this._uc;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new ObliqueMercator(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        ObliqueMercator obliqueMercator = null;
        obliqueMercator = (ObliqueMercator)super.clone();
        return obliqueMercator;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new ObliqueMercator(unit, unit2, stringArray, n2, this.getSchema());
    }

    public ObliqueMercator(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
    }

    public ObliqueMercator(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
    }

    public ObliqueMercator(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7, double d8) throws ValidationException {
        super(ellipsoid, d2, d3, d4, d5, d6, d7, d8);
    }

    ObliqueMercator() {
    }
}

