/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.FormattedDocument;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.RangeValidationException;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class NumericField
extends JTextField {
    protected static DecimalFormat _eformat = new DecimalFormat("#.#####E0");
    protected double _maxValue = 1.0E30;
    protected double _minValue = -1.0E30;
    protected NumberFormat _format;

    public double validation() throws RangeValidationException, InvalidDataException {
        double d2;
        try {
            d2 = this._format.parse(this.getText()).doubleValue();
        }
        catch (Exception exception) {
            throw new InvalidDataException();
        }
        if (d2 < this._minValue || d2 > this._maxValue) {
            throw new RangeValidationException();
        }
        return d2;
    }

    public void setRange(double d2, double d3) {
        this._minValue = d2;
        this._maxValue = d3;
        return;
    }

    public void setValue(double d2) {
        if (d2 > 1.0E10 || d2 < -1.0E10) {
            this.setText(_eformat.format(d2));
        } else {
            this.setText(this._format.format(d2));
        }
        return;
    }

    public double getValue() {
        double d2 = 0.0;
        try {
            if (this.getText().equals("-")) {
                return 0.0;
            }
            d2 = this._format.parse(this.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            Toolkit.getDefaultToolkit().beep();
        }
        return d2;
    }

    public NumericField(double d2, int n2, NumberFormat numberFormat) {
        super(n2);
        ((JTextComponent)this).setDocument(new FormattedDocument(numberFormat));
        this._format = numberFormat;
        this.setValue(d2);
    }
}

