/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseDatumTransformation;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;

public class Molodensky
extends BaseDatumTransformation {
    private double a;
    private double b;
    private double c;

    public String getPEString() {
        return "METHOD[\"Molodensky\"],PARAMETER[\"X_Axis_Translation\"," + this.c + "],PARAMETER[\"Y_Axis_Translation\"," + this.b + "],PARAMETER[\"Z_Axis_Translation\"," + this.a + "]";
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Molodensky(geodeticRow, n2);
    }

    public Object clone() {
        Molodensky molodensky = null;
        molodensky = (Molodensky)super.clone();
        molodensky.c = this.c;
        molodensky.b = this.b;
        molodensky.a = this.a;
        return molodensky;
    }

    private void a(Point3D point3D, Ellipsoid ellipsoid, Ellipsoid ellipsoid2, double d2, double d3, double d4) {
        double d5 = ellipsoid.semiMajor();
        double d6 = 1.0 - ellipsoid.flattening();
        double d7 = ellipsoid2.semiMajor() - d5;
        double d8 = ellipsoid2.flattening() - ellipsoid.flattening();
        double d9 = ellipsoid.eccentricitySquared();
        double d10 = Math.sin(point3D.y);
        double d11 = Math.cos(point3D.y);
        double d12 = Math.sin(point3D.x);
        double d13 = Math.cos(point3D.x);
        double d14 = d10 * d10;
        double d15 = 1.0 - d9 * d14;
        double d16 = Math.sqrt(d15);
        double d17 = d5 / d16;
        double d18 = d5 * ((1.0 - d9) / (d15 * d16));
        double d19 = (d4 * d11 - d2 * d10 * d13 - d3 * d10 * d12 + d7 * (d17 * d9 * d10 * d11) / d5 + d8 * (d18 / d6 + d17 * d6) * d10 * d11) / (d18 + point3D.z);
        double d20 = (d3 * d13 - d2 * d12) / ((d17 + point3D.z) * d11);
        double d21 = d2 * d11 * d13 + d3 * d11 * d12 + d4 * d10 - d7 * d5 / d17 + d8 * d6 * d17 * d14;
        point3D.x += d20;
        point3D.y += d19;
        point3D.z += d21;
        return;
    }

    public void inverse(Point3D point3D) throws CalculationException {
        this.a(point3D, this._targetEllipsoid, this._sourceEllipsoid, -this.c, -this.b, -this.a);
        return;
    }

    public void forward(Point3D point3D) throws CalculationException {
        this.a(point3D, this._sourceEllipsoid, this._targetEllipsoid, this.c, this.b, this.a);
        return;
    }

    public Molodensky(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        if (geodeticRow.getLength() <= n2 + 2) {
            throw new InvalidRowDataException(geodeticRow);
        }
        try {
            this.c = Double.parseDouble(geodeticRow.getColumn(0 + n2));
            this.b = Double.parseDouble(geodeticRow.getColumn(1 + n2));
            this.a = Double.parseDouble(geodeticRow.getColumn(2 + n2));
        }
        catch (Exception exception) {
            throw new InvalidRowDataException(geodeticRow);
        }
    }

    Molodensky() {
    }
}

