/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Mollweide
extends GenericProjection {
    private double d;
    private double e;
    private double c;
    private double a;
    private double b;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2;
        double d3 = point3D.y;
        do {
            d2 = -(d3 + Math.sin(d3) - Math.PI * Math.sin(point3D.y)) / (1.0 + Math.cos(d3));
            d3 += d2;
        } while (Math.abs(d2) > 1.0E-13);
        point3D.x = this.d / Math.PI * Utilities.longitude180(point3D.x - this.c) * Math.cos(d3 /= 2.0) + this.b;
        point3D.y = this.e * Math.sin(d3) + this.a;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.x -= this.b;
        point3D.y -= this.a;
        double d2 = Math.asin(point3D.y / this.e);
        double d3 = d2 * 2.0;
        point3D.y = Math.asin((d3 + Math.sin(d3)) / Math.PI);
        point3D.x = this.c + Math.PI * point3D.x / (this.d * Math.cos(d2));
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        this.e = this._ellipsoid.getRadius() * Math.sqrt(2.0);
        this.d = this._ellipsoid.getRadius() * Math.sqrt(8.0);
        return;
    }

    public Mollweide(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d3;
        this.a = d4;
        this.c = d2;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Mollweide(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Mollweide mollweide = null;
        mollweide = (Mollweide)super.clone();
        mollweide.c = this.c;
        mollweide.a = this.a;
        mollweide.b = this.b;
        try {
            mollweide.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return mollweide;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Mollweide(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.b);
        this.setValue(4, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.b = this.getValue(3);
        this.a = this.getValue(4);
        return;
    }

    public Mollweide(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Mollweide(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    public String getSchemaKey() {
        return "MOLLWEIDE";
    }

    Mollweide() {
    }
}

