/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Mercator
extends GenericProjection {
    private double d;
    private double c;
    private double e;
    private double a;
    private double b;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (this._ellipsoid.isSphere()) {
            point3D.x = this._ellipsoid.getRadius() * Utilities.longitude180(point3D.x - this.c) * this.d + this.b;
            point3D.y = Math.abs(point3D.y) + 1.0E-13 >= 1.5707963267948966 ? Utilities.signum(point3D.y) * 1.0E30 : this.a + this.d * this._ellipsoid.getRadius() * Math.log(Math.tan(0.7853981633974483 + point3D.y / 2.0));
        } else {
            double d2 = this._ellipsoid.eccentricity() * Math.sin(point3D.y);
            point3D.x = this._ellipsoid.semiMajor() * Utilities.longitude180(point3D.x - this.c) * this.d + this.b;
            point3D.y = Math.abs(point3D.y) + 1.0E-13 >= 1.5707963267948966 ? Utilities.signum(point3D.y) * 1.0E30 : this.a + this.d * this._ellipsoid.semiMajor() * Math.log(Math.tan(0.7853981633974483 + point3D.y / 2.0) * Math.pow((1.0 - d2) / (1.0 + d2), this._ellipsoid.eccentricity() / 2.0));
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        point3D.y /= this.d;
        point3D.x /= this.d;
        double d2 = Math.exp(-point3D.y / this._ellipsoid.semiMajor());
        double d3 = 1.5707963267948966 - 2.0 * Math.atan(d2);
        if (!this._ellipsoid.isSphere()) {
            double d4;
            double d5;
            double d6 = this._ellipsoid.eccentricity() / 2.0;
            int n2 = 0;
            while (Math.abs((d5 = d3) - (d3 = 1.5707963267948966 - 2.0 * Math.atan(d2 * Math.pow((1.0 - (d4 = this._ellipsoid.eccentricity() * Math.sin(d3))) / (1.0 + d4), d6)))) > 1.0E-12 && ++n2 < 50) {
            }
        }
        point3D.y = d3;
        point3D.x = this.c + point3D.x / this._ellipsoid.semiMajor();
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        if (!this._ellipsoid.isSphere()) {
            double d2 = Math.sin(this.e) * this._ellipsoid.eccentricitySquared();
            this.d = Math.cos(this.e) / Math.sqrt(1.0 - d2 * d2);
        } else {
            this.d = Math.cos(this.e);
        }
        this.makeHorizon(this.c, -1.5707963167948966, 1.5707963167948966);
        return;
    }

    public Mercator(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d4;
        this.a = d5;
        this.c = d2;
        this.e = d3;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Mercator(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Mercator mercator = null;
        mercator = (Mercator)super.clone();
        mercator.c = this.c;
        mercator.e = this.e;
        mercator.a = this.a;
        mercator.b = this.b;
        try {
            mercator.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return mercator;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Mercator(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.e);
        this.setValue(4, this.b);
        this.setValue(5, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.e = this.getValue(3);
        this.b = this.getValue(4);
        this.a = this.getValue(5);
        return;
    }

    public Mercator(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Mercator(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Mercator() {
    }
}

