/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.axl.client.csg3CatchImpl;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Loximuthal
extends GenericProjection {
    private double d;
    private double c;
    private double a;
    private double b;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            Loximuthal loximuthal = new Loximuthal(new Ellipsoid(1.0, 0.0), Utilities.decimalDegreesToRadians(-90.0), Utilities.decimalDegreesToRadians(-10.0), 0.0, 0.0);
            Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(-50.0), 0.0);
            loximuthal.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            loximuthal.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
            return;
        }
        catch (Exception exception) {
            // empty catch block
            return;
        }
        catch (csg3CatchImpl csg3CatchImpl2) {
            throw csg3CatchImpl2;
        }
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.longitude180(point3D.x - this.c);
        if (Utilities.angleIsZero(this.d - point3D.y)) {
            point3D.x = this._ellipsoid.getRadius() * d2 * Math.cos(this.d);
            point3D.y = 0.0;
        } else {
            if (Utilities.angleIsHalfPi(Math.abs(point3D.y))) {
                point3D.y -= Utilities.signum(point3D.y) * 1.0E-12;
            }
            point3D.x = this.b + this._ellipsoid.getRadius() * d2 * (point3D.y - this.d) / Math.log(Math.tan(0.7853981633974483 + point3D.y / 2.0) / Math.tan(0.7853981633974483 + this.d / 2.0));
            point3D.y = this.a + this._ellipsoid.getRadius() * (point3D.y - this.d);
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        double d2;
        point3D.y -= this.a;
        point3D.x -= this.b;
        if (Utilities.angleIsZero(point3D.y)) {
            point3D.y = this.d;
            d2 = point3D.x / (Math.cos(this.d) * this._ellipsoid.getRadius());
        } else {
            point3D.y = point3D.y / this._ellipsoid.getRadius() + this.d;
            d2 = point3D.x / ((point3D.y - this.d) * this._ellipsoid.getRadius()) * Math.log(Math.tan(0.7853981633974483 + point3D.y / 2.0) / Math.tan(0.7853981633974483 + this.d / 2.0));
        }
        point3D.x = Utilities.longitude180(this.c + d2);
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public Loximuthal(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d4;
        this.a = d5;
        this.c = d2;
        this.d = d3;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Loximuthal(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Loximuthal loximuthal = null;
        loximuthal = (Loximuthal)super.clone();
        loximuthal.c = this.c;
        loximuthal.d = this.d;
        loximuthal.a = this.a;
        loximuthal.b = this.b;
        try {
            loximuthal.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return loximuthal;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Loximuthal(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.d);
        this.setValue(4, this.b);
        this.setValue(5, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.d = this.getValue(3);
        this.b = this.getValue(4);
        this.a = this.getValue(5);
        return;
    }

    public Loximuthal(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Loximuthal(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Loximuthal() {
    }
}

