/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.FactorBasedUnit;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Unit;

public class LinearUnit
extends FactorBasedUnit
implements Unit {
    public static final LinearUnit METERS = new LinearUnit("METERS", "m", 3, 1.0);

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new LinearUnit(geodeticRow, n2);
    }

    public LinearUnit(String string, String string2, int n2, double d2) {
        super(string, string2, n2, d2);
    }

    public LinearUnit(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(geodeticRow, n2);
        if (geodeticRow.getLength() <= 5) {
            throw new InvalidRowDataException(geodeticRow);
        }
        try {
            this._suffix = geodeticRow.getColumn(3);
            this._toMKS = Double.parseDouble(geodeticRow.getColumn(4));
            this._precision = Integer.parseInt(geodeticRow.getColumn(5));
        }
        catch (Exception exception) {
            throw new InvalidRowDataException(geodeticRow);
        }
    }

    LinearUnit() {
    }
}

