/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.NumericField;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.util.Resource;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LatLonZPanel
extends JPanel {
    boolean g;
    JLabel a;
    JLabel b;
    JLabel c;
    NumericField d;
    NumericField e;
    NumericField f;

    public void setPoint(Unit unit, Point3D point3D, boolean bl) {
        Point3D point3D2 = new Point3D(point3D);
        if (bl) {
            point3D2.y = unit.convertFromMKS(point3D2.y);
            point3D2.x = unit.convertFromMKS(point3D2.x);
            if (!this.g) {
                point3D2.z = unit.convertFromMKS(point3D2.z);
            }
        }
        this.f.setValue(point3D2.y);
        this.e.setValue(point3D2.x);
        this.d.setValue(point3D2.z);
        return;
    }

    public void setLatLonDisplay(boolean bl) {
        if (bl) {
            this.c.setText(Resource.getBundleText("LLZPLat") + " ");
            this.b.setText(Resource.getBundleText("LLZPLon") + " ");
            this.a.setText(Resource.getBundleText("LLZPElevM") + " ");
            this.g = true;
        } else {
            this.c.setText(Resource.getBundleText("LLZPNorth") + " ");
            this.b.setText(Resource.getBundleText("LLZPEast") + " ");
            this.a.setText(Resource.getBundleText("LLZPElev") + " ");
            this.g = false;
        }
        return;
    }

    public LatLonZPanel(boolean bl) {
        LatLonZPanel latLonZPanel = this;
        latLonZPanel.setLayout(new FlowLayout());
        this.c = new JLabel(Resource.getBundleText("LLZPNorth") + " ", 4);
        this.b = new JLabel(Resource.getBundleText("LLZPEast") + " ", 4);
        this.a = new JLabel(Resource.getBundleText("LLZPElev") + " ", 4);
        this.setLatLonDisplay(bl);
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(12);
        decimalFormat.setMinimumFractionDigits(1);
        decimalFormat.setMaximumIntegerDigits(12);
        decimalFormat.setMinimumIntegerDigits(1);
        ((NumberFormat)decimalFormat).setGroupingUsed(false);
        this.f = new NumericField(0.0, 16, decimalFormat);
        this.e = new NumericField(0.0, 16, decimalFormat);
        this.d = new NumericField(0.0, 16, decimalFormat);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1, 0, 5));
        jPanel.add(this.c);
        this.c.setLabelFor(this.f);
        jPanel2.add(this.f);
        jPanel.add(this.b);
        this.b.setLabelFor(this.e);
        jPanel2.add(this.e);
        jPanel.add(this.a);
        this.a.setLabelFor(this.d);
        jPanel2.add(this.d);
        latLonZPanel.add(jPanel);
        latLonZPanel.add(jPanel2);
        this.setVisible(true);
    }

    public Point3D getPoint(Unit unit, boolean bl) throws ValidationException {
        Point3D point3D = new Point3D();
        point3D.x = this.e.getValue();
        point3D.y = this.f.getValue();
        point3D.z = this.d.getValue();
        System.out.println(point3D.x + ", " + point3D.y);
        Point3D point3D2 = new Point3D(point3D);
        point3D.x = unit.convertToMKS(point3D.x);
        point3D.y = unit.convertToMKS(point3D.y);
        System.out.println(point3D.x + ", " + point3D.y);
        if (this.g) {
            Utilities.validateLatitude(point3D.y);
            Utilities.validateLongitude(point3D.x);
        } else {
            point3D.z = unit.convertToMKS(point3D.z);
        }
        if (bl) {
            return point3D;
        }
        return point3D2;
    }
}

