/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.EnvelopeHorizon;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.ValidationException;

public class LatLonProjection
extends GenericProjection {
    public void fromGeographic(Point3D point3D) throws CalculationException {
        point3D.x = this._linearUnit.convertFromMKS(point3D.x);
        point3D.y = this._linearUnit.convertFromMKS(point3D.y);
        return;
    }

    public void init() throws ValidationException {
        this._horizon = new EnvelopeHorizon(-Math.PI, Math.PI, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        try {
            point3D.x = this._linearUnit.convertToMKS(point3D.x);
            point3D.y = this._linearUnit.convertToMKS(point3D.y);
        }
        catch (ValidationException validationException) {
            throw new CalculationException();
        }
        return;
    }

    public LatLonProjection(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new LatLonProjection(unit, unit2, stringArray, n2, this.getSchema());
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new LatLonProjection(this.getSchema(), geodeticRow, n2);
    }

    public LatLonProjection(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        try {
            this.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public LatLonProjection(Ellipsoid ellipsoid, Unit unit) {
        this._angleUnit = unit;
        this._linearUnit = unit;
        this._ellipsoid = ellipsoid;
        try {
            this.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    LatLonProjection() {
        try {
            this.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public boolean isLatitudeLongitude() {
        return true;
    }
}

