/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class LambertTwoParallels
extends GenericProjection {
    private double c;
    private double d;
    private double e;
    private double a;
    private double b;
    protected double _k0;
    protected double _y0;
    protected double _x0;
    protected double _lat0;
    protected double _lat1;
    protected double _lat2;
    protected double _lon0;

    public static void main(String[] stringArray) {
        LambertTwoParallels lambertTwoParallels;
        Ellipsoid ellipsoid = new Ellipsoid(6378206.4, 0.00676866, true);
        try {
            lambertTwoParallels = new LambertTwoParallels(ellipsoid, Utilities.decimalDegreesToRadians(-96.0), Utilities.decimalDegreesToRadians(-23.0), Utilities.decimalDegreesToRadians(-45.0), Utilities.decimalDegreesToRadians(-33.0), 0.0, 0.0);
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return;
        }
        Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(-35.0), 0.0);
        try {
            lambertTwoParallels.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            lambertTwoParallels.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        ellipsoid = new Ellipsoid(1.0, 0.0);
        try {
            lambertTwoParallels = new LambertTwoParallels(ellipsoid, Utilities.decimalDegreesToRadians(-96.0), Utilities.decimalDegreesToRadians(-23.0), Utilities.decimalDegreesToRadians(-45.0), Utilities.decimalDegreesToRadians(-33.0), 0.0, 0.0);
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return;
        }
        point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(-35.0), 0.0);
        try {
            lambertTwoParallels.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            lambertTwoParallels.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        return;
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = !this._ellipsoid.isSphere() ? this.calcT(point3D.y) : 1.0 / Math.tan(0.7853981633974483 + point3D.y / 2.0);
        double d3 = this._ellipsoid.semiMajor() * this.e * Math.pow(d2, this.b);
        double d4 = this.b * Utilities.longitude180(point3D.x - this._lon0);
        point3D.x = this._k0 * d3 * Math.sin(d4) + this._x0;
        point3D.y = this._k0 * (this.a - d3 * Math.cos(d4)) + this._y0;
        return;
    }

    private double a(double d2) {
        double d3 = this.d * Math.sin(d2);
        return Math.cos(d2) / Math.sqrt(1.0 - d3 * d3);
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        double d2;
        point3D.x = (point3D.x - this._x0) / this._k0;
        point3D.y = (point3D.y - this._y0) / this._k0;
        double d3 = this.a - point3D.y;
        double d4 = Utilities.signum(this.b) * Math.sqrt(point3D.x * point3D.x + d3 * d3);
        double d5 = Math.pow(d4 / (this._ellipsoid.semiMajor() * this.e), 1.0 / this.b);
        double d6 = 1.5707963267948966 - 2.0 * Math.atan(d5);
        if (!this._ellipsoid.isSphere()) {
            double d7;
            double d8;
            int n2 = 0;
            do {
                d2 = d6;
            } while (Math.abs((d6 = 1.5707963267948966 - 2.0 * Math.atan(d5 * (d8 = Math.pow((1.0 - (d7 = this.d * Math.sin(d6))) / (1.0 + d7), this.c)))) - d2) > 1.0E-13 && ++n2 < 100);
        }
        d2 = this.b >= 0.0 ? Utilities.atan2(point3D.x, this.a - point3D.y) : Utilities.atan2(-point3D.x, -this.a + point3D.y);
        point3D.y = d6;
        point3D.x = d2 / this.b + this._lon0;
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        if (this._ellipsoid.isSphere()) {
            this.b = Math.log(Math.cos(this._lat1) / Math.cos(this._lat2)) / Math.log(Math.tan(0.7853981633974483 + this._lat2 / 2.0) / Math.tan(0.7853981633974483 + this._lat1 / 2.0));
            this.e = Math.cos(this._lat1) * Math.pow(Math.tan(0.7853981633974483 + this._lat1 / 2.0), this.b) / this.b;
            this.a = this._ellipsoid.getRadius() * this.e / Math.pow(Math.tan(0.7853981633974483 + this._lat0 / 2.0), this.b);
            if (this.b < 0.0) {
                this.makeHorizon(this._lon0, -1.5707963267948966, 1.0471975511965979);
            } else {
                this.makeHorizon(this._lon0, -1.0471975511965979, 1.5707963267948966);
            }
        } else {
            this.d = this._ellipsoid.eccentricity();
            this.c = this.d / 2.0;
            double d2 = this.a(this._lat0);
            double d3 = this.calcT(this._lat0);
            double d4 = this.a(this._lat1);
            double d5 = this.calcT(this._lat1);
            double d6 = this.a(this._lat2);
            double d7 = this.calcT(this._lat2);
            this.b = this._lat1 == this._lat2 ? Math.sin(this._lat1) : (Math.log(d4) - Math.log(d6)) / (Math.log(d5) - Math.log(d7));
            this.e = d4 / (this.b * Math.pow(d5, this.b));
            this.a = this._ellipsoid.semiMajor() * this.e * Math.pow(d3, this.b);
            if (this.b < 0.0) {
                this.makeHorizon(this._lon0, -1.5707963267948966, 1.0471975511965979);
            } else {
                this.makeHorizon(this._lon0, -1.0471975511965979, 1.5707963267948966);
            }
        }
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new LambertTwoParallels(this.getSchema(), geodeticRow, n2, false);
    }

    public Object clone() {
        LambertTwoParallels lambertTwoParallels = null;
        lambertTwoParallels = (LambertTwoParallels)super.clone();
        lambertTwoParallels._lon0 = this._lon0;
        lambertTwoParallels._lat1 = this._lat1;
        lambertTwoParallels._lat2 = this._lat2;
        lambertTwoParallels._lat0 = this._lat0;
        lambertTwoParallels._x0 = this._x0;
        lambertTwoParallels._y0 = this._y0;
        lambertTwoParallels._k0 = this._k0;
        try {
            lambertTwoParallels.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return lambertTwoParallels;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new LambertTwoParallels(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this._lon0);
        this.setValue(3, this._lat0);
        this.setValue(4, this._lat1);
        this.setValue(5, this._lat2);
        this.setValue(6, this._x0);
        this.setValue(7, this._y0);
        return;
    }

    private void a() {
        this._lon0 = this.getValue(2);
        this._lat0 = this.getValue(3);
        this._lat1 = this.getValue(4);
        this._lat2 = this.getValue(5);
        this._x0 = this.getValue(6);
        this._y0 = this.getValue(7);
        this._k0 = 1.0;
        return;
    }

    public LambertTwoParallels(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public LambertTwoParallels(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2, boolean bl) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        if (!bl) {
            this.a();
        }
    }

    public LambertTwoParallels(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this._lat1 = d4;
        this._lat2 = d5;
        this._lat0 = d3;
        this._lon0 = d2;
        this._x0 = d6;
        this._y0 = d7;
        this._k0 = 1.0;
        this.init();
    }

    LambertTwoParallels() {
    }
}

