/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.LambertTwoParallels;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.cs.geod.ValidationMessageException;
import com.esri.mo.util.Resource;

public class LambertOneParallel
extends LambertTwoParallels {
    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new LambertOneParallel(this.getSchema(), geodeticRow, n2);
    }

    public void init() throws ValidationException {
        super.init();
        if (Utilities.angleIsZero(this._lat0)) {
            throw new ValidationMessageException(Resource.getBundleText("LOPStandardParallel"));
        }
        if (this._k0 < 1.0E-12) {
            throw new ValidationMessageException(Resource.getBundleText("LOPScaleFactor"));
        }
        return;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new LambertOneParallel(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this._lon0);
        this.setValue(3, this._lat0);
        this.setValue(4, this._k0);
        this.setValue(5, this._x0);
        this.setValue(6, this._y0);
        return;
    }

    private void a() {
        this._lon0 = this.getValue(2);
        this._lat0 = this.getValue(3);
        this._k0 = this.getValue(4);
        this._x0 = this.getValue(5);
        this._y0 = this.getValue(6);
        this._lat1 = this._lat0;
        this._lat2 = this._lat0;
        return;
    }

    public LambertOneParallel(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public LambertOneParallel(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2, true);
        this.a();
    }

    public LambertOneParallel(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6) throws ValidationException {
        super(ellipsoid, d2, d3, d3, d3, d5, d6);
        this._k0 = d4;
    }

    LambertOneParallel() {
    }
}

