/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.cs.geom.RelativeCompare;

public class LambertAzimuthalEqualArea
extends GenericProjection {
    private double i;
    private double c;
    private double g;
    private double h;
    private double d;
    private double f;
    private double e;
    private double a;
    private double b;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Math.asin(this._ellipsoid.calcQ(point3D.y) / this.d);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = point3D.x - this.e;
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        double d8 = this.h * Math.sqrt(2.0 / (1.0 + this.c * d4 + this.g * d3 * d6));
        point3D.x = this.b + d8 * this.i * d3 * d7;
        point3D.y = this.a + d8 / this.i * (this.g * d4 - this.c * d3 * d6);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        double d2 = point3D.x / this.i;
        double d3 = point3D.y * this.i;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = 2.0 * Math.asin(d4 / (2.0 * this.h));
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        double d8 = this.d * (d6 * this.c + d3 * d7 * this.g / d4);
        double d9 = this._ellipsoid.eccentricity();
        double d10 = this._ellipsoid.eccentricitySquared();
        double d11 = 1.0 - (1.0 - d10) / (2.0 * d9) * Math.log((1.0 - d9) / (1.0 + d9));
        if (RelativeCompare.eq(Utilities.signum(d8) * Math.abs(d11), d8)) {
            point3D.y = Utilities.signum(d8) * 1.5707963267948966;
        } else {
            double d12;
            double d13;
            double d14;
            double d15;
            double d16;
            double d17 = Math.asin(d8 / 2.0);
            do {
                d12 = d17;
                d13 = Math.cos(d17);
                d14 = Math.sin(d17);
            } while (Math.abs((d17 += (d16 = 1.0 - (d15 = this._ellipsoid.eccentricity() * d14) * d15) * d16 / (2.0 * d13) * (d8 / (1.0 - this._ellipsoid.eccentricitySquared()) - d14 / d16 + 1.0 / (2.0 * this._ellipsoid.eccentricity()) * Math.log((1.0 - d15) / (1.0 + d15)))) - d12) > 1.0E-12);
            point3D.y = d17;
        }
        point3D.x = this.e + Math.atan(point3D.x * d7 / (this.i * d4 * this.g * d6 - d3 * this.i * this.c * d7));
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        this.makeHorizon(this.e, -1.5707963267948966, 1.5707963267948966);
        double d2 = this._ellipsoid.semiMajor();
        this.d = this._ellipsoid.calcQ(1.5707963267948966);
        this.h = d2 * Math.sqrt(this.d / 2.0);
        double d3 = Math.asin(this._ellipsoid.calcQ(this.f) / this.d);
        this.g = Math.cos(d3);
        this.c = Math.sin(d3);
        this.i = d2 * this._ellipsoid.m(this.f) / (this.h * this.g);
        return;
    }

    public LambertAzimuthalEqualArea(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d4;
        this.a = d5;
        this.e = d2;
        this.f = d3;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new LambertAzimuthalEqualArea(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        LambertAzimuthalEqualArea lambertAzimuthalEqualArea = null;
        lambertAzimuthalEqualArea = (LambertAzimuthalEqualArea)super.clone();
        lambertAzimuthalEqualArea.e = this.e;
        lambertAzimuthalEqualArea.f = this.f;
        lambertAzimuthalEqualArea.a = this.a;
        lambertAzimuthalEqualArea.b = this.b;
        try {
            lambertAzimuthalEqualArea.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return lambertAzimuthalEqualArea;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new LambertAzimuthalEqualArea(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.e);
        this.setValue(3, this.f);
        this.setValue(4, this.b);
        this.setValue(5, this.a);
        return;
    }

    private void a() {
        this.e = this.getValue(2);
        this.f = this.getValue(3);
        this.b = this.getValue(4);
        this.a = this.getValue(5);
        return;
    }

    public LambertAzimuthalEqualArea(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public LambertAzimuthalEqualArea(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    LambertAzimuthalEqualArea() {
    }
}

