/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.cs.geom.RelativeCompare;

public class IMWPolyconic
extends GenericProjection {
    private boolean j;
    private boolean i;
    private double c;
    private double d;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double k;
    private double l;
    private double a;
    private double b;
    private double e;
    private double f;
    private double g;
    private double h;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = point3D.x - this.f;
        double d7 = this._ellipsoid.meridianDistance(point3D.y);
        double d8 = this.o + this.m * d7;
        double d9 = this.p + this.n * d7;
        double d10 = this._ellipsoid.radiusOfCurvatureN(point3D.y) / Math.tan(point3D.y);
        double d11 = d9 - d10 + Utilities.signum(point3D.y) * Math.sqrt(d10 * d10 - d8 * d8);
        if (this.i) {
            d5 = this._ellipsoid.semiMajor() * d6;
            d4 = this.q;
        } else {
            d5 = this.k * Math.sin(d6 * this.c);
            d4 = this.q + this.k * (1.0 - Math.cos(d6 * this.c));
        }
        if (this.j) {
            d3 = this._ellipsoid.semiMajor() * d6;
            d2 = 0.0;
        } else {
            d3 = this.l * Math.sin(d6 * this.d);
            d2 = this.l * (1.0 - Math.cos(d6 * this.d));
        }
        double d12 = (d5 - d3) / (d4 - d2);
        double d13 = d3 + d12 * (d11 + d10 - d2);
        if (Utilities.angleIsZero(point3D.y)) {
            point3D.x = this._ellipsoid.semiMajor() * (point3D.y - this.f);
            point3D.y = d11;
        } else {
            double d14 = d12 * d12;
            double d15 = d10 * d10;
            point3D.x = (d13 - Utilities.signum(point3D.y) * d12 * Math.sqrt(d15 * (1.0 + d14) - d13 * d13)) / (1.0 + d14);
            point3D.y = d11 + d10 - Utilities.signum(point3D.y) * Math.sqrt(d15 - point3D.x * point3D.x);
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        double d2;
        double d3;
        double d4;
        point3D.x -= this.b;
        point3D.y -= this.a;
        double d5 = point3D.x;
        double d6 = point3D.y;
        double d7 = this.g;
        point3D.x = d4 = point3D.x / (this._ellipsoid.semiMajor() * Math.cos(d7)) + this.f;
        point3D.y = d7;
        double d8 = point3D.x - this.f;
        this.fromGeographic(point3D);
        int n2 = 0;
        do {
            double d9;
            double d10;
            d3 = point3D.x;
            d2 = point3D.y;
            if (this.j) {
                d10 = this._ellipsoid.semiMajor() * d8;
                d9 = 0.0;
            } else {
                d10 = this.l * Math.sin(d8 * this.d);
                d9 = this.l * (1.0 - Math.cos(d8 * this.d));
            }
            d7 = RelativeCompare.eq(point3D.y, d9) ? this.h : (d7 - this.h) * (d6 - d9) / (point3D.y - d9) + this.h;
            d4 = RelativeCompare.eq(point3D.x, 0.0) ? this.f : (d4 - this.f) * d5 / point3D.x + this.f;
            point3D.x = d4;
            point3D.y = d7;
            d8 = point3D.x - this.f;
            this.fromGeographic(point3D);
        } while (RelativeCompare.ne(d3, point3D.x, 1.0E-14) || RelativeCompare.ne(d2, point3D.y, 1.0E-14) || ++n2 > 100);
        point3D.x = d4;
        point3D.y = d7;
        return;
    }

    public void init() throws ValidationException {
        double d2;
        double d3;
        double d4;
        double d5;
        if (this._ellipsoid == null) {
            return;
        }
        this.makeHorizon(this.f, -1.5707963267948966, 1.5707963267948966);
        double d6 = this.e - this.f;
        double d7 = d6 * Math.sin(this.h);
        double d8 = d6 * Math.sin(this.g);
        if (Utilities.angleIsZero(this.g)) {
            this.i = true;
            d5 = this._ellipsoid.semiMajor() * d6;
            d4 = 0.0;
        } else {
            this.i = false;
            this.k = this._ellipsoid.radiusOfCurvatureN(this.g) / Math.tan(this.g);
            d5 = this.k * Math.sin(d8);
            d4 = this.k * (1.0 - Math.cos(d8));
        }
        if (Utilities.angleIsZero(this.h)) {
            this.j = true;
            d3 = this._ellipsoid.semiMajor() * d6;
            d2 = 0.0;
        } else {
            this.j = false;
            this.l = this._ellipsoid.radiusOfCurvatureN(this.h) / Math.tan(this.h);
            d3 = this.l * Math.sin(d7);
            d2 = this.l * (1.0 - Math.cos(d7));
        }
        double d9 = this._ellipsoid.meridianDistance(this.h);
        double d10 = this._ellipsoid.meridianDistance(this.g);
        double d11 = d5 - d3;
        double d12 = d10 - d9;
        double d13 = Math.sqrt(d12 * d12 - d11 * d11) + d2;
        this.q = d13 - d4;
        this.m = (d5 - d3) / (d10 - d9);
        this.o = (d10 * d3 - d9 * d5) / (d10 - d9);
        this.n = (d13 - d2) / (d10 - d9);
        this.p = (d10 * d2 - d9 * d13) / (d10 - d9);
        this.c = Math.sin(this.g);
        this.d = Math.sin(this.h);
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new IMWPolyconic(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        IMWPolyconic iMWPolyconic = null;
        iMWPolyconic = (IMWPolyconic)super.clone();
        iMWPolyconic.f = this.f;
        iMWPolyconic.e = this.e;
        iMWPolyconic.h = this.h;
        iMWPolyconic.g = this.g;
        iMWPolyconic.b = this.b;
        iMWPolyconic.a = this.a;
        try {
            iMWPolyconic.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return iMWPolyconic;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new IMWPolyconic(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.f);
        this.setValue(3, this.e);
        this.setValue(4, this.h);
        this.setValue(5, this.g);
        this.setValue(6, this.b);
        this.setValue(7, this.a);
        return;
    }

    private void a() {
        this.f = this.getValue(2);
        this.e = this.getValue(3);
        this.h = this.getValue(4);
        this.g = this.getValue(5);
        this.b = this.getValue(6);
        this.a = this.getValue(7);
        return;
    }

    public IMWPolyconic(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public IMWPolyconic(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    public IMWPolyconic(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.h = d4;
        this.g = d5;
        this.f = d2;
        this.e = d3;
        this.b = d6;
        this.a = d7;
        this.init();
    }

    IMWPolyconic() {
    }
}

