/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class HotineObliqueMercator
extends GenericProjection {
    protected double _sinrectskew;
    protected double _cosrectskew;
    protected double _uc;
    protected double _sinazc;
    protected double _cosazc;
    protected double _sinpsi0;
    protected double _cospsi0;
    protected double _E;
    protected double _B;
    protected double _A;
    protected double _lon0;
    protected double _psi0;
    protected double _rectskew;
    protected double _azc;
    protected double _k0;
    protected double _y0;
    protected double _x0;
    protected double _lat0;
    protected double _lonc;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2;
        double d3;
        double d4 = Utilities.angle180(point3D.x - this._lon0);
        double d5 = this.calcT(point3D.y);
        if (Math.abs(point3D.y - 1.5707963267948966) < 1.0E-13) {
            d3 = this._A / this._B * Math.log(Math.tan(0.7853981633974483 - Utilities.signum(point3D.y) * this._psi0 / 2.0));
            d2 = this._A * point3D.y / this._B;
        } else {
            double d6 = this._E / Math.pow(d5, this._B);
            double d7 = (d6 - 1.0 / d6) / 2.0;
            double d8 = (d6 + 1.0 / d6) / 2.0;
            double d9 = Math.sin(this._B * d4);
            double d10 = (-d9 * this._cospsi0 + d7 * this._sinpsi0) / d8;
            d3 = Math.abs(Math.abs(d10) - 1.0) < 1.0E-13 ? 1.0E30 : this._A * Math.log((1.0 - d10) / (1.0 + d10)) / (2.0 * this._B);
            double d11 = Math.cos(this._B * d4);
            d2 = Math.abs(d11) < 1.0E-13 ? this._A * this._B * d4 : this._A * Math.atan((d7 * this._cospsi0 + d9 * this._sinpsi0) / d11) / this._B;
        }
        point3D.x = d3 * this._cosrectskew + d2 * this._sinrectskew + this._x0;
        point3D.y = d2 * this._cosrectskew - d3 * this._sinrectskew + this._y0;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        double d2 = point3D.x - this._x0;
        double d3 = point3D.y - this._y0;
        double d4 = d2 * this._cosrectskew - d3 * this._sinrectskew;
        double d5 = d3 * this._cosrectskew + d2 * this._sinrectskew + this.getUc();
        double d6 = Math.exp(-this._B * d4 / this._A);
        double d7 = (d6 - 1.0 / d6) / 2.0;
        double d8 = (d6 + 1.0 / d6) / 2.0;
        double d9 = Math.sin(this._B * d5 / this._A);
        double d10 = (d9 * this._cospsi0 + d7 * this._sinpsi0) / d8;
        if (Math.abs(Math.abs(d10) - 1.0) < 1.0E-13) {
            point3D.y = Utilities.signum(d10) * 1.5707963267948966;
            point3D.x = this._lon0;
        } else {
            double d11;
            double d12 = Math.pow(this._E / Math.sqrt((1.0 + d10) / (1.0 - d10)), 1.0 / this._B);
            double d13 = this._ellipsoid.eccentricity() / 2.0;
            double d14 = this._ellipsoid.eccentricity() * Math.sin(point3D.y);
            double d15 = 1.5707963267948966 - 2.0 * Math.atan(d12 * Math.pow((1.0 - d14) / (1.0 + d14), d13));
            double d16 = this._B / this._A;
            while (Math.abs((d11 = d15) - (d15 = 1.5707963267948966 - 2.0 * Math.atan(d12 * Math.pow((1.0 - (d14 = this._ellipsoid.eccentricity() * Math.sin(d15))) / (1.0 + d14), d13)))) > 1.0E-12) {
            }
            point3D.x = this._lon0 - Math.atan((d7 * this._cospsi0 - d9 * this._sinpsi0) / Math.cos(d5 * d16)) / this._B;
            point3D.y = d15;
        }
        return;
    }

    protected double getUc() {
        return 0.0;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        this.makeHorizon(this._lonc - 1.0471975511965976, this._lonc + 1.0471975511965976, -0.5235987755982989, 1.5707963267948966);
        double d2 = Math.cos(this._lat0);
        double d3 = d2 * d2;
        double d4 = d3 * d3;
        double d5 = this._ellipsoid.eccentricitySquared();
        this._B = Math.sqrt(1.0 + d5 * d4 / (1.0 - d5));
        double d6 = this._ellipsoid.eccentricity() * Math.sin(this._lat0);
        double d7 = d6 * d6;
        this._A = this._ellipsoid.semiMajor() * this._B * this._k0 * Math.sqrt(1.0 - d5) / (1.0 - d7);
        double d8 = this.calcT(this._lat0);
        double d9 = this._B * Math.sqrt(1.0 - d5) / (d2 * Math.sqrt(1.0 - d7));
        if (d9 * d9 < 1.0) {
            d9 = 1.0;
        }
        double d10 = d9 + Utilities.signum(this._lat0) * Math.sqrt(d9 * d9 - 1.0);
        this._E = d10 * Math.pow(d8, this._B);
        double d11 = (d10 - 1.0 / d10) / 2.0;
        this._psi0 = Math.asin(Math.sin(this._azc) / d9);
        this._lon0 = this._lonc - Math.asin(d11 * Math.tan(this._psi0)) / this._B;
        this._cospsi0 = Math.cos(this._psi0);
        this._sinpsi0 = Math.sin(this._psi0);
        this._cosazc = Math.cos(this._azc);
        this._sinazc = Math.sin(this._azc);
        this._cosrectskew = Math.cos(this._rectskew);
        this._sinrectskew = Math.sin(this._rectskew);
        this._uc = Utilities.angleIsZero(Math.abs(this._lat0) - 1.5707963267948966) ? this._A * (this._lonc - this._lon0) : this._A / this._B * Math.atan(Math.sqrt(d9 * d9 - 1.0) / this._cosazc) * Utilities.signum(this._lat0);
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new HotineObliqueMercator(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        HotineObliqueMercator hotineObliqueMercator = null;
        hotineObliqueMercator = (HotineObliqueMercator)super.clone();
        hotineObliqueMercator._lonc = this._lonc;
        hotineObliqueMercator._azc = this._azc;
        hotineObliqueMercator._k0 = this._k0;
        hotineObliqueMercator._lat0 = this._lat0;
        hotineObliqueMercator._x0 = this._x0;
        hotineObliqueMercator._y0 = this._y0;
        try {
            hotineObliqueMercator.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return hotineObliqueMercator;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new HotineObliqueMercator(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this._lonc);
        this.setValue(3, this._lat0);
        this.setValue(4, this._azc);
        this.setValue(5, this._rectskew);
        this.setValue(6, this._k0);
        this.setValue(7, this._x0);
        this.setValue(8, this._y0);
        return;
    }

    private void a() {
        this._lonc = this.getValue(2);
        this._lat0 = this.getValue(3);
        this._azc = this.getValue(4);
        this._rectskew = this.getValue(5);
        this._k0 = this.getValue(6);
        this._x0 = this.getValue(7);
        this._y0 = this.getValue(8);
        return;
    }

    public HotineObliqueMercator(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public HotineObliqueMercator(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    public HotineObliqueMercator(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7, double d8) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this._lat0 = d3;
        this._azc = d4;
        this._rectskew = d5;
        this._k0 = d6;
        this._lonc = d2;
        this._y0 = d8;
        this._x0 = d7;
        this.init();
    }

    HotineObliqueMercator() {
    }
}

