/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Gnomonic
extends GenericProjection {
    private double c;
    private double f;
    private double d;
    private double e;
    private double a;
    private double b;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = point3D.x - this.d;
        double d3 = Math.sin(point3D.y);
        double d4 = Math.cos(point3D.y);
        double d5 = Math.cos(d2);
        double d6 = this.c * d3 + this.f * d4 * d5;
        if (d6 < 1.0E-12) {
            point3D.x = this.b + 1.0E30;
            point3D.y = this.a + 1.0E30;
        } else {
            double d7 = 1.0 / d6;
            point3D.x = this.b + this._ellipsoid.getRadius() * d7 * d4 * Math.sin(d2);
            point3D.y = this.a + this._ellipsoid.getRadius() * d7 * (this.f * d3 - this.c * d4 * d5);
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        double d2 = Math.sqrt(point3D.x * point3D.x + point3D.y * point3D.y);
        if (Math.abs(d2) < 1.0E-13) {
            point3D.y = this.e;
            point3D.x = this.d;
        } else {
            double d3 = Math.atan2(d2, this._ellipsoid.getRadius());
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            point3D.x = this.d + Math.atan2(point3D.x * d5, d2 * this.f * d4 - point3D.y * this.c * d5);
            point3D.x = Utilities.angle180(point3D.x);
            point3D.y = Math.asin(d4 * this.c + point3D.y * d5 * this.f / d2);
        }
        return;
    }

    public void init() throws ValidationException {
        this.f = Math.cos(this.e);
        this.c = Math.sin(this.e);
        double d2 = this.e + 1.0471975511965976;
        double d3 = this.e - 1.0471975511965976;
        double d4 = this.d - 1.2566370614359172;
        double d5 = this.d + 1.2566370614359172;
        this.makeHorizon(d4, d5, d3, d2);
        return;
    }

    public Gnomonic(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d4;
        this.a = d5;
        this.d = d2;
        this.e = d3;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Gnomonic(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Gnomonic gnomonic = null;
        gnomonic = (Gnomonic)super.clone();
        gnomonic.d = this.d;
        gnomonic.e = this.e;
        gnomonic.a = this.a;
        gnomonic.b = this.b;
        try {
            gnomonic.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return gnomonic;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Gnomonic(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.d);
        this.setValue(3, this.e);
        this.setValue(4, this.b);
        this.setValue(5, this.a);
        return;
    }

    private void a() {
        this.d = this.getValue(2);
        this.e = this.getValue(3);
        this.b = this.getValue(4);
        this.a = this.getValue(5);
        return;
    }

    public Gnomonic(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Gnomonic(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Gnomonic() {
    }
}

