/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseDatumTransformation;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;

public class GeographicOffset
extends BaseDatumTransformation {
    private double a;
    private double b;
    private double c;

    public String getPEString() {
        return "";
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new GeographicOffset(geodeticRow, n2);
    }

    public Object clone() {
        GeographicOffset geographicOffset = null;
        geographicOffset = (GeographicOffset)super.clone();
        geographicOffset.b = this.b;
        geographicOffset.c = this.c;
        geographicOffset.a = this.a;
        return geographicOffset;
    }

    public void inverse(Point3D point3D) throws CalculationException {
        point3D.x -= this.b;
        point3D.y -= this.c;
        point3D.z -= this.a;
        return;
    }

    public void forward(Point3D point3D) throws CalculationException {
        point3D.x += this.b;
        point3D.y += this.c;
        point3D.z += this.a;
        return;
    }

    public GeographicOffset(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        if (geodeticRow.getLength() <= n2 + 2) {
            throw new InvalidRowDataException(geodeticRow);
        }
        try {
            this.b = Double.parseDouble(geodeticRow.getColumn(0 + n2)) * 4.84813681109536E-6;
            this.c = Double.parseDouble(geodeticRow.getColumn(1 + n2)) * 4.84813681109536E-6;
            this.a = Double.parseDouble(geodeticRow.getColumn(2 + n2));
        }
        catch (Exception exception) {
            throw new InvalidRowDataException(geodeticRow);
        }
    }

    GeographicOffset() {
    }
}

